﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Controls;
using Progressive.PecaStarter.ViewModel.Broadcast;

namespace Progressive.PecaStarter.View.WPF.Page
{
    class ComponentsPanel : StackPanel
    {
        public ComponentsPanel()
        {
            DataContextChanged += (sender, e) =>
            {
                var opt = e.NewValue as WebApisViewModel.WebApi.Option;
                switch (opt.Type)
                {
                    case "time_visibility":
                        var checkBox = new CheckBox() { Content = "配信時間を表示する" };
                        checkBox.SetBinding(CheckBox.IsCheckedProperty, "Value");
                        Children.Add(checkBox);
                        break;
                    case "password":
                        var panel = new DockPanel();
                        var password = new PasswordBox();
                        /*
                        opt.PropertyChanged += (sender1, e1) =>
                        {
                            if (e1.PropertyName == "Value")
                            {
                                password.Password = opt.Value;
                            }
                        };
                        */
                        password.PasswordChanged += (sender2, e2) =>
                        {
                            opt.Value = password.Password;
                        };
                        panel.Children.Add(new Label() { Content = "パスワード" });
                        panel.Children.Add(password);
                        Children.Add(panel);
                        break;
                    default:
                        break;
                }
            };
        }
    }
}
