﻿using System.Text;
using Progressive.PecaStarter.Common;

namespace Progressive.PecaStarter.DTO
{
    public class ChannelDTO
    {
        public string Name { get; set; }
        public string Id { get; set; }
        public Type Type { get; set; }
        public string Genre { get; set; }
        public string Description { get; set; }
        public string Url { get; set; }
        public string Comment { get; set; }
        public string TrackTitle { get; set; }
        public string TrackArtist { get; set; }
        public string TrackAlbum { get; set; }
        public string TrackGenre { get; set; }
        public string TrackContact { get; set; }

        public ChannelDTO()
        {
            Name = "";
            Id = "";
            Type = Type.Unknown;
            Genre = "";
            Description = "";
            Url = "";
            Comment = "";
            TrackTitle = "";
            TrackArtist = "";
            TrackAlbum = "";
            TrackGenre = "";
            TrackContact = "";
        }

        public override string ToString()
        {
            return new StringBuilder(Name).Append(" (").Append(Id).Append(')').ToString();
        }
    }
}