﻿using System;
using System.Collections.Generic;
using System.Net;
using Progressive.PecaStarter.DAO;
using Progressive.PecaStarter.Entity;

namespace Progressive.PecaStarter.ViewModel.Broadcast
{
    public class WebApisViewModel : ViewModelBase
    {
        #region variable
        private BroadcastViewModel parent;
        private WebApi selected;
        private List<WebApi> webApis;
        #endregion

        #region property
        public bool IsBroadcast
        {
            get { return parent.IsBroadcast; }
        }
        public WebApi Selected
        {
            get { return selected; }
            set
            {
                selected = value;
                NotifyPropertyChanged("Selected");
                NotifyPropertyChanged("WebApis");
            }
        }
        public List<WebApi> WebApis
        {
            get { return webApis; }
            set
            {
                webApis = value;
                NotifyPropertyChanged("WebApis");
            }
        }
        #endregion

        #region constructor
        public WebApisViewModel(BroadcastViewModel parent)
        {
            this.parent = parent;
            webApis = new List<WebApi>();
            foreach (var ui in new WebApiDAO().Select())
            {
                webApis.Add(new WebApi(ui));
            }
            selected = webApis[0];
        }
        #endregion

        public class WebApi : ViewModelBase
        {
            #region variable
            private webapi definition;
            private bool isEnabled;
            private List<Option> options;
            private int noticeHash;
            #endregion

            #region property
            public webapi Definition { get { return definition; } }
            public string Name { get { return definition.name; } }
            public bool IsEnabled
            {
                get { return isEnabled; }
                set
                {
                    isEnabled = value;
                    NotifyPropertyChanged("IsEnabled");
                }
            }
            public List<Option> Options
            {
                get { return options; }
                set
                {
                    options = value;
                    NotifyPropertyChanged("Options");
                }
            }
            public string NoticeUrl
            {
                get { return definition.notice.url; }
            }
            public bool IsAccepted
            {
                get { return noticeHash != 0; }
                set
                {
                    if (value == false)
                    {
                        noticeHash = 0;
                        return;
                    }
                    noticeHash = -1;
                    var client = new WebClient();
                    client.DownloadStringAsync(new Uri(definition.notice.url));
                    client.DownloadStringCompleted += (sender, e) =>
                    {
                        if (noticeHash != 0)
                        {
                            noticeHash = e.Result.GetHashCode();
                        }
                    };
                    NotifyPropertyChanged("IsAccepted");
                }
            }
            #endregion

            #region constructor
            public WebApi(webapi ui)
            {
                this.definition = ui;
                isEnabled = false;
                options = new List<Option>();
                foreach (var opt in ui.components)
                {
                    options.Add(new Option(opt));
                }
                noticeHash = 0;
            }
            #endregion
            public class Option : ViewModelBase
            {
                #region variable
                private webapi.component ui;
                private string value;
                #endregion

                #region property
                public string Type { get { return ui.type; } }
                public string Content { get { return ui.name; } }
                public string[] Items { get { return ui.items; } }
                public string Value
                {
                    get { return value; }
                    set
                    {
                        if (Type == "time_visibility")
                        {
                            this.value = value == "True" ? "1" : "0";
                        }
                        else
                        {
                            this.value = value;
                        }
                        NotifyPropertyChanged("Value");
                    }
                }
                #endregion

                #region constructor
                public Option(webapi.component ui)
                {
                    this.ui = ui;
                    value = "";
                }
                #endregion
            }
        }
    }
}
