﻿using System;
using System.Diagnostics;
using Progressive.PecaStarter.Common;
using Progressive.PecaStarter.DTO;
using Progressive.PecaStarter.Service;
using System.Text.RegularExpressions;
using Progressive.PecaStarter.Model.Peercast;
using Progressive.PecaStarter.Model;
using System.Collections.Generic;
using System.Collections.Specialized;

namespace Progressive.PecaStarter.ViewModel.Command
{
    class BroadcastCommand : AsyncCommandBase
    {
        public BroadcastCommand(BroadcastViewModel viewModel) : base(viewModel) { }

        public override bool CanExecute(object parameter)
        {
            if (ViewModel.Id != PeercastDefine.NULL_RELAY_ID)
            {
                return false;
            }
            if (!ViewModel.IsAvailable)
            {
                return false;
            }
            if (ViewModel.ExternalSourceViewModel.Url.Text.Length <= 0 ||
                Uri.EscapeDataString(ViewModel.ExternalSourceViewModel.Url.Text).Length > PeercastDefine.MAX_PARAMETER_LENGTH)
            {
                return false;
            }
            return true;
        }

        protected override object AsyncExecute(object parameter)
        {
            ViewModel.Save();
            var yp = ViewModel.YellowPagesViewModel.SelectedYellowPages;
            if (!ViewModel.VisitedSites.Contains(yp.Host) && !String.IsNullOrEmpty(yp.Notice))
            {
                Process.Start(yp.Notice);
                ViewModel.VisitedSites.Add(yp.Host);
                ViewModel.Alert = "利用するYellowPages（以下YP）の注意事項をよく確認してください。\r\n本ソフトウェアは各YPとは一切関係ありません。また、本ソフトウェア並びに制作者はあなたが配信するチャンネルの内容に責任を負いません。";
                return new Tuple<string, DateTime>("", DateTime.MaxValue);
            }
            var externalSource = ViewModel.ExternalSourceViewModel;
            var yellowPages = ViewModel.YellowPagesViewModel;
            var settings = ViewModel.SettingsViewModel;
            var service = new PeercastService();
            if (!externalSource.Url.Text.Contains("http://"))
            {
                externalSource.Url.Text = "http://" + externalSource.Url.Text;
            }
            var id = service.Broadcast(settings.ServerAddress, yellowPages.YellowPageses[yellowPages.SelectedIndex].Host, new BroadcastDTO
            {
                Url = externalSource.Url.Text,
                Name = externalSource.Name.Text,
                Genre = yellowPages.SelectedYellowPages.Prefix + externalSource.Genre.Text,
                Description = externalSource.Description.Text,
                Type = (Common.Type)Enum.Parse(typeof(Common.Type), externalSource.Type)
            });
            var currentTrack = ViewModel.CurrentTrackViewModel;
            service.Update(settings.ServerAddress, yellowPages.YellowPageses[yellowPages.SelectedIndex].Host, new UpdateDTO
            {
                Name = externalSource.Name.Text,
                Genre = ViewModel.YellowPagesViewModel.SelectedYellowPages.Prefix + externalSource.Genre.Text,
                Description = externalSource.Description.Text,
                Url = externalSource.Contact.Text,
                Comment = externalSource.Comment.Text,
                TrackArtist = currentTrack.Artist.Text,
                TrackTitle = currentTrack.Title.Text,
                TrackAlbum = currentTrack.Album.Text,
                TrackGenre = currentTrack.Genre.Text,
                TrackContact = currentTrack.Contact.Text,
            });
            var now = DateTime.Now;
            if (settings.Logging)
            {
                new LogAsyncService().Logging(settings.LogPath, settings.ServerAddress, now, externalSource.Name.Text, externalSource.Genre.Text, externalSource.Description.Text, externalSource.Comment.Text);
            }
            return new Tuple<string, DateTime>(id, now);
        }

        protected override void AsyncCompleted(object result)
        {
            var resultSet = result as Tuple<string, DateTime>;
            if (resultSet.Item1 == "")
            {
                return;
            }
            ViewModel.Id = resultSet.Item1;
            ViewModel.StartAt = resultSet.Item2;
            BroadcastWebApi();
        }

        private void BroadcastWebApi()
        {
            foreach (var webApi in ViewModel.WebApisViewModel.WebApis)
            {
                if (!webApi.IsAccepted || !webApi.IsEnabled)
                {
                    continue;
                }
                var extSrcVM = ViewModel.ExternalSourceViewModel;
                var nv = new NameValueCollection();
                nv.Add("name", extSrcVM.Name.Text);
                nv.Add("tags", extSrcVM.Genre.Text);
                nv.Add("description", extSrcVM.Description.Text);
                nv.Add("comment", extSrcVM.Comment.Text);
                nv.Add("contact_url", extSrcVM.Contact.Text);
                nv.Add("protocol", "Peercast");
                nv.Add("broadcast_url", "http://localhost:7144/pls/" + ViewModel.Id);
                nv.Add("type", extSrcVM.Type);
                nv.Add("password", webApi.Options.Find((i) => { return i.Type == "password"; }).Value);
                nv.Add("time_visibility", webApi.Options.Find((i) => { return i.Type == "time_visibility"; }).Value);
                new WebApi().Post(Array.Find(webApi.Definition.methods, (o) => { return o.type == "start"; }).url, nv);
            }
        }

        private void Add(List<KeyValuePair<string, string>> list, string key, string value)
        {
            list.Add(new KeyValuePair<string, string>(key, value));
        }
    }
}
