<?php
/*
 * This file is part of the petitwork package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Project: petitwork: the PHP lightweight web framework
 * File:    pager.tpl
 *
 * @link http://exbridge.jp/
 * @author S.Tajima <tajima@exbridge.jp>
 * @version svn:$Id: pw_write_pager.tpl 17 2009-05-09 06:21:54Z exbridge $
 * @copyright 2007-2008 Exbridge,Inc.
 */

/**
 * Pager component
 *
 * @param $m->page_id
 * @param $m->count
 * @param $m->pager_action = 'Default'
 **/
if (!function_exists('pw_write_pager')) {
    //paging tags
    define('PW_CP_PAGING_TOTAL_TAG_1', '全%s件');
    define('PW_CP_PAGING_TOTAL_TAG_2', '全%s件　（%s-%s件を表示）');
    define('PW_CP_PAGING_FIRST', '<a href="%s/1">|＜</a>　');
    define('PW_CP_PAGING_PREV',  '<a href="%s/%s">＜</a>　');
    define('PW_CP_PAGING_NOW',   '%s　');
    define('PW_CP_PAGING_POS',   '<a href="%s/%s">%s</a>　');
    define('PW_CP_PAGING_NEXT',  '<a href="%s/%s">＞</a>　');
    define('PW_CP_PAGING_LAST',  '<a href="%s/%s">＞|</a>');
    define('PW_CP_PAGING_CONT',  '…　');
    function pw_write_pager($m) {
        if (is_null($m->pager_action)) {
            $m->pager_action = 'Default';
        }
        $controller = convert_uri(PW_APP . '.php/' . $m->pager_action);
        $limit = PW_DATABASE_PAGEMAX;
        $offset = (($m->page_id - 1) * $limit);

        $buff = array();

        if ($offset == -1) {
            $offset = 1;
        }
        $spos = $offset + 1;
        if ($m->count == 0) {
            $spos = 0;
        }
        $epos = $offset + $limit;
        if ($epos > $m->count) {
            $epos = $m->count;
        }
        if ($m->count == 0) {
            $buff[] = sprintf(PW_CP_PAGING_TOTAL_TAG_1, $m->count);
        }
        else {
            $buff[] = sprintf(PW_CP_PAGING_TOTAL_TAG_2, $m->count, $spos, $epos);
        }

        $pageSpan = 5;
        if ($m->count == 0) {
            return @implode('', $buff);
        }

        //最終ページ算出
        $lastPage = ceil($m->count / $limit);

        //先頭ページへのリンク
        $buff[] = sprintf(PW_CP_PAGING_FIRST, $controller);

        //前ページヘのリンク
        $prePage = 1;
        if ($m->page_id > 1) {
            $prePage = $m->page_id - 1;
        }
        $buff[] = sprintf(PW_CP_PAGING_PREV, $controller,$prePage);

        //ページ番号の制御
        $spos = $m->page_id - floor($pageSpan / 2);
        $epos = $m->page_id + floor($pageSpan / 2);

        //開始位置の調整
        if ($spos < 1) {
            $epos = $epos + ($spos * -1 + 1);
            $spos = 1;
            if ($epos > $lastPage) {
                $epos = $lastPage;
            }
        }

        //終了位置の調整
        if ($epos > $lastPage) {
            $spos = $spos - ($epos - $lastPage);
            $epos = $lastPage;
            if ($spos < 1) {
                $spos = 1;
            }
        }

        //前ページが存在する
        if ($spos > 1) {
            $buff[] = PW_CP_PAGING_CONT;
        }

        //ページ番号のリンク
        for ($i=$spos; $i<=$epos; $i++) {
            if ($m->page_id == $i) {
                $buff[] = sprintf(PW_CP_PAGING_NOW, $i) . '<input type=hidden name=page_id value=' . $i . '>';
            }
            else {
                $buff[] = sprintf(PW_CP_PAGING_POS, $controller, $i, $i);
            }
        }

        //次ページが存在する
        if ($epos < $lastPage) {
            $buff[] = PW_CP_PAGING_CONT;
        }

        //次ページヘのリンク
        $nextPage = $lastPage;
        if ($m->page_id < $lastPage) {
            $nextPage = $m->page_id + 1;
        }
        $buff[] = sprintf(PW_CP_PAGING_NEXT, $controller, $nextPage);

        //最終ページへのリンク
        $buff[] = sprintf(PW_CP_PAGING_LAST, $controller, $lastPage);

        return @implode("\n", $buff);
    }
}
//============================================================================================================================
echo pw_write_pager($m);
?>
