<?php
/*
 * This file is part of the somfa package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Simple O/R Mapping Class
 * PHP versions 5
 * 
 * @package SOMFA
 * @author S.Tajima<tajima@exbridge.jp> 2007/10/23
 * @version svn:$Id: somfaPager.php 17 2009-05-09 06:21:54Z exbridge $
 * @copyright 2007-2008 Exbridge,inc.
 */
class somfaPager
{
    /**
     * pageId
     * @var integer
     * @access private
     */
    var $_page_id = 1;

    /**
     * pageId
     * @var integer
     * @access private
     */
    var $_pager_module = '';

    /**
     * pageId
     * @var integer
     * @access private
     */
    var $_pager_action = '';

    /**
     * somfaModel Object
     * @var integer
     * @access private
     */
    var $_md = null;

    /**
     * limit rows num 
     * -1: unlimited
     * @var integer
     * @access private
     */
    var $_limit = -1;

    /**
     * offset rows num 
     * -1: unlimited
     * @var integer
     * @access private
     */
    var $_offset = -1;

    /**
     * Row Count
     * @var integer
     * @access private
     */
    var $_count = -1;

    /**
     * total infomation
     * @var integer
     * @access private
     */
    var $_total_info = '';

    /**
     * page infomation
     * @var integer
     * @access private
     */
    var $_page_info = '';

    /**
     * Construct
     * @return void
     */
    function somfaPager ($model=null, $page_id=1, $module='', $action='')
    {
        $this->_md = $model;
        $this->_limit = $this->_md->_pager_limit;
        $this->_page_id = is_null($page_id)?1:$page_id;
        $this->_pager_module = $module;
        $this->_pager_action = $action;
    }

    /**
     * settin pageId
     * @return void
     */
    function setPageId($val)
    {
        if (!is_null($val)) {
            $this->_page_id = $val;
        }
    }

    /**
     * get
     * @return void
     */
    function find ($c = null, $bindVars = false)
    {
        $this->_offset = $this->_limit * ($this->_page_id - 1);
        //calc total
        $criteria = new somfaCriteria();
        $criteria->addColumn('count(*) as cnt');
        $criteria->_criterion = $c->_criterion;
        $rs = $this->_md->find($criteria, $bindVars);
        //find
        $this->_count = $rs[0]['cnt'];
        if ($this->_offset >= $this->_count) {
            $this->_page_id = $this->_page_id -1;
            $this->_offset = $this->_limit * ($this->_page_id - 1);
        }
        $this->_md->_limit = $this->_limit;
        $this->_md->_offset = $this->_offset;
        return $this->_md->find($c, $bindVars);
    }
}
