/**
 * @author Administrator
 */
( function(){
	var CLEAN_TARGET_ELEMENT = 'script,style,object,applet,embed,iframe,frame,base,bgsound,frameset,listing'.split( ','),
		root = document.getElementById('wiki-container'),
		navi = document.getElementById('page-navi-container'),
		ELM_BODY_CONTAINER = document.getElementById('page-body-container'),
		titleArray = [],
		elmBuilder = document.createElement( 'div'),
		wikiPageClass = function( id, title, elmNavi, elmAnchor, elmWrapper, elmBody){
			var visible = false;
			titleArray.push( title);
			
			elmAnchor.onclick = jumpPage;
			
			return {
				fixCommentToHtml: function(){
					elmBuilder.innerHTML = elmBody.childNodes[0].nodeValue.replace( /\[\[BR\]\]/g, '');
					cleanElement( elmBuilder);
					moveElement( elmBody);
					delete this.fixCommentToHtml;
				},
				buildInnerLink: function(){
					var jumpArray = elmBody.getElementsByTagName( 'a'),
						l = jumpArray.length,
						_jump, _index;
					for(var i=0; i<l; ++i){
						_jump = jumpArray[i];
						_index = getPageIndexByTitle( _jump.childNodes[0].nodeValue);
						if( _index === -1) continue;
						_jump.href = '#page' +( _index +1);
						_jump.onclick = jumpPage;
						_jump.className += ' internalLink';
					}
					delete this.buildInnerLink;
				},
				show: function( _id){
					if( id === _id && visible === false){
						elmWrapper.className = 'page-wrapper-current';
						elmWrapper.style.display = 'block';
						elmNavi.className = 'page-navi-current';
						ELM_BODY_CONTAINER.appendChild( elmWrapper);
						visible = true;
					}
					if( id !== _id && visible === true){
						elmWrapper.className = 'page-wrapper';
						elmWrapper.style.display = '';
						elmNavi.className = 'page-navi';
						ELM_BODY_CONTAINER.removeChild( elmWrapper);
						visible = false;
					}
				}
			}
		},
		wikiPageArray = ( function(){
			var ret = [],
				_body = document.body,
				_children = navi.getElementsByTagName( 'div'),
				l = _children.length,
				_child, _a, _title, _id, _wrap,
				_page;
				
			_body.appendChild( elmBuilder);

			for(var i=0; i<l; ++i){
				_child = _children[i];
				if( _child.className.indexOf( 'page-navi') !== -1){
					_a = _child.getElementsByTagName( 'a')[0];
					_title = _a ? _a.childNodes[0].nodeValue : null;
					_id = _a ? _a.href.split('#')[1] : null;
					_wrap = document.getElementById( _id);
					_page = new wikiPageClass( _id, _title, _child, _a, _wrap, _wrap.getElementsByTagName( 'div')[1]);
					!document.all && _page.fixCommentToHtml();
					ret.push( _page);
				}
			}
			_body.removeChild( elmBuilder);
			
			return ret;
		})(),
		NUM_PAGE = wikiPageArray.length,
		FRONT_ID = 'FrontPage',
		FRONT_INDEX = getPageIndexByTitle( FRONT_ID) +1,
		jumpArray = root.getElementsByTagName('a'),
		hash = document.location.href.split('#')[1],
		_jump, i;

	// 
	if( !document.all){
		cleanElement( root);
	}
	root = navi = elmBuilder = null;

	// build inner link
	for( i=0; i<NUM_PAGE; ++i){
		wikiPageArray[i].buildInnerLink();
	}
	
	// externalLink
	for( i=0, l = jumpArray.length; i<l; ++i){
		_jump = jumpArray[i];
		if( _jump.href.indexOf('#page') === -1 ){
			_jump.target = '_blank';
			_jump.className += ' externalLink';
		}
	}
	jumpArray = _jump = null;
	
	// show current
	setTimeout(
		function(){
			jumpPage( hash && hash.match( /page\d/) ? hash : 'page' +FRONT_INDEX);
			hash = null;
		}
	);
	
	function moveElement( _targetElm){
		var _elms = _targetElm.childNodes;
		while( _elms.length > 0){
			_targetElm.removeChild( _elms[ 0]);
		}		
		
		_elms = elmBuilder.childNodes;
		while( _elms.length > 0){
			_targetElm.appendChild( _elms[0]);
		}
		cleanElement( elmBuilder);
	}
	function cleanElement( _targetElm){
		var l = CLEAN_TARGET_ELEMENT.length,
			elms, elm, i;
		for( i=0; i<l; ++i){
			elms = _targetElm.getElementsByTagName( CLEAN_TARGET_ELEMENT[ i]);
			while( elms.length > 0){
				elm = elms[ 0];
				elm.parentNode && elm.parentNode.removeChild( elm);
			}
		}
		if( !document.all) return;
		elms = _targetElm.getElementsByName( '*');
		l = elms.length;
		for(i=0; i<l; ++i){
			elm = elms[ i];
			elm.style.filter = elm.style.behavior = '';
		}
	}
	function getPageIndexByTitle( _title){
		for(var i=0; i<NUM_PAGE; ++i){
			if( titleArray[ i] === _title) return i;
		}
		return -1;
	}
	function jumpPage( id){
		var id = typeof id === 'string' ? id : this.href.split('#')[1];
		for(var i=0; i<NUM_PAGE; ++i){
			wikiPageArray[i].show( id);
		}
		return false;
	}
})();



/* Smooth scrolling
   Changes links that link to other parts of this page to scroll
   smoothly to those links rather than jump to them directly, which
   can be a little disorienting.
   
   sil, http://www.kryogenix.org/
   
   v1.0 2003-11-11
   v1.1 2005-06-16 wrap it up in an object
*/

var ss = {
  fixAllLinks: function() {
    // Get a list of all links in the page
    var allLinks = document.getElementsByTagName('a');
    // Walk through the list
    for (var i=0;i<allLinks.length;i++) {
      var lnk = allLinks[i];
      if ((lnk.href && lnk.href.indexOf('#') != -1) && 
          ( (lnk.pathname == location.pathname) ||
	    ('/'+lnk.pathname == location.pathname) ) && 
          (lnk.search == location.search)) {
        // If the link is internal to the page (begins in #)
        // then attach the smoothScroll function as an onclick
        // event handler
        ss.addEvent(lnk,'click',ss.smoothScroll);
      }
    }
  },

  smoothScroll: function(e) {
    // This is an event handler; get the clicked on element,
    // in a cross-browser fashion
    if (window.event) {
      target = window.event.srcElement;
    } else if (e) {
      target = e.target;
    } else return;

    // Make sure that the target is an element, not a text node
    // within an element
    if (target.nodeName.toLowerCase() != 'a') {
      target = target.parentNode;
    }
  
    // Paranoia; check this is an A tag
    if (target.nodeName.toLowerCase() != 'a') return;
  
    // Find the <a name> tag corresponding to this href
    // First strip off the hash (first character)
    anchor = target.hash.substr(1);
    // Now loop all A tags until we find one with that name
    var allLinks = document.getElementsByTagName('a');
    var destinationLink = null;
    for (var i=0;i<allLinks.length;i++) {
      var lnk = allLinks[i];
      if (lnk.name && (lnk.name == anchor)) {
        destinationLink = lnk;
        break;
      }
    }
    if (!destinationLink) destinationLink = document.getElementById(anchor);

    // If we didn't find a destination, give up and let the browser do
    // its thing
    if (!destinationLink) return true;
  
    // Find the destination's position
    var destx = destinationLink.offsetLeft; 
    var desty = destinationLink.offsetTop;
    var thisNode = destinationLink;
    while (thisNode.offsetParent && 
          (thisNode.offsetParent != document.body)) {
      thisNode = thisNode.offsetParent;
      destx += thisNode.offsetLeft;
      desty += thisNode.offsetTop;
    }
  
    // Stop any current scrolling
    clearInterval(ss.INTERVAL);
  
    cypos = ss.getCurrentYPos();
  
    ss_stepsize = parseInt((desty-cypos)/ss.STEPS);
    ss.INTERVAL = setInterval('ss.scrollWindow('+ss_stepsize+','+desty+',"'+anchor+'")',10);

    // And stop the actual click happening
    if (window.event) {
      window.event.cancelBubble = true;
      window.event.returnValue = false;
    }
    if (e && e.preventDefault && e.stopPropagation) {
      e.preventDefault();
      e.stopPropagation();
    }
  },

  scrollWindow: function(scramount,dest,anchor) {
    wascypos = ss.getCurrentYPos();
    isAbove = (wascypos < dest);
    window.scrollTo(0,wascypos + scramount);
    iscypos = ss.getCurrentYPos();
    isAboveNow = (iscypos < dest);
    if ((isAbove != isAboveNow) || (wascypos == iscypos)) {
      // if we've just scrolled past the destination, or
      // we haven't moved from the lpageWrapperArraycroll (i.e., we're at the
      // bottom of the page) then scroll exactly to the link
      window.scrollTo(0,dest);
      // cancel the repeating timer
      clearInterval(ss.INTERVAL);
      // and jump to the link directly so the URL's right
      location.hash = anchor;
    }
  },

  getCurrentYPos: function() {
    if (document.body && document.body.scrollTop)
      return document.body.scrollTop;
    if (document.documentElement && document.documentElement.scrollTop)
      return document.documentElement.scrollTop;
    if (window.pageYOffset)
      return window.pageYOffset;
    return 0;
  },

  addEvent: function(elm, evType, fn, useCapture) {
    // addEvent and removeEvent
    // cross-browser event handling for IE5+,  NS6 and Mozilla
    // By Scott Andrew
    if (elm.addEventListener){
      elm.addEventListener(evType, fn, useCapture);
      return true;
    } else if (elm.attachEvent){
      var r = elm.attachEvent("on"+evType, fn);
      return r;
    } else {
      alert("Handler could not be removed");
    }
  }
}

ss.STEPS = 25;

ss.addEvent(window,"load",ss.fixAllLinks);
