﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns="http://www.w3.org/1999/xhtml"> 
    <xsl:output 
        omit-xml-declaration="no" 
        encoding="utf-8" 
        method="html" 
        version="1.0" 
        doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" 
        doctype-system="http://www.w3.org/TR/html4/loose.dtd" 
        indent="yes" /> 
    <xsl:template match="/">
        <xsl:apply-templates/>
    </xsl:template>
	
<xsl:template match="diary">
	<html xmlns:v="urn:schemas-microsoft-com:vml">
		<head>
			<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
			<meta http-equiv="Content-Style-Type" content="text/css" />
			<meta http-equiv="imagetoolbar" content="no" />
			<meta name="description">
				<xsl:attribute name="content">
					<xsl:value-of select="@description" />
				</xsl:attribute>
			</meta>
			<title>
				<xsl:value-of select="@title" />
	            <xsl:if test="@author">
	                <xsl:value-of select="concat(' | ',@author)"/>
	            </xsl:if>
			</title>
			<link rel='index' title='index | pettanR' href='http://pettanr.sourceforge.jp/index.html' />
			<link rel='start' title='pettanR' href='http://pettanr.sourceforge.jp/' />
			<link rel="stylesheet" type="text/css" href="../stylesheets/site.css" />
			<link rel="stylesheet" type="text/css" href="../stylesheets/peta.common.css" />
			<link rel="stylesheet" type="text/css" href="../stylesheets/system.css" />
		</head>
		<body>
			<div id="general-content">
				<div id="outer-wrapper">
					
					<div id="header">
						<div class="base-content-width" style="position:relative;">
							<h1><a href="http://pettanr.sourceforge.jp/">pettanR</a></h1>
							<div id="global-navi">
								<noscript id="noscript-alert">You need to have JavaScript enabled.</noscript>
							</div>
						</div>
					</div>
					
					<div id="inner-wrapper" class="base-content-width">
						<div id="main">
							<h2><xsl:value-of select="@title" /></h2>
							<dl class="dl-table clearfix">
								<dt>author</dt>
								<dd><xsl:value-of select="@author" /></dd>
								<dt>description</dt>
								<dd><xsl:value-of select="@description" /></dd>
								<dt>published</dt>
								<dd><xsl:value-of select="@published" /></dd>
								<dt>updated</dt>
								<dd><xsl:value-of select="@direction" /></dd>
							</dl>
							
							<xsl:apply-templates/>
						</div>
					</div>
				</div>
			</div>
			
			<div id="footer-content"><!-- #BeginLibraryItem "/Library/footer.lbi" -->

        <div id="footer">
            <div id="footer-item-container" class="base-content-width clearfix">
                <div class="footer-item-wrapper">
                    <div class="footer-item">
                        <h2>ぺったんR にようこそ</h2>
                        <ul>
                            <li>サンプル</li>
                            <li>ぺったんRの特徴</li>
                            <li>沿革</li>
                        </ul>
                        <h2>Test</h2>
                        <ul>
                            <li><a href="../test/index.html">Test Index</a></li>
                        </ul>
                    </div>
                </div>
                <div class="footer-item-wrapper">
                    <div class="footer-item">
                        <h2>ドキュメント</h2>
                        <ul>
                            <li><a href="http://sourceforge.jp/projects/pettanr/wiki/ForAuthors" rel="me" target="_blank">作家向けドキュメント</a></li>
                            <li>絵師向けドキュメント</li>							
                            <li><a href="http://sourceforge.jp/projects/pettanr/wiki/ForDevelopers" rel="me" target="_blank">開発者向けドキュメント</a></li>
                            <li><a href="http://sourceforge.jp/projects/pettanr/wiki/ForWebmasters" rel="me" target="_blank">編集長向けドキュメント</a></li>
                        </ul>
                    </div>
                </div>
                <div class="footer-item-wrapper">
                    <div class="footer-item">
                        <h2>プロトタイプ</h2>
                        <ul>
                            <li><a href="http://pettanr.heroku.com/" rel="me" target="_blank">pettanr.heroku.com</a></li>
                            <li><a href="../work.html" rel="console">ユーザーコンソール</a></li>
                        </ul>
                        <h2>Ajax contents</h2>
                        <ul>
                            <li><a href="../help/jp.xml">help | jp</a></li>
                        </ul>
                    </div>
                </div>
                <div class="footer-item-wrapper" style="width:170px;">
                    <div class="footer-item" style="padding-right:0;">
                        <h2>ぺったんRチーム</h2>
                        <ul>
                            <li>わたしたちについて</li>
                            <li>ミッション</li>
                            <li><a href="itozyun.xml">itozyun's diary</a></li>
                            <li>個人情報保護方針</li>
                            <li>作品の取り扱い</li>
                            <li>お問い合わせ</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div id="copyright">Copyright (c) 2011-2012 pettanR team, some rights reserved.</div>
        </div><!-- #EndLibraryItem --></div>
			<script type="text/javascript" src="../javascripts/common.js"></script>
		</body>
	</html>
</xsl:template>

    <xsl:template match="entry">
		<xsl:for-each select=".">
			<h3><xsl:value-of select="@pubdate"/></h3>
			<pre><xsl:apply-templates/></pre>
		</xsl:for-each>		
    </xsl:template>

</xsl:stylesheet>