﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:rss="http://purl.org/rss/1.0/"
  xmlns:dc="http://purl.org/dc/elements/1.1/"
  xmlns:content="http://purl.org/rss/1.0/modules/content/"
  exclude-result-prefixes="rdf rss dc content"
>
    <xsl:output 
        omit-xml-declaration="no" 
        encoding="utf-8" 
        method="html" 
        version="1.0" 
        doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" 
        doctype-system="http://www.w3.org/TR/html4/loose.dtd" 
        indent="yes" />
        
<xsl:template match="rdf:RDF">
  <html xmlns:v="urn:schemas-microsoft-com:vml">
  <head>
			<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
			<meta http-equiv="Content-Style-Type" content="text/css" />
			<meta http-equiv="imagetoolbar" content="no" />
			<meta name="description">
				<xsl:attribute name="content">
					<xsl:value-of select="rss:channel/rss:description" />
				</xsl:attribute>
			</meta>
			<title><xsl:value-of select="rss:channel/rss:title"/></title>
			<link rel="stylesheet" type="text/css" href="../stylesheets/site.css" />
			<link rel="stylesheet" type="text/css" href="../stylesheets/peta.common.css" />
			<link rel="stylesheet" type="text/css" href="../stylesheets/system.css" />
			<link rel="stylesheet" href="wiki.css" type="text/css" />
  </head>
  <body>
			<div id="general-content">
				<div id="outer-wrapper">
					
					<div id="header">
						<div class="base-content-width" style="position:relative;">
							<h1><a href="../index.html"><xsl:value-of select="rss:channel/rss:title"/></a></h1>
							<div id="global-navi">
								<noscript id="noscript-alert">You need to have JavaScript enabled.</noscript>
							</div>
						</div>
					</div>
					
					<div id="inner-wrapper" class="base-content-width">						
						<div id="wiki-container" class="clearfix">
							<ul id="page-navi-container">
								<li id="page-total">
									<xsl:value-of select="count(rss:item)"/> pages
									<span id="boot-time"></span>
								</li>
								<xsl:for-each select="./rss:item">
									<xsl:variable name="index" select="position()"/>
									<xsl:variable name="top" select="25*$index"/>
									<li class="page-navi">
										<a>
											<xsl:attribute name="href">
												<xsl:value-of select="concat('#page',$index)"/>
											</xsl:attribute>	
											<xsl:value-of select="rss:title"/>
										</a>
									</li>										
								</xsl:for-each>
							</ul>
							<div id="page-body-container">
								<xsl:for-each select="./rss:item">
									<div class="page-wrapper">
										<xsl:variable name="index" select="position()"/>
										<xsl:variable name="top" select="25*$index"/>
										<xsl:attribute name="id">
											<xsl:value-of select="concat('page',$index)"/>
										</xsl:attribute>

										<div class="page-header clearfix">
											<span class="page-title"><xsl:value-of select="rss:title"/></span>
											<span class="page-date"><xsl:value-of select="substring(dc:date, 1, 10)" /></span>
										</div>
										
										<div class="page-body main clearfix">
											<xsl:value-of select="content:encoded" disable-output-escaping="yes"/>
										</div>
										<a class="jump-to-top">
                                            <xsl:attribute name="href">
                                                <xsl:value-of select="concat('#page',$index)"/>
                                            </xsl:attribute>
                                            top
										</a>
									</div>
								</xsl:for-each>
							</div>
						</div>
					</div>
					
				</div>
			</div>

	
			<div id="footer-content">
				<!-- #BeginLibraryItem "/Library/footer.lbi" -->
				<div id="footer">
						<div id="footer-item-container" class="base-content-width clearfix">
								<div class="footer-item-wrapper">
										<div class="footer-item">
												<h2>ぺったんR にようこそ</h2>
												<ul>
														<li>サンプル</li>
														<li>ぺったんRの特徴</li>
														<li>沿革</li>
												</ul>
												<h2>Test</h2>
												<ul>
														<li><a href="../test/index.html">Test Index</a></li>
												</ul>
										</div>
								</div>
								<div class="footer-item-wrapper">
										<div class="footer-item">
												<h2>ドキュメント</h2>
												<ul>
														<li><a href="http://sourceforge.jp/projects/pettanr/wiki/ForAuthors" rel="me" target="_blank">作家向けドキュメント</a></li>
														<li>絵師向けドキュメント</li>
														<li><a href="http://sourceforge.jp/projects/pettanr/wiki/ForDevelopers" rel="me" target="_blank">開発者向けドキュメント</a></li>
														<li><a href="http://sourceforge.jp/projects/pettanr/wiki/ForWebmasters" rel="me" target="_blank">編集長向けドキュメント</a></li>
												</ul>
										</div>
								</div>
								<div class="footer-item-wrapper">
										<div class="footer-item">
												<h2>プロトタイプ</h2>
												<ul>
														<li><a href="http://pettanr.heroku.com/" rel="me" target="_blank">pettanr.heroku.com</a></li>
														<li><a href="../work.html" rel="console">ユーザーコンソール</a></li>
												</ul>
												<h2>Ajax contents</h2>
												<ul>
														<li><a href="../help/jp.xml">help | jp</a></li>
												</ul>
										</div>
								</div>
								<div class="footer-item-wrapper" style="width:170px;">
										<div class="footer-item" style="padding-right:0;">
												<h2>ぺったんRチーム</h2>
												<ul>
														<li>わたしたちについて</li>
														<li>ミッション</li>
														<li><a href="../diary/itozyun.xml">itozyun's diary</a></li>
														<li>個人情報保護方針</li>
														<li>作品の取り扱い</li>
														<li>お問い合わせ</li>
												</ul>
										</div>
								</div>
						</div>
						<div id="copyright">Copyright (c) 2011-2012 pettanR team, some rights reserved.</div>
				</div>
				<!-- #EndLibraryItem -->
			</div>
			
			<script type="text/javascript" src="wiki.js"></script>
		</body>
	</html>
</xsl:template>

</xsl:stylesheet>