﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns="http://www.w3.org/1999/xhtml"> 
    <xsl:output 
        omit-xml-declaration="no" 
        encoding="utf-8" 
        method="html" 
        version="1.0" 
        doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" 
        doctype-system="http://www.w3.org/TR/html4/loose.dtd" 
        indent="yes" /> 
    <xsl:template match="/">
        <xsl:apply-templates/>
    </xsl:template>

<xsl:template match="comic">
	<html>
		<head>
			<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
			<meta http-equiv="Content-Style-Type" content="text/css" />
			<meta http-equiv="imagetoolbar" content="no" />
					
			<title>
	            <xsl:if test="@subtitle">
	                <xsl:value-of select="concat(@episode,' | ')"/>
	            </xsl:if>
				<xsl:value-of select="@title" />
	            <xsl:if test="@author">
	                <xsl:value-of select="concat(' | ',@author)"/>
	            </xsl:if>
			</title>
	
			<link href="pettanr.css" rel="stylesheet" type="text/css" />
	
		</head>
		<body>
			<h1><xsl:value-of select="@title" /></h1>
			<h2><xsl:value-of select="@episode" /></h2>
			<p class='author'>author:<xsl:value-of select="@author" /></p>
			
			<div id="panelContainer">
				<xsl:attribute name="style">
					<xsl:value-of select="concat('width:',@w,'px;')"/>
				</xsl:attribute>
				
				<xsl:apply-templates/>
			</div>			
			
			<div id="footer">
				(c)<xsl:value-of select="/comic/@author" /> , flash publishing system 'pettan' is powered by pettan_dev.
			</div>
		</body>
	</html>
</xsl:template>

    <xsl:template match="panel">
    	<div class="panel-wrapper">
			<xsl:for-each select=".">
				<div class="panel">
					<xsl:variable name="height" select="concat('height:',@h,'px;')" />
					<xsl:variable name="bgcolor" select="concat('background-color:',@bgcolor,';')" />
					<xsl:attribute name="style">
						<xsl:value-of select="concat($height,$bgcolor)"/>
					</xsl:attribute>
					<xsl:apply-templates/>
				</div>
			</xsl:for-each>
			<xsl:for-each select="./picture">
				<xsl:if test="@name">
					
					<div class="tooltip-container">
						<xsl:comment><![CDATA[[if lte IE 6]><a href="#"><table><tr><td><![endif]]]></xsl:comment>
						<img src="4x4.gif" class="image-shadow"><!-- 当初divで書いていたら、ie5.5～8で正しくレンダリングできない。なぜかDomが狂う、、、xsl:attribute name="style"が頭にきたせい? -->
							<xsl:attribute name="width">
								<xsl:value-of select="@w"/>
							</xsl:attribute>
							<xsl:attribute name="height">
								<xsl:value-of select="@h"/>
							</xsl:attribute>
							<xsl:attribute name="style">
								<xsl:value-of select="concat('left:',@x,'px;','top:',@y,'px;')"/>
							</xsl:attribute>
						</img>
						<dl class="tooltip">
							<xsl:attribute name="style">
								<xsl:value-of select="concat('margin-left:',position(),'9px;left:',/comic/@w,'px;','top:',@y,'px;')"/><!-- 要素が完全に重なることを防ぐためにposition()で要素のindexを取ってmargin-leftしている -->
							</xsl:attribute>
							<dt>作品名</dt>
							<dd><xsl:value-of select="@name" /></dd>
							<dt>作者</dt>
							<dd><xsl:value-of select="@author" /></dd>
							<dt>サイト</dt>
							<dd><xsl:value-of select="@site" /></dd>
						</dl>
						<xsl:comment><![CDATA[[if lte IE 6]></td></tr></table></a><![endif]]]></xsl:comment>
					</div>
					
				</xsl:if>
			</xsl:for-each>
		</div>
    </xsl:template>

    <xsl:template match="picture">
		<xsl:for-each select=".">
			<img>
				<xsl:attribute name="src">
					<xsl:value-of select="@url"/>
				</xsl:attribute>
				<xsl:attribute name="width">
					<xsl:value-of select="@w"/>
				</xsl:attribute>
				<xsl:attribute name="height">
					<xsl:value-of select="@h"/>
				</xsl:attribute>
				<xsl:variable name="left" select="concat('left:',@x,'px;')" />				
				<xsl:variable name="top" select="concat('top:',@y,'px;')" />	
				<xsl:attribute name="style">
					<xsl:value-of select="concat($left,$top)"/>
				</xsl:attribute>
			</img>
		</xsl:for-each>		
    </xsl:template>

    <xsl:template match="balloon">
		<xsl:for-each select=".">
			<img>
		        <xsl:variable name="type">
		            <xsl:if test="contains(@type,'0')">fukidasi/mfuki</xsl:if>
		            <xsl:if test="contains(@type,'1')">fukidasi/omoiFuki</xsl:if>
		        </xsl:variable>
				<xsl:attribute name="src">
					<xsl:value-of select="concat($type,@tail,'.gif')"/>
				</xsl:attribute>
				<xsl:attribute name="width">
					<xsl:value-of select="@w"/>
				</xsl:attribute>
				<xsl:attribute name="height">
					<xsl:value-of select="@h"/>
				</xsl:attribute>
				<xsl:variable name="left" select="concat('left:',@x,'px;')" />			
				<xsl:variable name="top" select="concat('top:',@y,'px;')" />
				<xsl:attribute name="style">
					<xsl:value-of select="concat($top,$left)"/>
				</xsl:attribute>
			</img>
			
			<div class="speach">
				<xsl:variable name="width" select="concat('width:',@w,'px;')" />			
				<xsl:variable name="height" select="concat('height:',@h,'px;')" />
				<xsl:variable name="left2" select="concat('left:',@x,'px;')" />			
				<xsl:variable name="top2" select="concat('top:',@y,'px;')" />	
				<xsl:variable name="fontsize">
		            <xsl:if test="@size">
		                <xsl:value-of select="concat('font-size:',@size,'px;')"/>
		            </xsl:if>
				</xsl:variable>
				<xsl:variable name="fontbold">
		            <xsl:if test="@bold">font-weight:bold;</xsl:if>
				</xsl:variable>
				<xsl:attribute name="style">
					<xsl:value-of select="concat($width,$height,$top2,$left2,$fontsize,$fontbold)"/>
				</xsl:attribute>
				<xsl:comment><![CDATA[[if lte IE 7]><table><tr><td><![endif]]]></xsl:comment>
					<span>
					<xsl:apply-templates/>
					</span>
				<xsl:comment><![CDATA[[if lte IE 7]></td></tr></table><![endif]]]></xsl:comment>
			</div>
		</xsl:for-each>		
    </xsl:template>

</xsl:stylesheet>