/*
file	get_ct_value-y.c
version	0.5
author	NORIYA Yokohama
date	2007.02.05
brief	Get CT value in ROI
	Not using OpenCV lib.
	Add adapted "rescale Intercept(0028,1052)" tag
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MIN_VALUE -35535
#define MAX_VALUE 35535


int main(int argc, char *argv[])
{
	if (argc<6){
		fprintf(stderr, "usage: %s start_x start_y end_x end_y src-file\n", argv[0]);
		return -1;
	}
	

	int bitA, i, j, x, y, count; 
	int minPx, minPy, maxPx, maxPy;
	unsigned int w, h;
	int flag1=0, flag2=0, flag3=0, flag4=0, flag5=0;
	unsigned char buf[4], gtag1, gtag2, etag1, etag2;
	char filename[256];
	long len;
	static short *img;
	static double ave, min, max, tmp;
	double rescale = 0;

	FILE *fp;

	//read file name and parameters.
	strcpy(filename,argv[5]);

	int xs = atoi(argv[1]);
	int ys = atoi(argv[2]);
	int xe = atoi(argv[3]);
	int ye = atoi(argv[4]);

	if(xs < xe){
		minPx = xs; maxPx = xe;
	}
	else{
		minPx = xe; maxPx = xs;
	}
        if(ys < ye){
                minPy = ys; maxPy = ye;
        }
        else{
                minPy = ye; maxPy = ys;
        }
	w = abs(maxPx - minPx);
	h = abs(maxPy - minPy);

	//read DICOM file
	if((fp=fopen(filename, "rb")) == NULL){
		printf("Open failed %s\n", filename);
		exit(0);
	}

	while(flag1 == 0 || flag2 == 0 || flag3 == 0 || flag4 == 0 || flag5 == 0){
		fread(buf, sizeof(unsigned char), 1, fp);
		gtag1 = *(unsigned char*)buf;

		//get group number. 0x0028
		if(gtag1 == 0x28){
			//printf("get group number\n");
			fread(buf, sizeof(unsigned char), 1, fp);
			gtag2 =  *(unsigned char*)buf;
			if(gtag2 == 0x00){
				fread(buf, sizeof(unsigned char), 1, fp);
				etag1 = *(unsigned char*)buf;
				
				//get rows. 0x0010
				//printf("get rows\n");
				if(etag1 == 0x10){
					fread(buf, sizeof(unsigned char), 1, fp);
					etag2 = *(unsigned char*)buf;
					if(etag2 == 0x00){
                                               	fread(buf, sizeof(unsigned char), 4, fp);
						len = *(long*)buf;
						fread(buf, sizeof(unsigned char), len, fp);
						y = *(int*)buf;
						flag1 = 1;
					}
				}
		
                                //get col. 0x0011
                                else if(etag1 == 0x11){
               		        	//printf("get col\n");
			      		fread(buf, sizeof(unsigned char), 1, fp);
                                        etag2 = *(unsigned char*)buf;
                                        if(etag2 == 0x00){
                       		                fread(buf, sizeof(unsigned char), 4, fp);
                                	        len = *(long*)buf;
                                        	fread(buf, sizeof(unsigned char), len, fp);
                                    		x = *(int*)buf;
                                                flag2 = 1;
                                	}
                                }

                                //get bit allocate. 0x0100
                                else if(etag1 == 0x00){
					//printf("get bitAllocate\n");
                                	fread(buf, sizeof(unsigned char), 1, fp);
                                	etag2 = *(unsigned char*)buf;
                                	if(etag2 == 0x01){
                                        	fread(buf, sizeof(unsigned char), 4, fp);
                                        	len = *(long*)buf;
                                        	fread(buf, sizeof(unsigned char), len, fp);
                                        	bitA = *(int*)buf;
                                        	flag3 = 1;
                                        }
                                }
				
				//get image padding 0x1052
				else if(etag1 == 0x52){
					fread(buf, sizeof(unsigned char), 1, fp);
					etag2 = *(unsigned char*)buf;
					if(etag2 == 0x10){
						fread(buf, sizeof(unsigned char), 4, fp);
						len = *(long*)buf;
						printf("Len: %d \n", len); 
						fread(buf, sizeof(unsigned char), len, fp);
						rescale =  *(double*)buf;
						printf("Rescale: %f \n", rescale);
						flag4 = 1;
			
					}
				}
				else{
				  flag4 = 1;
				}
			}
		}
			
		//get group number 0x7FE0
		else if(gtag1 == 0xE0){
			//printf("group number(0x7FE0)\n");
			fread(buf, sizeof(unsigned char), 1, fp);
			gtag2 =  *(unsigned char*)buf;
			if(gtag2 == 0x7F){
				//printf("get number(0x7F)\n");
				fread(buf, sizeof(unsigned char), 1, fp);
				etag1 = *(unsigned char*)buf;

				//get image value 0x0010
				if(etag1 == 0x10){
					fread(buf, sizeof(unsigned char), 1, fp);
					etag2 = *(unsigned char*)buf;
					if(etag2 == 0x00){
						fread(buf, sizeof(unsigned char), 4, fp);
						len = *(long*)buf;
						img = (short*)malloc(len);
						fread(img, 1, len, fp);
						flag5 = 1;
					}
				}
			}
		}
	}
	fclose(fp);

	//printf("x:%d, y:%d, w:%d, h:%d\n", minPx, minPy, w, h);
	//printf("Size x:%d \n", x);
	//printf("Size y: %d \n", y);
	//	printf("Bit Allocate: %d \n", bitA);
	//	printf("Rescale: %d \n", rescale);
 
	min = MAX_VALUE; max = MIN_VALUE; count = 0;
	for(i=0; i<y; i++){
		for(j=0; j<x; j++){
			//printf("i:%d,j:%d, value:%d \n",i,j, *img);
			if(minPy<i && i<maxPy && minPx<j && j<maxPx){
				if(*img + rescale < min + rescale ) min = *img + rescale;
				if(*img + rescale > max + rescale ) max = *img + rescale;
				tmp = tmp + *img + rescale;
				count++;
				//printf("i:%d,j:%d, value:%d \n",i,j, *img);
			}
			img++;
		}
	}
	ave = tmp / count;

	//printf("avarage:%f, min value:%f, max value:%f \n", ave, min, max);
	printf("%f, %f, %f \n", ave, min, max);

	//free(img);
	return 0;
}
