/*
 * Decompiled with CFR 0.152.
 */
package TCPIP_Discoverer;

import TCPIP_Discoverer.TCPIPAboutBox;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TCPIPDiscovererTool
extends JFrame {
    public static DatagramSocket socket;
    public static DatagramPacket packet;
    public static DefaultTableModel model;
    public static Thread recvThread;
    public static Thread manageTable;
    public static String mchipUrl;
    String str = new String("Discovery: Who is out there?\u0000\n");
    String received = " ";
    long threadSleep = 500L;
    ReentrantLock lock = new ReentrantLock();
    ImageIcon icon = new ImageIcon(this.getClass().getResource("/Resource/mchpIcon.png"));
    private JButton btnDiscover;
    private JButton btnExit;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public TCPIPDiscovererTool() {
        this.initComponents();
        this.changeTableColumnWidth();
        this.setIconImage(this.icon.getImage());
        this.udpAction();
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        this.setLocation(200, 150);
    }

    public void addDiscoveryEntry(String receivePacket) {
        Object[] s = receivePacket.split("\n");
        if (s[3].contains("                                                                ")) {
            s[3] = "";
        }
        model = (DefaultTableModel)this.jTable1.getModel();
        int rowCnt = model.getRowCount();
        for (int index = 0; index < rowCnt; ++index) {
            String macAddrs = (String)model.getValueAt(index, 2);
            if (macAddrs.isEmpty() || !((String)s[2]).contentEquals(macAddrs)) continue;
            model.removeRow(index);
            model.insertRow(index, s);
            return;
        }
        model.insertRow(0, s);
    }

    /*
     * Unable to fully structure code
     */
    public void receiveUDPPacket() {
        try {
            buf = new byte[100];
            for (i = 0; i < buf.length; ++i) {
                buf[i] = 32;
            }
            TCPIPDiscovererTool.packet = new DatagramPacket(buf, buf.length);
            TCPIPDiscovererTool.socket.receive(TCPIPDiscovererTool.packet);
            this.received = new String(TCPIPDiscovererTool.packet.getData());
            while (true) {
                for (i = 0; i < buf.length; ++i) {
                    buf[i] = 32;
                }
                TCPIPDiscovererTool.packet = new DatagramPacket(buf, buf.length);
                try {
                    TCPIPDiscovererTool.socket.receive(TCPIPDiscovererTool.packet);
                }
                catch (SocketTimeoutException var2_4) {
                    // empty catch block
                }
                if (new String(TCPIPDiscovererTool.packet.getData()).trim().length() == 0 || TCPIPDiscovererTool.packet.getLength() < 36) ** continue;
                this.received = new String(TCPIPDiscovererTool.packet.getData());
                if (this.received.isEmpty()) ** continue;
                this.lock.lock();
                this.received = TCPIPDiscovererTool.packet.getAddress().getHostAddress() + "\n" + this.received.replace("\r\n", "\n");
                this.addDiscoveryEntry(this.received);
                this.received = " ";
                this.lock.unlock();
            }
        }
        catch (IOException e) {
            this.close_action();
            return;
        }
    }

    public void udpAction() {
        try {
            recvThread = new Thread(){

                public void run() {
                    TCPIPDiscovererTool.this.receiveUDPPacket();
                }
            };
            manageTable = new Thread(){

                public void run() {
                    while (true) {
                        if (TCPIPDiscovererTool.this.received.trim().isEmpty() || TCPIPDiscovererTool.this.received.isEmpty()) {
                            continue;
                        }
                        String[] s = TCPIPDiscovererTool.this.received.split("\n");
                        if (s[1].trim().isEmpty()) {
                            TCPIPDiscovererTool.this.received = " ";
                            continue;
                        }
                        TCPIPDiscovererTool.this.lock.lock();
                        TCPIPDiscovererTool.this.addDiscoveryEntry(TCPIPDiscovererTool.this.received);
                        TCPIPDiscovererTool.this.received = " ";
                        TCPIPDiscovererTool.this.lock.unlock();
                    }
                }
            };
            socket = new DatagramSocket(30303);
            socket.setBroadcast(true);
            InetAddress address = InetAddress.getByName("255.255.255.255");
            packet = new DatagramPacket(this.str.getBytes(), this.str.length(), address, 30303);
            socket.send(packet);
            recvThread.start();
        }
        catch (IOException e) {
            String optionStr = "<html>Unable to transmit discovery message. <br> Check network connectivity and ensure that no other instances of this program are running.";
            JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
            this.close_action();
        }
    }

    private void initComponents() {
        this.btnExit = new JButton();
        this.btnDiscover = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Microchip TCPIP Discoverer");
        this.setResizable(false);
        this.btnExit.setText("Exit");
        this.btnExit.setMaximumSize(new Dimension(115, 23));
        this.btnExit.setMinimumSize(new Dimension(115, 23));
        this.btnExit.setPreferredSize(new Dimension(115, 23));
        this.btnExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TCPIPDiscovererTool.this.btnExitActionPerformed(evt);
            }
        });
        this.btnDiscover.setText("Discover Devices");
        this.btnDiscover.setCursor(new Cursor(0));
        this.btnDiscover.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TCPIPDiscovererTool.this.btnDiscoverActionPerformed(evt);
            }
        });
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"IP Address", "Host Name", "MAC Address", "Other Info"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.setCursor(new Cursor(0));
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jTable1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TCPIPDiscovererTool.this.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jMenu1.setText("Help");
        this.jMenuItem1.setText("About...");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TCPIPDiscovererTool.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.btnDiscover, -2, 158, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 255, Short.MAX_VALUE).addComponent(this.btnExit, -2, 150, -2).addGap(63, 63, 63)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 630, Short.MAX_VALUE).addContainerGap())));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(26, 26, 26).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnExit, -2, 28, -2).addComponent(this.btnDiscover, -2, 28, -2)).addContainerGap(293, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(71, 71, 71).addComponent(this.jScrollPane1, -2, 255, -2).addContainerGap(21, Short.MAX_VALUE))));
        this.pack();
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void btnDiscoverActionPerformed(ActionEvent evt) {
        try {
            if (!socket.isBound()) {
                socket = new DatagramSocket(30303);
                System.out.println("EthDiscoverActionPerformed:after socket");
            }
            InetAddress address = InetAddress.getByName("255.255.255.255");
            model = (DefaultTableModel)this.jTable1.getModel();
            int rowcount = model.getRowCount();
            for (int index1 = 0; index1 < rowcount; ++index1) {
                model.removeRow(0);
            }
            packet = new DatagramPacket(this.str.getBytes(), this.str.length(), address, 30303);
            socket.send(packet);
            this.jTable1.addMouseListener(null);
        }
        catch (IOException soEx) {
            String optionStr = "<html>Unable to transmit discovery message. <br> Check network connectivity and ensure that no other instances of this program are running.";
            JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
            this.close_action();
        }
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        Point pt = evt.getPoint();
        int row = this.jTable1.rowAtPoint(pt);
        int col = this.jTable1.columnAtPoint(pt);
        String url = (String)this.jTable1.getValueAt(row, 0);
        mchipUrl = "http://" + url;
        try {
            URL myUrl = new URL(mchipUrl);
            Desktop.getDesktop().browse(myUrl.toURI());
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        TCPIPAboutBox aboutBox = new TCPIPAboutBox((Frame)this, true);
        aboutBox.setVisible(true);
    }

    public void close_action() {
        if (socket != null && socket.isConnected()) {
            socket.close();
        }
        if (recvThread != null && recvThread.isAlive()) {
            recvThread = null;
        }
        if (manageTable != null && manageTable.isAlive()) {
            manageTable = null;
        }
    }

    void changeTableColumnWidth() {
        TableColumn column = null;
        final TableCellRenderer tcr = this.jTable1.getTableHeader().getDefaultRenderer();
        this.jTable1.getTableHeader().setDefaultRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel lbl = (JLabel)tcr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                lbl.setBorder(BorderFactory.createCompoundBorder(lbl.getBorder(), BorderFactory.createEmptyBorder(0, 5, 0, 0)));
                lbl.setHorizontalAlignment(2);
                return lbl;
            }
        });
        this.jTable1.setAutoResizeMode(4);
        this.jTable1.setDragEnabled(false);
        this.jTable1.setColumnSelectionAllowed(false);
        int colNumber = this.jTable1.getColumnCount();
        for (int i = 0; i < colNumber; ++i) {
            column = this.jTable1.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setPreferredWidth(100);
                    column.setMaxWidth(120);
                    break;
                }
                case 1: {
                    column.setPreferredWidth(100);
                    column.setMaxWidth(120);
                    break;
                }
                case 2: {
                    column.setPreferredWidth(130);
                    column.setMaxWidth(180);
                    break;
                }
                case 3: {
                    column.setPreferredWidth(100);
                }
            }
            column.setResizable(true);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                new TCPIPDiscovererTool().setVisible(true);
            }
        });
    }

    static {
        recvThread = null;
        manageTable = null;
    }
}

