/*
 * Decompiled with CFR 0.152.
 */
package MicrochipMPFS;

import MicrochipMPFS.DynamicVariable;
import MicrochipMPFS.MPFSFileRecord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DynVar {
    int offSetCounter = 0;
    int parseItrtn = 0;
    int tempFileRcrdLen = 0;
    private static List<DynamicVariable> vars;
    String regEx = "~(inc:[A-Za-z0-9\\ \\.-_\\/]{1,60}|[A-Za-z0-9_]{0,40}(\\([A-Za-z0-9_,\\ ]*\\))?)~";
    private Pattern parser = Pattern.compile(this.regEx);
    private String projectDir;
    String HTTPPRINT_H_HEADER = "/**************************************************************\r\n * HTTPPrint.h\r\n * Provides callback headers and resolution for user's custom\r\n * HTTP Application.\r\n * \r\n * This file is automatically generated by the MPFS Utility\r\n * ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS GENERATOR\r\n **************************************************************/\r\n\r\n#ifndef __HTTPPRINT_H\r\n#define __HTTPPRINT_H\r\n\r\n#include \"TCPIP Stack/TCPIP.h\"\r\n\r\n#if defined(STACK_USE_HTTP2_SERVER)\r\n\r\nextern HTTP_STUB httpStubs[MAX_HTTP_CONNECTIONS];\r\nextern BYTE curHTTPID;\r\n\r\nvoid HTTPPrint(DWORD callbackID);\r\n";
    String HTTPPRINT_H_MIDDLE = "\r\nvoid HTTPPrint(DWORD callbackID)\r\n{\r\n\tswitch(callbackID)\r\n\t{\r\n";
    String HTTPPRINT_H_FOOTER = "\t\tdefault:\r\n\t\t\t// Output notification for undefined values\r\n\t\t\tTCPPutROMArray(sktHTTP, (ROM BYTE*)\"!DEF\", 4);\r\n\t}\r\n\r\n\treturn;\r\n}\r\n\r\nvoid HTTPPrint_(void)\r\n{\r\n\tTCPPut(sktHTTP, '~');\r\n\treturn;\r\n}\r\n\r\n#endif\r\n\r\n#endif\r\n";

    public DynVar(String path) {
        this.projectDir = path;
        vars = new LinkedList<DynamicVariable>();
        try {
            File file_exists = new File(this.projectDir + "HTTPPrint.idx");
            if (file_exists.exists() && file_exists.length() > 0L) {
                FileInputStream inputFile = new FileInputStream(this.projectDir + "HTTPPrint.idx");
                DataInputStream in = new DataInputStream(inputFile);
                BufferedReader fin = new BufferedReader(new InputStreamReader(in));
                String s = fin.readLine();
                if (!s.contains("|")) {
                    while (s != null) {
                        DynamicVariable dv = new DynamicVariable(s);
                        vars.add(dv);
                        s = fin.readLine();
                    }
                }
                fin.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public MPFSFileRecord Parse(MPFSFileRecord file, StringBuilder strLine) {
        int dynVarCntr = 0;
        ByteArrayOutputStream resizeArray = new ByteArrayOutputStream();
        Matcher matches = this.parser.matcher(strLine);
        while (matches.find()) {
            int i = this.GetIndex(matches.group().replace(" ", "").replace("~", ""));
            resizeArray.write((byte)matches.start());
            resizeArray.write((byte)(matches.start() >> 8));
            resizeArray.write((byte)(matches.start() >> 16));
            resizeArray.write((byte)(matches.start() >> 24));
            resizeArray.write((byte)i);
            resizeArray.write((byte)(i >> 8));
            resizeArray.write((byte)(i >> 16));
            resizeArray.write((byte)(i >> 24));
            file.dynVarOffsetAndIndexID.addElement((byte)(matches.start() >> 0));
            file.dynVarOffsetAndIndexID.addElement((byte)(matches.start() >> 8));
            file.dynVarOffsetAndIndexID.addElement((byte)(matches.start() >> 16));
            file.dynVarOffsetAndIndexID.addElement((byte)(matches.start() >> 24));
            file.dynVarOffsetAndIndexID.addElement((byte)(i >> 0));
            file.dynVarOffsetAndIndexID.addElement((byte)(i >> 8));
            file.dynVarOffsetAndIndexID.addElement((byte)(i >> 16));
            file.dynVarOffsetAndIndexID.addElement((byte)(i >> 24));
            file.dynVarCntr = ++dynVarCntr;
            this.offSetCounter += 8;
        }
        if (this.parseItrtn == 0) {
            file.fileRecordOffset = 0;
            this.offSetCounter = 0;
        } else {
            file.fileRecordOffset = this.tempFileRcrdLen;
        }
        file.fileRecordLength = 6 + file.dynVarCntr * 8;
        this.tempFileRcrdLen += file.fileRecordLength;
        ++this.parseItrtn;
        if (resizeArray.size() == 0) {
            return null;
        }
        MPFSFileRecord idxFile = new MPFSFileRecord();
        idxFile.SetFileName("");
        idxFile.SetFiledate(file.fileDate);
        idxFile.isIndex = true;
        idxFile.data = resizeArray.toByteArray();
        idxFile.fileSizeLen = resizeArray.size();
        return idxFile;
    }

    public boolean WriteIndices() {
        boolean isChanged = false;
        for (DynamicVariable dv : vars) {
            if ((!dv.getWasUsed() || dv.getCount() != 0) && (dv.getWasUsed() || dv.getCount() == 0)) continue;
            isChanged = true;
            break;
        }
        if (!isChanged) {
            return false;
        }
        File httpFileIdx = new File(this.projectDir + "HTTPPrint.idx");
        try {
            String temp_str;
            FileOutputStream file_output = new FileOutputStream(httpFileIdx);
            DataOutputStream data_out = new DataOutputStream(file_output);
            BufferedWriter fout = new BufferedWriter(new OutputStreamWriter(data_out));
            for (DynamicVariable dv : vars) {
                if (dv.getCount() > 0) {
                    fout.write(43);
                }
                fout.write(dv.GetName());
                fout.write(10);
            }
            fout.flush();
            fout.close();
            file_output = new FileOutputStream(this.projectDir + "HTTPPrint.h");
            data_out = new DataOutputStream(file_output);
            fout = new BufferedWriter(new OutputStreamWriter(data_out));
            fout.write(this.HTTPPRINT_H_HEADER);
            ArrayList<String> prototypes = new ArrayList<String>();
            Pattern rGetParts = Pattern.compile("([A-Za-z0-9_]{0,40})(\\(([A-Za-z0-9_,]*)\\))?");
            for (DynamicVariable dv : vars) {
                Matcher m;
                if (dv.GetName().startsWith("inc:") || dv.getCount() == 0 || !(m = rGetParts.matcher(dv.GetName())).find() || prototypes.contains(m.group(1))) continue;
                prototypes.add(m.group(1));
                temp_str = "void HTTPPrint_" + m.group(1) + "(";
                fout.write(temp_str);
                if (m.group(3) != null) {
                    if (m.groupCount() == 3 && m.group(3).length() > 0) {
                        int numParams = m.group(3).split(",").length;
                        for (int i = 0; i < numParams - 1; ++i) {
                            fout.write("WORD,");
                        }
                        fout.write("WORD");
                    }
                } else {
                    fout.write("void");
                }
                fout.write(");\r\n");
            }
            fout.write(this.HTTPPRINT_H_MIDDLE);
            int index = 0;
            for (DynamicVariable dv : vars) {
                if (dv.getCount() == 0) {
                    ++index;
                    continue;
                }
                temp_str = "        case 0x" + String.format("%08x", index++) + ":\r\n";
                fout.write(temp_str);
                if (dv.GetName().startsWith("inc:")) {
                    temp_str = "\t\t\tHTTPIncFile((ROM BYTE*)\"" + dv.GetName().substring(4) + "\");\r\n\t\t\tbreak;\r\n";
                    fout.write(temp_str);
                    continue;
                }
                temp_str = "\t\t\tHTTPPrint_" + dv.GetName();
                fout.write(temp_str);
                if (!dv.GetName().endsWith(")")) {
                    fout.write("()");
                }
                fout.write(";\r\n\t\t\tbreak;\r\n");
            }
            fout.write(this.HTTPPRINT_H_FOOTER);
            fout.flush();
            fout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private int GetIndex(String name) {
        int count = 0;
        DynamicVariable dv = new DynamicVariable(name);
        int i = vars.indexOf(dv);
        if (i == -1) {
            vars.add(dv);
            i = vars.size() - 1;
        }
        count = vars.get(i).getCount();
        vars.get(i).setCount(++count);
        return i;
    }
}

