/*
 * Decompiled with CFR 0.152.
 */
package MicrochipMPFS;

import MicrochipMPFS.DynVar;
import MicrochipMPFS.FileRecord;
import MicrochipMPFS.MPFSFileRecord;
import MicrochipMPFS.MainMPFS;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPFS2Lib {
    MainMPFS MPFS2;
    public String LocalPath;
    public String LocalFile;
    public String SourcePath;
    private Collection<String> dynamicTypes;
    private Collection<String> nonGZipTypes;
    private DynVar dynVarParser;
    public List<String> log;
    public List<MPFSFileRecord> files;
    protected boolean indexUpdated;
    public FileOutputStream file_output;
    public DataOutputStream data_out;
    public int MPFS2_FLAG_ISZIPPED = 1;
    public int MPFS2_FLAG_HASINDEX = 2;
    public static String ASCIILine;
    public String generatedImageName;
    public List<File> deeperList = new ArrayList<File>();
    public String DirPathString;

    public List<File> getFileListing(File aStartingDir) throws FileNotFoundException {
        this.DirPathString = aStartingDir.getPath();
        List<File> result = this.getFileListingNoSort(aStartingDir);
        return result;
    }

    public List<File> getFileListingNoSort(File aStartingDir) throws FileNotFoundException {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        result.add(aStartingDir);
        for (File file : filesDirs) {
            if (file.isHidden()) continue;
            if (!file.isFile()) {
                this.deeperList = this.getFileListingNoSort(file);
                continue;
            }
            result.add(file);
        }
        if (this.DirPathString.contains(aStartingDir.getPath())) {
            Collections.sort(this.deeperList);
        }
        result.addAll(this.deeperList);
        return result;
    }

    private boolean FileMatches(String fileName, Collection<String> endings) {
        for (String end : endings) {
            if (!fileName.endsWith(end)) continue;
            return true;
        }
        return false;
    }

    public void MPFS2Builder(String localPath, String localFile) {
        if (!localPath.endsWith("\\")) {
            localPath = localPath + "\\";
        }
        this.LocalPath = localPath;
        this.LocalFile = localFile;
        this.dynamicTypes = new ArrayList<String>();
        this.nonGZipTypes = new ArrayList<String>();
        this.log = new ArrayList<String>();
        this.files = new LinkedList<MPFSFileRecord>();
        this.dynVarParser = new DynVar(localPath);
        this.indexUpdated = false;
    }

    public String GeneratedImageFileName() {
        return this.generatedImageName;
    }

    public void DynamicTypes(String dynFiles) {
        String[] str = dynFiles.split(",");
        this.dynamicTypes.clear();
        for (String s : str) {
            String s_trimmed = s.replace('*', ' ').trim();
            if (s_trimmed.length() <= 0) continue;
            this.dynamicTypes.add(s_trimmed);
        }
    }

    public void NonGZipTypes(String nonGZipFiles) {
        String[] str = nonGZipFiles.split(",");
        this.nonGZipTypes.clear();
        for (String s : str) {
            String s_trimmed = s.replace('*', ' ').trim();
            if (s_trimmed.length() <= 0) continue;
            this.nonGZipTypes.add(s_trimmed);
        }
    }

    public boolean AddFile(String localName, String imageName, File file) {
        char[] buf;
        byte[] fileData;
        boolean count = false;
        StringBuilder strLine = new StringBuilder();
        if (!file.exists()) {
            this.log.add("\r\nERROR: Could not read " + localName);
            return false;
        }
        int fileSizeLength = (int)file.length();
        if (fileSizeLength < 10000000) {
            fileData = new byte[fileSizeLength];
            buf = new char[fileSizeLength];
        } else {
            fileData = new byte[100000];
            buf = new char[100000];
        }
        MPFSFileRecord newFile = new MPFSFileRecord();
        newFile.SetFileName(imageName);
        newFile.SetFiledate(file.lastModified());
        try {
            int byteRead;
            FileInputStream inputFile = new FileInputStream(localName);
            DataInputStream in = new DataInputStream(inputFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            int byteCnt = 0;
            while ((byteRead = br.read(buf)) != -1) {
                ++byteCnt;
                strLine.append(buf);
            }
            br.close();
            inputFile = new FileInputStream(localName);
            byteRead = 0;
            ByteArrayOutputStream tempout = new ByteArrayOutputStream();
            while ((byteRead = inputFile.read(fileData)) != -1) {
                tempout.write(fileData);
            }
            newFile.data = tempout.toByteArray();
            newFile.fileSizeLen = tempout.size();
            inputFile.close();
            MPFSFileRecord idxFile = null;
            if (this.FileMatches(localName, this.dynamicTypes)) {
                idxFile = this.dynVarParser.Parse(newFile, strLine);
            }
            inputFile = new FileInputStream(localName);
            int gzipRatio = 0;
            if (idxFile == null && !this.FileMatches(localName, this.nonGZipTypes)) {
                GZIPOutputStream zipout = new GZIPOutputStream(new FileOutputStream("output.gzip"));
                fileData = fileSizeLength < 10000000 ? new byte[fileSizeLength] : new byte[100000];
                while ((byteRead = inputFile.read(fileData)) != -1) {
                    zipout.write(fileData, 0, byteRead);
                }
                zipout.finish();
                inputFile.close();
                zipout.close();
                File file_zip = new File("output.gzip");
                FileInputStream inputZipFile = new FileInputStream("output.gzip");
                if (file_zip.length() < (long)newFile.fileSizeLen) {
                    ByteArrayInputStream tempNewFileDataArray = new ByteArrayInputStream(newFile.data);
                    gzipRatio = (int)(100L - 100L * file_zip.length() / (long)newFile.fileSizeLen);
                    fileData = file_zip.length() < 100000L ? new byte[(int)file_zip.length()] : new byte[100000];
                    tempNewFileDataArray.reset();
                    tempout = new ByteArrayOutputStream();
                    while ((byteRead = inputZipFile.read(fileData)) != -1) {
                        tempout.write(fileData);
                    }
                    newFile.data = tempout.toByteArray();
                    newFile.fileSizeLen = tempout.size();
                    newFile.isZipped = true;
                }
                inputZipFile.close();
                file_zip.delete();
            }
            if (idxFile == null) {
                this.log.add("    " + imageName + ": " + newFile.fileSizeLen + " bytes" + (gzipRatio > 0 ? " (gzipped by " + gzipRatio + "%)" : ""));
                this.files.add(newFile);
            } else {
                this.log.add("    " + imageName + ": " + newFile.fileSizeLen + " bytes, " + idxFile.fileSizeLen / 8 + " vars");
                newFile.hasIndex = true;
                this.files.add(newFile);
                this.files.add(idxFile);
            }
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
        }
        return true;
    }

    public boolean AddDirectory(String dataPath) {
        List<File> ListFiles;
        String imagePath = "";
        File dir = new File(dataPath);
        if (!dir.exists()) {
            this.log.add("\r\nERROR: Directory " + dataPath + " does not exist.");
            return false;
        }
        try {
            ListFiles = this.getFileListing(dir);
        }
        catch (IOException e) {
            this.log.add("\r\nERROR: Directory " + dataPath + " does not exist.");
            return false;
        }
        if (this.LocalPath.contains(dataPath)) {
            this.log.add("<html>\r\nERROR: The project directory is located <br>in the source directory.  The generator cannot run if <br>the image is to be placed in the source directory. <br> Please select the base MPLAB project <br>directory before continuing.</html>");
            return false;
        }
        for (File f : ListFiles) {
            if (f.isHidden()) continue;
            if (f.isDirectory()) {
                this.log.add(f.getPath() + " :");
                if (dataPath.contains(f.getPath())) continue;
                imagePath = f.getName();
                imagePath = imagePath + "/";
                continue;
            }
            this.AddFile(f.getPath(), imagePath + f.getName(), f);
        }
        return true;
    }

    public boolean Generate(MPFSOutputFormat format) {
        this.generatedImageName = null;
        if (!new File(this.LocalPath).exists()) {
            this.log.add("ERROR: Output directory \"" + this.LocalPath + "\" does not exist!");
            return false;
        }
        if (this.files.size() == 0) {
            return false;
        }
        this.indexUpdated = this.dynVarParser.WriteIndices();
        int numFiles = this.files.size();
        int lenHeader = 8;
        int lenHashes = 2 * numFiles;
        int lenFAT = 22 * numFiles;
        int baseAddr = lenHeader + lenHashes + lenFAT;
        boolean counter = false;
        boolean loopCntr = false;
        boolean numFileRecrds = false;
        for (MPFSFileRecord file : this.files) {
            file.locStr = baseAddr;
            baseAddr += file.GetFileName().length() + 1;
        }
        for (MPFSFileRecord file : this.files) {
            file.locData = baseAddr;
            baseAddr += file.fileSizeLen;
        }
        try {
            switch (format) {
                case C18: 
                case C32: {
                    MPFS2Writer w = new MPFS2C18Writer(this.LocalPath + this.LocalFile);
                    this.WriteImage(w);
                    break;
                }
                case ASM30: {
                    MPFS2Writer w = new MPFS2ASM30Writer(this.LocalPath + this.LocalFile);
                    this.WriteImage(w);
                    break;
                }
                case MDD: {
                    this.MDDWriter(this.LocalPath);
                    break;
                }
                default: {
                    MPFS2Writer w = new MPFS2BINWriter(this.LocalPath + this.LocalFile);
                    this.WriteImage(w);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.log.add("ERROR: " + e.getMessage());
            return false;
        }
        return true;
    }

    private void WriteImage(MPFS2Writer x) {
        long timeVal = 621355968000000000L;
        long epoch = 0L;
        MPFS2Writer w = x;
        w.Write("MPFS");
        w.Write((byte)2);
        w.Write((byte)1);
        w.Write((short)this.files.size());
        for (MPFSFileRecord file : this.files) {
            w.Write((byte)file.nameHash);
            w.Write((byte)(file.nameHash >> 8));
        }
        for (MPFSFileRecord file : this.files) {
            w.Write(file.locStr);
            w.Write(file.locData);
            w.Write(file.fileSizeLen);
            epoch = file.fileDate / 1000L;
            w.Write((int)epoch);
            w.Write(0);
            int flags = 0;
            if (file.hasIndex) {
                flags |= this.MPFS2_FLAG_HASINDEX;
            }
            if (file.isZipped) {
                flags |= this.MPFS2_FLAG_ISZIPPED;
            }
            w.Write((short)flags);
            timeVal = 621355968000000000L;
        }
        for (MPFSFileRecord file : this.files) {
            w.Write(file.GetFileName());
            w.Write((byte)0);
        }
        for (MPFSFileRecord file : this.files) {
            for (int i = 0; i < file.fileSizeLen; ++i) {
                w.Write(file.data[i]);
            }
        }
        w.Close();
        this.generatedImageName = w.imageName;
        this.log.add("GENERATED MPFS2 IMAGE: " + w.ImageLength + " bytes");
    }

    public void MDDWriter(String localPath) {
        int counter = 0;
        int loopCntr = 0;
        int numFileRecrds = 0;
        FilesRecordWriter FileRecrd = new FilesRecordWriter(localPath);
        DynamicVarRecordWriter DynVarRecrd = new DynamicVarRecordWriter(localPath);
        ArrayList<FileRecord> FileRcrdList = new ArrayList<FileRecord>();
        for (MPFSFileRecord file : this.files) {
            counter = 0;
            loopCntr = 0;
            if (file.dynVarCntr <= 0) continue;
            FileRcrdList.add(new FileRecord((short)file.nameHash, file.fileRecordOffset, file.dynVarCntr));
            ++numFileRecrds;
            DynVarRecrd.Write((byte)file.fileRecordLength);
            DynVarRecrd.Write((byte)(file.fileRecordLength >> 8));
            DynVarRecrd.Write((byte)(file.fileRecordLength >> 16));
            DynVarRecrd.Write((byte)(file.fileRecordLength >> 24));
            int flags = 0;
            if (file.hasIndex) {
                flags |= this.MPFS2_FLAG_HASINDEX;
            }
            if (file.isZipped) {
                flags |= this.MPFS2_FLAG_ISZIPPED;
            }
            DynVarRecrd.Write((byte)flags);
            DynVarRecrd.Write((byte)(flags >> 8));
            for (loopCntr = 0; loopCntr != file.dynVarCntr; ++loopCntr) {
                DynVarRecrd.Write(file.dynVarOffsetAndIndexID.get(0 + counter));
                DynVarRecrd.Write(file.dynVarOffsetAndIndexID.get(1 + counter));
                DynVarRecrd.Write(file.dynVarOffsetAndIndexID.get(2 + counter));
                DynVarRecrd.Write(file.dynVarOffsetAndIndexID.get(3 + counter));
                DynVarRecrd.Write(file.dynVarOffsetAndIndexID.get(4 + counter));
                DynVarRecrd.Write(file.dynVarOffsetAndIndexID.get(5 + counter));
                DynVarRecrd.Write(file.dynVarOffsetAndIndexID.get(6 + counter));
                DynVarRecrd.Write(file.dynVarOffsetAndIndexID.get(7 + counter));
                counter += 8;
            }
        }
        FileRecrd.Write((byte)numFileRecrds);
        FileRecrd.Write((byte)(numFileRecrds >> 8));
        FileRecrd.Write((byte)(numFileRecrds >> 16));
        FileRecrd.Write((byte)(numFileRecrds >> 24));
        ArrayList<FileRecord> tempfileRecrdList = FileRcrdList;
        Collections.sort(tempfileRecrdList);
        for (FileRecord FR : FileRcrdList) {
            FileRecrd.Write((byte)FR.nameHash);
            FileRecrd.Write((byte)(FR.nameHash >> 8));
            FileRecrd.Write((byte)FR.fileRecordOffset);
            FileRecrd.Write((byte)(FR.fileRecordOffset >> 8));
            FileRecrd.Write((byte)(FR.fileRecordOffset >> 16));
            FileRecrd.Write((byte)(FR.fileRecordOffset >> 24));
            FileRecrd.Write((byte)FR.dynVarCntr);
            FileRecrd.Write((byte)(FR.dynVarCntr >> 8));
            FileRecrd.Write((byte)(FR.dynVarCntr >> 16));
            FileRecrd.Write((byte)(FR.dynVarCntr >> 24));
        }
        this.log.add("\r\nGENERATED MPFS2 IMAGE: " + FileRecrd.ImageLength + " bytes");
        FileRecrd.Close();
        DynVarRecrd.Close();
    }

    public static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    public static String padLeft(String s, int n) {
        return String.format("%1$#" + n + "s", s);
    }

    public class MPFSClassicBuilder {
        public int ReserveBlock;
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("E MMM dd yyyy hh:mm:ss");
        private FileOutputStream file_output;
        private DataOutputStream data_out;
        private BufferedWriter fout;
        byte MPFS_DATA = 0;
        byte MPFS_DELETED = 1;
        byte MPFS_DLE = (byte)3;
        byte MPFS_ETX = (byte)4;
        String MPFS_C_HEADER = "/***************************************************************\r\n * MPFSImg.c\r\n * Defines an MPFS2 image to be stored in program memory.\r\n *\r\n * NOT FOR HAND MODIFICATION\r\n * This file is automatically generated by the MPFS2 Utility\r\n * ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS2 GENERATOR\r\n * Generated " + this.sdf.format(this.date) + "\r\n" + " ***************************************************************/\r\n" + "\r\n" + "#define __MPFSIMG_C\r\n" + "\r\n" + "#include \"TCPIP Stack/TCPIP.h\"\r\n" + "\r\n" + "#if defined(STACK_USE_MPFS) && !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)\r\n" + "\r\n";
        String MPFS_C_FOOTER = "/**************************************************************\r\n * End of MPFS\r\n **************************************************************/\r\n#endif // #if defined(STACK_USE_MPFS) && !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)\r\n\r\n";
        String MPFS_ASM_HEADER = ";**************************************************************\r\n; MPFSImg.s\r\n; Defines an MPFS2 image to be stored in program memory.\r\n; Defined in ASM30 assembly for optimal storage size.\r\n;\r\n; NOT FOR HAND MODIFICATION\r\n; This file is automatically generated by the MPFS2 Utility\r\n; ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS2 GENERATOR\r\n; Generated " + this.sdf.format(this.date) + "\r\n" + ";**************************************************************\r\n\r\n" + ".equ VALID_ID,0\r\n" + ".ifdecl __dsPIC30F\r\n" + "    .include \"p30fxxxx.inc\"\r\n" + ".endif\r\n" + ".ifdecl __dsPIC33F\r\n" + "    .include \"p33fxxxx.inc\"\r\n" + ".endif\r\n" + ".ifdecl __PIC24H\r\n" + "    .include \"p24hxxxx.inc\"\r\n" + ".endif\r\n" + ".ifdecl __PIC24F\r\n" + "    .include \"p24fxxxx.inc\"\r\n" + ".endif\r\n" + ".if VALID_ID <> 1\r\n" + "    .error \"Processor ID not specified in generic include files.  New ASM30 assembler needs to be downloaded?\"\r\n" + ".endif\r\n" + "\t .text\r\n" + "\t .section\tMPFSData,code\r\n\r\n" + "\t goto END_OF_MPFS\t; Prevent accidental execution of constant data.\r\n" + "\t .global BEGIN_MPFS\r\n" + "BEGIN_MPFS:\r\n";
        String MPFS_ASM_FOOTER = "\r\n\r\n; End of Generated Image\r\n";

        public MPFSClassicBuilder(String localPath, String localFile) {
            if (!localPath.endsWith("\\")) {
                localPath = localPath + "\\";
            }
            MPFS2Lib.this.LocalPath = localPath;
            MPFS2Lib.this.LocalFile = localFile;
            this.ReserveBlock = 0;
            MPFS2Lib.this.log = new ArrayList<String>();
            MPFS2Lib.this.files = new LinkedList<MPFSFileRecord>();
            MPFS2Lib.this.indexUpdated = false;
        }

        public boolean AddFile(String localName, String imageName) {
            if (!new File(localName).exists()) {
                MPFS2Lib.this.log.add("\r\nERROR: Could not read " + localName);
                return false;
            }
            MPFSFileRecord newFile = new MPFSFileRecord();
            newFile.SetFileName(imageName);
            try {
                int byteRead;
                ByteArrayOutputStream tempout = new ByteArrayOutputStream();
                FileInputStream inputFile = new FileInputStream(localName);
                while ((byteRead = inputFile.read()) != -1) {
                    if (byteRead == this.MPFS_DLE || byteRead == this.MPFS_ETX) {
                        tempout.write(this.MPFS_DLE);
                    }
                    tempout.write((byte)byteRead);
                }
                newFile.data = tempout.toByteArray();
                newFile.fileSizeLen = tempout.size();
                inputFile.close();
                MPFS2Lib.this.log.add("    " + imageName + ": " + newFile.fileSizeLen + " bytes");
                MPFS2Lib.this.files.add(newFile);
            }
            catch (Exception e) {
                MPFS2Lib.this.log.add("\r\nERROR: " + e.getMessage());
                return false;
            }
            return true;
        }

        public boolean AddDirectory(String dataPath, String imagePath) {
            File dir = new File(dataPath);
            if (!dir.exists()) {
                MPFS2Lib.this.log.add("\r\nERROR: Directory " + dataPath + " does not exist.");
                return false;
            }
            if (MPFS2Lib.this.LocalPath.contains(dataPath)) {
                MPFS2Lib.this.log.add("\r\nERROR: The project directory is located in the source directory.\r\n The generator cannot run if the image is \r\nto be placed in the source directory.\r\n  Please select the base MPLAB project \r\ndirectory before continuing.");
                return false;
            }
            File[] filelist = dir.listFiles();
            MPFS2Lib.this.log.add(dataPath + " :");
            for (File f : filelist) {
                if (f.isHidden() || f.isDirectory() || !f.isFile()) continue;
                this.AddFile(f.getPath(), imagePath + f.getName());
            }
            return true;
        }

        public boolean Generate(MPFSOutputFormat format) {
            MPFS2Lib.this.generatedImageName = null;
            File dir = new File(MPFS2Lib.this.LocalPath);
            if (!dir.exists()) {
                MPFS2Lib.this.log.add("\r\nERROR: Output directory \"" + MPFS2Lib.this.LocalPath + "\" does not exist!");
                return false;
            }
            if (MPFS2Lib.this.files.size() == 0) {
                return false;
            }
            try {
                switch (format) {
                    case BIN: {
                        return this.GenerateBIN(MPFS2Lib.this.LocalPath + MPFS2Lib.this.LocalFile);
                    }
                    case C18: 
                    case C32: {
                        return this.GenerateC(MPFS2Lib.this.LocalPath + MPFS2Lib.this.LocalFile);
                    }
                    case ASM30: {
                        return this.GenerateASM(MPFS2Lib.this.LocalPath + MPFS2Lib.this.LocalFile);
                    }
                }
                MPFS2Lib.this.log.add("\r\nERROR: Invalid output format was specified.");
                return false;
            }
            catch (Exception e) {
                MPFS2Lib.this.log.add("\r\nERROR: " + e.getMessage());
                return false;
            }
        }

        private boolean GenerateBIN(String filename) {
            ByteArrayOutputStream file_output = new ByteArrayOutputStream();
            if (!filename.endsWith(".bin")) {
                filename = filename + ".bin";
            }
            try {
                FileOutputStream classicbinOut = new FileOutputStream(filename);
                int baseAddr = this.ReserveBlock + 17 * (MPFS2Lib.this.files.size() + 1);
                for (MPFSFileRecord file : MPFS2Lib.this.files) {
                    file_output.write(this.MPFS_DATA);
                    file_output.write((byte)baseAddr);
                    file_output.write((byte)(baseAddr >> 8));
                    file_output.write((byte)(baseAddr >> 16));
                    file_output.write((byte)(baseAddr >> 24));
                    file_output.write(this.NormalizeFileName(file.GetFileName()).getBytes());
                    baseAddr += file.fileSizeLen + 5;
                }
                file_output.write(this.MPFS_ETX);
                file_output.write(255);
                file_output.write(255);
                file_output.write(255);
                file_output.write(255);
                file_output.write("END OF FAT  ".getBytes());
                for (MPFSFileRecord file : MPFS2Lib.this.files) {
                    for (int i = 0; i < file.fileSizeLen; ++i) {
                        file_output.write(file.data[i]);
                    }
                    file_output.write(this.MPFS_ETX);
                    file_output.write(255);
                    file_output.write(255);
                    file_output.write(255);
                    file_output.write(255);
                }
                int fileSize = file_output.size();
                classicbinOut.write(file_output.toByteArray(), 0, fileSize);
                classicbinOut.flush();
                classicbinOut.close();
            }
            catch (Exception e) {
                MPFS2Lib.this.log.add("\r\nERROR: " + e.getMessage());
                return false;
            }
            MPFS2Lib.this.generatedImageName = filename;
            return true;
        }

        private boolean GenerateC(String filename) {
            if (!filename.endsWith(".c")) {
                filename = filename + ".c";
            }
            try {
                String tempStr;
                this.file_output = new FileOutputStream(filename);
                this.data_out = new DataOutputStream(this.file_output);
                this.fout = new BufferedWriter(new OutputStreamWriter(this.data_out));
                this.fout.write(this.MPFS_C_HEADER);
                int fileIndex = 0;
                for (MPFSFileRecord file : MPFS2Lib.this.files) {
                    this.fout.write("\r\n/*******************************\r\n * Begin ");
                    this.fout.write(this.NormalizeFileName(file.GetFileName()));
                    this.fout.write("\r\n ******************************/\r\nstatic ROM unsigned char MPFS_");
                    tempStr = String.format("%04x", fileIndex++) + "[] = \r\n{";
                    this.fout.write(tempStr);
                    for (int i = 0; i < file.fileSizeLen; ++i) {
                        if (i % 12 == 0) {
                            this.fout.write("\r\n\t");
                        }
                        tempStr = String.format("0x%02x", file.data[i]) + ",";
                        this.fout.write(tempStr);
                    }
                    this.fout.write("\r\n\t0x04,0xff,0xff,0xff\r\n};\r\n");
                }
                fileIndex = 0;
                this.fout.write("/**************************************************\r\n * Start of MPFS FAT\r\n **************************************************/\r\ntypedef struct\r\n{\r\n    unsigned char Flags;\r\n    ROM unsigned char* Address;\r\n    unsigned char Name[12];\r\n} FAT_TABLE_ENTRY;\r\n\r\nROM FAT_TABLE_ENTRY MPFS_Start[] = \r\n{");
                for (MPFSFileRecord file : MPFS2Lib.this.files) {
                    tempStr = "\r\n\t{ 0x00, MPFS_" + String.format("%04x", fileIndex++);
                    this.fout.write(tempStr);
                    for (byte b : this.NormalizeFileName(file.GetFileName()).getBytes()) {
                        this.fout.write(", '" + (char)b + "'");
                    }
                    this.fout.write(" },");
                }
                this.fout.write("\r\n\t{ 0x04, (ROM unsigned char*)0xffffff, 'E', 'N', 'D', ' ', 'O', 'F', ' ', 'F', 'A', 'T', ' ', ' ' },\r\n};\r\n/**************************************************\r\n * End of MPFS FAT\r\n **************************************************/\r\n\r\n");
                this.fout.write(this.MPFS_C_FOOTER);
                this.fout.flush();
                this.fout.close();
            }
            catch (Exception e) {
                MPFS2Lib.this.log.add("\r\nERROR: " + e.getMessage());
                return false;
            }
            MPFS2Lib.this.generatedImageName = filename;
            return true;
        }

        private boolean GenerateASM(String filename) {
            if (!filename.endsWith(".s")) {
                filename = filename + ".s";
            }
            try {
                int i;
                String tempStr;
                this.file_output = new FileOutputStream(filename);
                this.data_out = new DataOutputStream(this.file_output);
                this.fout = new BufferedWriter(new OutputStreamWriter(this.data_out));
                this.fout.write(this.MPFS_ASM_HEADER);
                int fileIndex = 0;
                for (MPFSFileRecord file : MPFS2Lib.this.files) {
                    this.fout.write("\r\n;*******************************\r\n;  Begin ");
                    this.fout.write(this.NormalizeFileName(file.GetFileName()));
                    this.fout.write("\r\n;*******************************\r\n\tgoto\tEND_OF_MPFS_");
                    tempStr = String.format("%04x", fileIndex);
                    this.fout.write(tempStr);
                    this.fout.write("\t\t; Prevent accidental execution of constant data\r\n\t.global _MPFS_");
                    this.fout.write(tempStr);
                    this.fout.write("\r\n_MPFS_");
                    this.fout.write(tempStr);
                    this.fout.write(":");
                    for (i = 0; i < file.fileSizeLen; ++i) {
                        if (i % 12 == 0) {
                            this.fout.write("\r\n\t.pbyte\t");
                        }
                        tempStr = String.format("0x%02x", file.data[i]);
                        this.fout.write(tempStr);
                        if (i % 12 == 11 || i == file.fileSizeLen - 1) continue;
                        this.fout.write(",");
                    }
                    this.fout.write("\r\n\t.pbyte\t0x04,0xff,0xff,0xff,0xff\r\nEND_OF_MPFS_");
                    tempStr = String.format("%04x", fileIndex++);
                    this.fout.write(tempStr);
                    this.fout.write(":\r\n");
                }
                fileIndex = 0;
                this.fout.write(";*************************************************\r\n;  Start of MPFS FAT\r\n;*************************************************\r\n\t.section\t.const,psv\r\n\t.global _MPFS_Start\r\n_MPFS_Start:");
                for (MPFSFileRecord file : MPFS2Lib.this.files) {
                    this.fout.write("\r\n\t.byte\t0x00,0x00\r\n\t.long\tpaddr(_MPFS_");
                    tempStr = String.format("%04x", fileIndex++);
                    this.fout.write(tempStr);
                    this.fout.write(")\r\n\t.byte\t");
                    i = 0;
                    for (byte b : this.NormalizeFileName(file.GetFileName()).getBytes()) {
                        this.fout.write("'" + (char)b + "'");
                        if (++i >= 12) continue;
                        this.fout.write(",");
                    }
                }
                this.fout.write("\r\n\t.byte\t0x04,0x00\r\n\t.long\t0xffffffff\r\n\t.byte\t'E','N','D',' ','O','F',' ','F','A','T',' ',' '\r\n\r\n\t.section MPFSEnd,code\r\nEND_OF_MPFS:\r\n");
                this.fout.write(this.MPFS_ASM_FOOTER);
                this.fout.flush();
                this.fout.close();
            }
            catch (Exception e) {
                MPFS2Lib.this.log.add("\r\nERROR: " + e.getMessage());
                return false;
            }
            MPFS2Lib.this.generatedImageName = filename;
            return true;
        }

        private String NormalizeFileName(String name) {
            if (name.length() > 12) {
                name = name.substring(0, 12);
            }
            return MPFS2Lib.padRight(name, 12).toUpperCase();
        }
    }

    private class DynamicVarRecordWriter {
        public FileOutputStream file_output;
        public DataOutputStream data_out;
        public BufferedWriter fout;

        public DynamicVarRecordWriter(String dataPath) {
            String filename = "DynRcrd.bin";
            String newPath = dataPath + filename;
            try {
                this.file_output = new FileOutputStream(newPath);
            }
            catch (IOException e) {
                MPFS2Lib.this.log.add("ERROR: " + e.getMessage());
            }
        }

        public void Write(byte data) {
            try {
                this.file_output.write(data);
            }
            catch (IOException e) {
                MPFS2Lib.this.log.add("ERROR: " + e.getMessage());
            }
        }

        public void Close() {
            try {
                this.file_output.flush();
                this.file_output.close();
            }
            catch (IOException e) {
                MPFS2Lib.this.log.add("ERROR: " + e.getMessage());
            }
        }
    }

    private class FilesRecordWriter {
        public FileOutputStream file_output;
        public DataOutputStream data_out;
        public BufferedWriter fout;
        public int ImageLength = 0;

        public FilesRecordWriter(String dataPath) {
            String filename = "FileRcrd.bin";
            String newPath = dataPath + filename;
            try {
                this.file_output = new FileOutputStream(newPath);
            }
            catch (IOException e) {
                MPFS2Lib.this.log.add("ERROR: " + e.getMessage());
            }
        }

        public void Write(byte data) {
            try {
                this.file_output.write(data);
                ++this.ImageLength;
            }
            catch (IOException e) {
                MPFS2Lib.this.log.add("ERROR: " + e.getMessage());
            }
        }

        public void Close() {
            try {
                this.file_output.flush();
                this.file_output.close();
            }
            catch (IOException e) {
                MPFS2Lib.this.log.add("ERROR: " + e.getMessage());
            }
        }
    }

    public class MPFS2ASM30Writer
    extends MPFS2Writer {
        public FileOutputStream file_output;
        public DataOutputStream data_out;
        public BufferedWriter fout;

        public MPFS2ASM30Writer(String filename) {
            Date date = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("E MMM dd yyyy hh:mm:ss");
            if (!filename.endsWith(".s")) {
                filename = filename + ".s";
            }
            try {
                this.file_output = new FileOutputStream(filename);
                this.data_out = new DataOutputStream(this.file_output);
                this.fout = new BufferedWriter(new OutputStreamWriter(this.data_out));
                this.imageName = filename;
                this.fout.write(";**************************************************************\r\n; MPFSImg2.s\r\n; Defines an MPFS2 image to be stored in program memory.\r\n; Defined in ASM30 assembly for optimal storage size.\r\n;\r\n; NOT FOR HAND MODIFICATION\r\n; This file is automatically generated by the MPFS2 Utility\r\n; ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS2 GENERATOR\r\n; Generated " + sdf.format(date) + " " + "\r\n" + ";**************************************************************\r\n\r\n" + ".equ VALID_ID,0\r\n" + ".ifdecl __dsPIC30F\r\n" + "    .include \"p30fxxxx.inc\"\r\n" + ".endif\r\n" + ".ifdecl __dsPIC33F\r\n" + "    .include \"p33fxxxx.inc\"\r\n" + ".endif\r\n" + ".ifdecl __dsPIC33E\r\n" + "    .include \"p33exxxx.inc\"\r\n" + ".endif\r\n" + ".ifdecl __PIC24E\r\n" + "    .include \"p24exxxx.inc\"\r\n" + ".endif\r\n" + ".ifdecl __PIC24H\r\n" + "    .include \"p24hxxxx.inc\"\r\n" + ".endif\r\n" + ".ifdecl __PIC24F\r\n" + "    .include \"p24fxxxx.inc\"\r\n" + ".endif\r\n" + ".if VALID_ID <> 1\r\n" + "    .error \"Processor ID not specified in generic include files.  New ASM30 assembler needs to be downloaded?\"\r\n" + ".endif\r\n" + "\t.text\r\n" + "\t.section\tMPFSData,code\r\n\r\n" + "\tgoto END_OF_MPFS\t; Prevent accidental execution of constant data.\r\n" + "\t.global BEGIN_MPFS\r\n" + "BEGIN_MPFS:");
            }
            catch (IOException e) {
                System.out.println("IO exception = " + e);
                MPFS2Lib.this.log.add("ERROR: " + e.getMessage());
            }
        }

        public void Write(byte data) {
            try {
                if (this.ImageLength % 12 == 0) {
                    this.fout.write("\r\n\t.pbyte\t");
                }
                String tempStr = String.format("%02x", data);
                this.fout.write("0x" + tempStr);
                ++this.ImageLength;
                if (this.ImageLength % 12 != 0) {
                    this.fout.write(",");
                }
            }
            catch (IOException e) {
                System.out.println("IO exception = " + e);
                MPFS2Lib.this.log.add("ERROR: " + e.getMessage());
            }
        }

        public void Close() {
            try {
                if (this.ImageLength % 12 == 0) {
                    this.fout.write(",");
                }
                this.fout.write("0x00\r\nEND_OF_MPFS:\r\n\r\n\t.section\t.const,psv\r\n\t.global\t_MPFS_Start\r\n_MPFS_Start:\r\n\t.long\tpaddr(BEGIN_MPFS)\r\n\r\n\t.section\tMPFSHelpers,code\r\n\r\n\t.global _ReadProgramMemory\r\n_ReadProgramMemory:\r\n\tpush\t\t_TBLPAG\r\n\tmov\t\t\tw1,_TBLPAG\r\n\tmov\t\t\tw0,w5\r\n\ttblrdl\t\t[w5],w0\r\n\ttblrdh\t\t[w5],w1\r\n\tpop\t\t\t_TBLPAG\r\n\treturn\r\n");
                this.fout.flush();
                this.fout.close();
            }
            catch (IOException e) {
                System.out.println("IO exception = " + e);
                MPFS2Lib.this.log.add("ERROR: " + e.getMessage());
            }
        }
    }

    public class MPFS2BINWriter
    extends MPFS2Writer {
        public FileOutputStream file_output;
        public DataOutputStream data_out;
        public BufferedWriter fout;
        public ByteArrayOutputStream binOut;

        public MPFS2BINWriter(String filename) {
            this.binOut = new ByteArrayOutputStream();
            if (!filename.endsWith(".bin")) {
                filename = filename + ".bin";
            }
            try {
                this.file_output = new FileOutputStream(filename);
            }
            catch (IOException e) {
                System.out.println("IO exception = " + e);
                MPFS2Lib.this.log.add("ERROR: " + e.getMessage());
            }
            this.imageName = filename;
        }

        public void Write(byte data) {
            ++this.ImageLength;
            this.binOut.write(data);
        }

        public void Close() {
            try {
                byte[] temp = this.binOut.toByteArray();
                this.file_output.write(temp, 0, this.ImageLength);
                this.file_output.flush();
                this.file_output.close();
            }
            catch (IOException e) {
                System.out.println("IO exception = " + e);
                MPFS2Lib.this.log.add("ERROR: " + e.getMessage());
            }
        }
    }

    public class MPFS2C18Writer
    extends MPFS2Writer {
        public FileOutputStream file_output;
        public DataOutputStream data_out;
        public BufferedWriter fout;

        public MPFS2C18Writer(String filename) {
            Date date = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("E MMM dd yyyy hh:mm:ss");
            if (!filename.endsWith(".c")) {
                filename = filename + ".c";
            }
            try {
                this.file_output = new FileOutputStream(filename);
                this.data_out = new DataOutputStream(this.file_output);
                this.fout = new BufferedWriter(new OutputStreamWriter(this.data_out));
                this.imageName = filename;
                this.fout.write("/***************************************************************\r\n * MPFSImg2.c\r\n * Defines an MPFS2 image to be stored in program memory.\r\n *\r\n * NOT FOR HAND MODIFICATION\r\n * This file is automatically generated by the MPFS2 Utility\r\n * ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS2 GENERATOR\r\n * Generated " + sdf.format(date) + " " + "\r\n" + " ***************************************************************/\r\n" + "\r\n#define __MPFSIMG2_C\r\n\r\n" + "#include \"TCPIPConfig.h\"\r\n" + "#if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)\r\n\r\n" + "#include \"TCPIP Stack/TCPIP.h\"\r\n" + "#if defined(STACK_USE_MPFS2)\r\n\r\n" + "\r\n" + "/**************************************\r\n" + " * MPFS2 Image Data\r\n" + " **************************************/");
            }
            catch (IOException e) {
                // empty catch block
            }
        }

        public void Write(byte data) {
            int temp = 0;
            try {
                char ASCIIdata = '.';
                if (data >= 32 && data <= 126 && data != 42) {
                    ASCIIdata = (char)data;
                }
                if (this.ImageLength % 1024 == 0) {
                    ASCIILine = " " + ASCIILine;
                } else {
                    this.fout.write(",");
                }
                if (this.ImageLength % 16 == 0) {
                    if (this.ImageLength != 0) {
                        this.fout.write(ASCIILine + " */");
                    }
                    ASCIILine = " /* ";
                }
                temp = this.ImageLength / 1024;
                String tempStr = String.format("%06x", temp);
                if (this.ImageLength % 1024 == 0) {
                    this.fout.write("\r\n#define DATACHUNK" + tempStr);
                }
                if (this.ImageLength % 16 == 0) {
                    this.fout.write(" \\\r\n\t");
                }
                ASCIILine = ASCIILine + Character.toString(ASCIIdata);
                tempStr = String.format("%02x", data);
                this.fout.write("0x" + tempStr);
                ++this.ImageLength;
            }
            catch (IOException e) {
                System.out.println("IO exception = " + e);
                MPFS2Lib.this.log.add("ERROR: " + e.getMessage());
            }
        }

        public void Close() {
            int lineLen = 0;
            try {
                String tempStr;
                if (this.ImageLength % 16 != 0) {
                    lineLen = (16 - this.ImageLength % 16) * 5 + 1;
                    String formatString = "%" + lineLen + "c";
                    tempStr = MPFS2Lib.padLeft(" ", lineLen);
                    tempStr = tempStr + MPFS2Lib.padRight(ASCIILine, 20);
                    tempStr = tempStr + " */";
                    this.fout.write(tempStr);
                }
                this.fout.write("\r\n\r\n\r\n");
                if (this.ImageLength != 0) {
                    int i;
                    this.fout.write("/**************************************\r\n * MPFS2 C linkable symbols\r\n **************************************/\r\n// For C18, these are split into seperate arrays because it speeds up compilation a lot.  \r\n// For other compilers, the entire data array must be defined as a single variable to \r\n// ensure that the linker does not reorder the data chunks in Flash when compiler \r\n// optimizations are turned on.\r\n#if defined(__18CXX)\r\n\tROM BYTE MPFS_Start[] = {DATACHUNK000000};\r\n");
                    for (i = 1024; i < this.ImageLength; i += 1024) {
                        tempStr = String.format("%06x", i / 1024);
                        tempStr = tempStr + "[] = {DATACHUNK";
                        tempStr = tempStr + String.format("%06x", i / 1024);
                        tempStr = "\tROM BYTE MPFS_" + tempStr + "};\r\n";
                        this.fout.write(tempStr);
                    }
                    this.fout.write("#else\r\n\tROM BYTE MPFS_Start[] = {");
                    for (i = 0; i < this.ImageLength; i += 1024) {
                        tempStr = "DATACHUNK" + String.format("%06x", i / 1024);
                        this.fout.write(tempStr);
                        if (i + 1024 >= this.ImageLength) continue;
                        this.fout.write(", ");
                    }
                    this.fout.write("};\r\n#endif\r\n\r\n\r\n");
                }
                this.fout.write("/**************************************************************\r\n * End of MPFS\r\n **************************************************************/\r\n#endif // #if defined(STACK_USE_MPFS2)\r\n#endif // #if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)\r\n");
                this.fout.flush();
                this.fout.close();
            }
            catch (IOException e) {
                System.out.println("IO exception = " + e);
                MPFS2Lib.this.log.add("ERROR: " + e.getMessage());
            }
        }
    }

    abstract class MPFS2Writer {
        public int ImageLength = 0;
        public String imageName;

        MPFS2Writer() {
        }

        public abstract void Write(byte var1);

        public abstract void Close();

        public void Write(byte[] data) {
            for (byte b : data) {
                this.Write(b);
            }
        }

        public void Write(String data) {
            for (byte b : data.getBytes()) {
                this.Write(b);
            }
        }

        public void Write(short data) {
            this.Write((byte)data);
            this.Write((byte)(data >> 8));
        }

        public void Write(int data) {
            this.Write((byte)data);
            this.Write((byte)(data >> 8));
            this.Write((byte)(data >> 16));
            this.Write((byte)(data >> 24));
        }

        public void Write(long data) {
            this.Write((byte)data);
            this.Write((byte)(data >> 8));
            this.Write((byte)(data >> 16));
            this.Write((byte)(data >> 24));
            this.Write((byte)(data >> 32));
            this.Write((byte)(data >> 40));
            this.Write((byte)(data >> 48));
            this.Write((byte)(data >> 56));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MPFSOutputFormat {
        BIN,
        C18,
        ASM30,
        C32,
        MDD;

    }
}

