/*
 * Decompiled with CFR 0.152.
 */
package MicrochipMPFS;

import MicrochipMPFS.AboutBox;
import MicrochipMPFS.AdvanceSettings;
import MicrochipMPFS.LogWindow;
import MicrochipMPFS.MPFS2Lib;
import MicrochipMPFS.SourceSettings;
import MicrochipMPFS.UploadSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sun.misc.BASE64Encoder;

public class MainMPFS
extends JFrame {
    public String uploadExceptionString = null;
    public int percen = 0;
    public int progressByteCount = 0;
    public int uploadFileLength = 0;
    public static Thread manageUpload;
    AdvanceSettings advSetting;
    UploadSettings uploadSettings;
    AboutBox aboutBox;
    public boolean generationResult;
    public List<String> generateLog;
    public MPFS_OUTPUT_VERSION outPutVersion = MPFS_OUTPUT_VERSION.MPFS2;
    public UPLOAD_PROTOCOL_OPTION uploadProtocol = UPLOAD_PROTOCOL_OPTION.HTTP;
    public String srourceDirectoryPath = "C:\\Microchip Solutions\\TCPIP Demo App\\WebPages2";
    public String projectBinFilePath = "C:\\Microchip Solutions\\TCPIP Demo App\\MPFSImg2.bin";
    public String projectDirectoryPath = "C:\\Microchip Solutions\\TCPIP Demo App";
    final ImageIcon icon = new ImageIcon(this.getClass().getResource("/Resource/mchpIcon.png"));
    String aboutStr;
    int progressVal = 0;
    int progressVal_temp = 0;
    URL url;
    public PasswordAuthentication pa;
    public int passwordAuthRetryCnt = 0;
    private JLabel LblSrcDir;
    private JLabel LblStart;
    private JTextField TextSrcDir;
    private JButton btnAdvSetting;
    private JButton btnGenAndUpload;
    private JButton btnProjectDir;
    private JButton btnSrcBrowse;
    private JButton btnUploadSetting;
    private JCheckBox chkBoxUpload;
    private JLabel groupLbl1;
    private JLabel groupLbl2;
    private JLabel groupLbl3;
    private JLabel groupLbl4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel6;
    private JProgressBar jProgressBar1;
    private JLabel lblMessage;
    private JLabel lblOuput;
    private JLabel lblProcess;
    private JLabel lblProjectDir;
    private JLabel lblProjectImg;
    private JLabel lblUploadImg;
    private JLabel lbnImageType;
    private JLabel lebelAbout;
    private ButtonGroup processOpnButGrp;
    private JRadioButton radAsm;
    private JRadioButton radBin;
    private JRadioButton radC18C32;
    private JRadioButton radMdd;
    private JRadioButton radPreBuildDir;
    private JRadioButton radWebDir;
    private ButtonGroup sourceSettingButGrp;
    private JTextField txtProjectDir;
    public JTextField txtProjectImageName;
    public JTextField txtUploadPath;
    private BindingGroup bindingGroup;

    public MainMPFS() {
        this.initComponents();
        this.jProgressBar1.setIndeterminate(false);
        this.setIconImage(this.icon.getImage());
        this.toolTipSettings();
        this.setSize(638, 520);
        this.TextSrcDir.setText(this.srourceDirectoryPath);
        this.txtProjectDir.setText(this.projectDirectoryPath);
        this.advSetting = new AdvanceSettings(this, true);
        this.uploadSettings = new UploadSettings(this, true);
        this.aboutBox = new AboutBox(this, true);
        this.txtUploadPath.setText(this.uploadSettings.getUploadPathStr());
        this.aboutStr = "<html>Date JUNE,16 2011<br>";
        String version = "Version MPFS 2.2";
        this.lebelAbout.setText(this.aboutStr + version + "</html>");
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        this.MainKeyEventActionIntialization();
    }

    public String GetProtocol() {
        if (this.radWebDir.isSelected()) {
            if (this.outPutVersion == MPFS_OUTPUT_VERSION.MPFS2 && this.uploadProtocol == UPLOAD_PROTOCOL_OPTION.HTTP) {
                return "http";
            }
            return "ftp";
        }
        try {
            FileInputStream bin = new FileInputStream(this.projectBinFilePath);
            if (bin.read() == 77 && bin.read() == 80 && bin.read() == 70 && bin.read() == 83 && bin.read() == 2) {
                bin.close();
                if (this.outPutVersion == MPFS_OUTPUT_VERSION.MPFS2 && this.uploadProtocol == UPLOAD_PROTOCOL_OPTION.HTTP) {
                    return "http";
                }
                return "ftp";
            }
            bin.close();
            this.generateLog.add("Error : Invalid Source file.");
            return null;
        }
        catch (IOException e) {
            return "http";
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.sourceSettingButGrp = new ButtonGroup();
        this.processOpnButGrp = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.groupLbl1 = new JLabel();
        this.LblStart = new JLabel();
        this.LblSrcDir = new JLabel();
        this.TextSrcDir = new JTextField();
        this.radWebDir = new JRadioButton();
        this.radPreBuildDir = new JRadioButton();
        this.btnSrcBrowse = new JButton();
        this.jPanel3 = new JPanel();
        this.groupLbl3 = new JLabel();
        this.lblProjectDir = new JLabel();
        this.txtProjectDir = new JTextField();
        this.btnProjectDir = new JButton();
        this.lblProjectImg = new JLabel();
        this.txtProjectImageName = new JTextField();
        this.lbnImageType = new JLabel();
        this.jPanel2 = new JPanel();
        this.groupLbl2 = new JLabel();
        this.lblOuput = new JLabel();
        this.lblProcess = new JLabel();
        this.radBin = new JRadioButton();
        this.radC18C32 = new JRadioButton();
        this.radAsm = new JRadioButton();
        this.radMdd = new JRadioButton();
        this.btnAdvSetting = new JButton();
        this.jPanel4 = new JPanel();
        this.groupLbl4 = new JLabel();
        this.lblUploadImg = new JLabel();
        this.chkBoxUpload = new JCheckBox();
        this.txtUploadPath = new JTextField();
        this.btnUploadSetting = new JButton();
        this.jPanel6 = new JPanel();
        this.btnGenAndUpload = new JButton();
        this.lebelAbout = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.lblMessage = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Microchip MPFS Generator");
        this.setLocationByPlatform(true);
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this, ELProperty.create("false"), this, BeanProperty.create("resizable"));
        this.bindingGroup.addBinding(binding);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Source Settings", 1, 2, new Font("Microsoft Sans Serif", 1, 11)));
        this.jPanel1.setFont(new Font("MS Reference Sans Serif", 0, 11));
        this.jPanel1.setName("Source Settings");
        this.jPanel1.setLayout(new AbsoluteLayout());
        this.groupLbl1.setFont(new Font("Microsoft Sans Serif", 1, 14));
        this.groupLbl1.setText("1.");
        this.groupLbl1.setName("SrcSetting");
        this.jPanel1.add((Component)this.groupLbl1, new AbsoluteConstraints(10, 50, -1, -1));
        this.LblStart.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.LblStart.setText("Start With:");
        this.jPanel1.add((Component)this.LblStart, new AbsoluteConstraints(70, 25, 100, -1));
        this.LblSrcDir.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.LblSrcDir.setText("Source Directory:");
        this.jPanel1.add((Component)this.LblSrcDir, new AbsoluteConstraints(70, 50, 124, -1));
        this.TextSrcDir.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.TextSrcDir.setToolTipText("Selects the source file(s) for the remainder of the process.");
        this.TextSrcDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainMPFS.this.TextSrcDirActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.TextSrcDir, new AbsoluteConstraints(70, 70, 399, -1));
        this.sourceSettingButGrp.add(this.radWebDir);
        this.radWebDir.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.radWebDir.setSelected(true);
        this.radWebDir.setText("Webpage Directory");
        this.radWebDir.setToolTipText("Generate a new image from a directory of files.");
        this.radWebDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainMPFS.this.radWebDirActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.radWebDir, new AbsoluteConstraints(220, 20, -1, -1));
        this.sourceSettingButGrp.add(this.radPreBuildDir);
        this.radPreBuildDir.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.radPreBuildDir.setText("Pre-Built MPFS Image");
        this.radPreBuildDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainMPFS.this.radPreBuildDirActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.radPreBuildDir, new AbsoluteConstraints(429, 20, 140, -1));
        this.btnSrcBrowse.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.btnSrcBrowse.setText("Browse");
        this.btnSrcBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainMPFS.this.btnSrcBrowseActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.btnSrcBrowse, new AbsoluteConstraints(480, 68, 96, -1));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Output Files", 1, 2, new Font("Microsoft Sans Serif", 1, 11)));
        this.jPanel3.setFont(new Font("MS Reference Sans Serif", 0, 11));
        this.jPanel3.setName("Source Settings");
        this.jPanel3.setLayout(new AbsoluteLayout());
        this.groupLbl3.setFont(new Font("Microsoft Sans Serif", 1, 14));
        this.groupLbl3.setText("3.");
        this.jPanel3.add((Component)this.groupLbl3, new AbsoluteConstraints(6, 31, -1, -1));
        this.lblProjectDir.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.lblProjectDir.setText("Project Directory:");
        this.jPanel3.add((Component)this.lblProjectDir, new AbsoluteConstraints(75, 20, 127, -1));
        this.txtProjectDir.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.txtProjectDir.setToolTipText("<html>Select your MPLAB project directory.<br>Your image file will be placed here, along with HTTPPrint.h if applicable.<\\html>");
        this.jPanel3.add((Component)this.txtProjectDir, new AbsoluteConstraints(75, 41, 390, -1));
        this.btnProjectDir.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.btnProjectDir.setText("Browse");
        this.btnProjectDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainMPFS.this.btnProjectDirActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.btnProjectDir, new AbsoluteConstraints(475, 38, 100, -1));
        this.lblProjectImg.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.lblProjectImg.setText("Image Name:");
        this.jPanel3.add((Component)this.lblProjectImg, new AbsoluteConstraints(80, 70, -1, -1));
        this.txtProjectImageName.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.txtProjectImageName.setText("mpfsimage");
        this.txtProjectImageName.setToolTipText("File name for the image you'd like to create.");
        this.jPanel3.add((Component)this.txtProjectImageName, new AbsoluteConstraints(179, 68, 164, -1));
        this.lbnImageType.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.lbnImageType.setText("[.bin]");
        this.jPanel3.add((Component)this.lbnImageType, new AbsoluteConstraints(347, 71, 33, -1));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Processing Options", 1, 2, new Font("Microsoft Sans Serif", 1, 11)));
        this.jPanel2.setFont(new Font("MS Reference Sans Serif", 0, 11));
        this.jPanel2.setName("Source Settings");
        this.jPanel2.setLayout(new AbsoluteLayout());
        this.groupLbl2.setFont(new Font("Microsoft Sans Serif", 1, 14));
        this.groupLbl2.setText("2.");
        this.jPanel2.add((Component)this.groupLbl2, new AbsoluteConstraints(6, 43, -1, -1));
        this.lblOuput.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.lblOuput.setText("Output:");
        this.jPanel2.add((Component)this.lblOuput, new AbsoluteConstraints(74, 31, -1, -1));
        this.lblProcess.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.lblProcess.setText("Processing:");
        this.jPanel2.add((Component)this.lblProcess, new AbsoluteConstraints(74, 63, -1, -1));
        this.processOpnButGrp.add(this.radBin);
        this.radBin.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.radBin.setSelected(true);
        this.radBin.setText("BIN Image");
        this.radBin.setToolTipText("Output a BIN image to be uploaded to external storage, such as EEPROM or serial Flash.");
        this.radBin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainMPFS.this.radBinActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.radBin, new AbsoluteConstraints(160, 28, -1, -1));
        this.processOpnButGrp.add(this.radC18C32);
        this.radC18C32.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.radC18C32.setText("C18/C32 Image");
        this.radC18C32.setToolTipText("Output an image compatible with C18/C32 to be stored in internal Flash program memory.");
        this.radC18C32.setName("radC18C30Image");
        this.radC18C32.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainMPFS.this.radC18C32ActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.radC18C32, new AbsoluteConstraints(264, 28, -1, -1));
        this.processOpnButGrp.add(this.radAsm);
        this.radAsm.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.radAsm.setText("ASM30 Image");
        this.radAsm.setToolTipText("Output an image compatible with C30 to be stored in internal Flash program memory.  Remember to add the generated .S file to your project.");
        this.radAsm.setName("radASM30Image");
        this.radAsm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainMPFS.this.radAsmActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.radAsm, new AbsoluteConstraints(383, 28, -1, -1));
        this.processOpnButGrp.add(this.radMdd);
        this.radMdd.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.radMdd.setText("MDD");
        this.radMdd.setToolTipText("Use this option to store pages on drive using MDD file system.");
        this.radMdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainMPFS.this.radMddActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.radMdd, new AbsoluteConstraints(486, 28, -1, -1));
        this.btnAdvSetting.setFont(new Font("Microsoft Sans Serif", 0, 14));
        this.btnAdvSetting.setText("Advanced Settings");
        this.btnAdvSetting.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainMPFS.this.btnAdvSettingActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.btnAdvSetting, new AbsoluteConstraints(182, 58, 157, -1));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Upload Settings", 1, 2, new Font("Microsoft Sans Serif", 1, 11)));
        this.jPanel4.setFont(new Font("MS Reference Sans Serif", 0, 11));
        this.jPanel4.setName("Source Settings");
        this.jPanel4.setLayout(new AbsoluteLayout());
        this.groupLbl4.setFont(new Font("Microsoft Sans Serif", 1, 14));
        this.groupLbl4.setText("4.");
        this.jPanel4.add((Component)this.groupLbl4, new AbsoluteConstraints(6, 31, -1, -1));
        this.lblUploadImg.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.lblUploadImg.setText("Upload Image To:");
        this.jPanel4.add((Component)this.lblUploadImg, new AbsoluteConstraints(73, 20, -1, -1));
        this.chkBoxUpload.setSelected(true);
        this.chkBoxUpload.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MainMPFS.this.chkBoxUploadStateChanged(evt);
            }
        });
        this.chkBoxUpload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainMPFS.this.chkBoxUploadActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.chkBoxUpload, new AbsoluteConstraints(74, 42, 20, 20));
        this.txtUploadPath.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.txtUploadPath.setToolTipText("Your MPFS image will be uploaded here.  Use the Settings button to modify this destination.");
        this.txtUploadPath.setFocusable(false);
        this.txtUploadPath.setMinimumSize(new Dimension(400, 400));
        this.jPanel4.add((Component)this.txtUploadPath, new AbsoluteConstraints(100, 41, 360, -1));
        this.btnUploadSetting.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.btnUploadSetting.setText("Settings");
        this.btnUploadSetting.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainMPFS.this.btnUploadSettingActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.btnUploadSetting, new AbsoluteConstraints(470, 37, 100, -1));
        this.jPanel6.setLayout(new AbsoluteLayout());
        this.btnGenAndUpload.setText("Generate and Upload");
        this.btnGenAndUpload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainMPFS.this.btnGenAndUploadActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.btnGenAndUpload, new AbsoluteConstraints(200, 10, 155, -1));
        this.lebelAbout.setBackground(new Color(153, 153, 153));
        this.lebelAbout.setFont(new Font("Microsoft Sans Serif", 1, 11));
        this.lebelAbout.setForeground(new Color(0, 0, 204));
        this.lebelAbout.setText("<html> date <br> version </html>");
        this.lebelAbout.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.lebelAbout.setCursor(new Cursor(12));
        this.lebelAbout.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainMPFS.this.lebelAboutMouseClicked(evt);
            }
        });
        this.jPanel6.add((Component)this.lebelAbout, new AbsoluteConstraints(390, 0, 210, 38));
        this.jProgressBar1.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.jProgressBar1.setIndeterminate(true);
        this.jProgressBar1.setMaximumSize(new Dimension(16, 16));
        this.jProgressBar1.setMinimumSize(new Dimension(16, 16));
        this.jPanel6.add((Component)this.jProgressBar1, new AbsoluteConstraints(10, 50, 173, 20));
        this.lblMessage.setText("[Generator Idle]");
        this.jPanel6.add((Component)this.lblMessage, new AbsoluteConstraints(190, 50, 420, 20));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel6, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, 606, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, 103, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, 89, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.bindingGroup.bind();
        this.pack();
    }

    private void btnGenAndUploadActionPerformed(ActionEvent evt) {
        final MPFS2Lib builder = new MPFS2Lib();
        MPFS2Lib.MPFSClassicBuilder classicBuilder = null;
        if (this.radWebDir.isSelected()) {
            if (this.outPutVersion == MPFS_OUTPUT_VERSION.MPFS2) {
                builder.MPFS2Builder(this.txtProjectDir.getText(), this.txtProjectImageName.getText());
                builder.DynamicTypes(this.advSetting.DynVarStr);
                builder.NonGZipTypes(this.advSetting.NoCompStr);
                this.lblMessage.setText("Adding source files to image...");
                builder.AddDirectory(this.TextSrcDir.getText());
            } else {
                MPFS2Lib mPFS2Lib = builder;
                mPFS2Lib.getClass();
                classicBuilder = mPFS2Lib.new MPFS2Lib.MPFSClassicBuilder(this.txtProjectDir.getText(), this.txtProjectImageName.getText());
                classicBuilder.ReserveBlock = this.advSetting.reserveBlock;
                this.lblMessage.setText("Adding source files to image...");
                classicBuilder.AddDirectory(this.TextSrcDir.getText(), "");
            }
            this.lblMessage.setText("Generating output image...");
            this.jProgressBar1.setStringPainted(true);
            this.jProgressBar1.setMaximum(120);
            this.jProgressBar1.setMinimum(0);
            this.jProgressBar1.setValue(this.radBin.isSelected() && this.chkBoxUpload.isSelected() ? 20 : 70);
            if (this.outPutVersion == MPFS_OUTPUT_VERSION.MPFS2) {
                if (this.radBin.isSelected()) {
                    this.generationResult = builder.Generate(MPFS2Lib.MPFSOutputFormat.BIN);
                } else if (this.radC18C32.isSelected()) {
                    this.generationResult = builder.Generate(MPFS2Lib.MPFSOutputFormat.C18);
                } else if (this.radAsm.isSelected()) {
                    this.generationResult = builder.Generate(MPFS2Lib.MPFSOutputFormat.ASM30);
                } else if (this.radMdd.isSelected()) {
                    this.generationResult = builder.Generate(MPFS2Lib.MPFSOutputFormat.MDD);
                }
            } else if (this.radBin.isSelected()) {
                this.generationResult = classicBuilder.Generate(MPFS2Lib.MPFSOutputFormat.BIN);
            } else if (this.radC18C32.isSelected()) {
                this.generationResult = classicBuilder.Generate(MPFS2Lib.MPFSOutputFormat.C18);
            } else if (this.radAsm.isSelected()) {
                this.generationResult = classicBuilder.Generate(MPFS2Lib.MPFSOutputFormat.ASM30);
            } else if (this.radMdd.isSelected()) {
                this.generationResult = classicBuilder.Generate(MPFS2Lib.MPFSOutputFormat.MDD);
            }
            this.jProgressBar1.setIndeterminate(false);
            this.jProgressBar1.setValue(this.radBin.isSelected() && this.chkBoxUpload.isSelected() ? 20 : 120);
            this.generateLog = builder.log;
            if (this.radBin.isSelected() && this.chkBoxUpload.isSelected() && this.generationResult) {
                manageUpload = new Thread(){

                    public void run() {
                        MainMPFS.this.UploadImage(builder.GeneratedImageFileName());
                    }
                };
                manageUpload.start();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ie) {}
            } else if (this.generationResult) {
                this.ShowResultDialog("The MPFS2 image was successfully generated.");
            } else {
                this.ShowResultDialog("Errors were encountered while generating the MPFS image.");
            }
            this.jProgressBar1.setValue(0);
            if (builder.indexUpdated) {
                JOptionPane.showMessageDialog(null, "The dynamic variables in your web pages have changed!\n\nRemember to recompile your MPLAB project before continuing\nto ensure that the project is in sync.", "MPFS2 Warning", 1);
            }
        } else {
            this.generationResult = true;
            this.generateLog = new ArrayList<String>();
            manageUpload = new Thread(){

                public void run() {
                    MainMPFS.this.UploadImage(MainMPFS.this.projectBinFilePath);
                }
            };
            manageUpload.start();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    private void UploadImage(String fileName) {
        String protocol;
        this.passwordAuthRetryCnt = 0;
        File imageFile = new File(fileName);
        if (!imageFile.exists()) {
            this.generateLog.add("ERROR: Could not open " + fileName);
            this.generationResult = false;
            this.ShowResultDialog("The image could not be uploaded.");
        }
        if ((protocol = this.GetProtocol()) == null) {
            this.generateLog.add("ERROR: Could not open " + fileName);
            this.generationResult = false;
            this.ShowResultDialog("The image could not be uploaded.");
        }
        this.uploadFileLength = (int)imageFile.length();
        String userName = this.uploadSettings.getUserName();
        String pass = this.uploadSettings.getPasswordName();
        this.lblMessage.setText("Contacting device for upload...");
        if (protocol.contains("http")) {
            this.generateLog.add("Uploading MPFS2 image: " + imageFile.length() + " bytes");
            this.httpImageUpload(userName, pass, this.uploadSettings.getIpAddress(), this.uploadSettings.getUploadPath(), imageFile, protocol);
        } else {
            this.generateLog.add("Uploading MPFS2 image: " + imageFile.length() + " bytes");
            this.ftpImageUpload(userName, pass, this.uploadSettings.getIpAddress(), this.uploadSettings.getUploadPath(), imageFile, protocol);
        }
    }

    void httpImageUpload(final String userName, final String pass, String IPAddr, String uploadPath, File imageFile, String protocol) {
        try {
            int byteRead;
            if (userName.length() > 0) {
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (MainMPFS.this.passwordAuthRetryCnt > 0) {
                            return null;
                        }
                        ++MainMPFS.this.passwordAuthRetryCnt;
                        return new PasswordAuthentication(userName, pass.toCharArray());
                    }
                });
            }
            this.lblMessage.setText("Contacting device for upload...");
            String boundary = Long.toString(System.currentTimeMillis(), 16);
            String auth = userName + ":" + pass;
            String urlPath = protocol + "://" + IPAddr + ":80/" + uploadPath;
            URL url = new URL(urlPath);
            URLConnection conn = url.openConnection();
            HttpURLConnection uConn = (HttpURLConnection)conn;
            uConn.setRequestProperty("Authorization", "Basic " + new BASE64Encoder().encode(auth.getBytes()));
            uConn.setDoOutput(true);
            uConn.setDoInput(true);
            uConn.setRequestProperty("MIME-version", "1.0");
            uConn.setRequestProperty("Content-Type", "multipart/form-data;  boundary=" + boundary);
            uConn.setRequestProperty("Expect", "100-continue");
            uConn.setRequestProperty("Accept", "");
            HttpURLConnection.setFollowRedirects(false);
            uConn.setRequestProperty("Cache-Control", "no-cache");
            uConn.setInstanceFollowRedirects(false);
            conn.connect();
            InputStream input = uConn.getInputStream();
            input.close();
            uConn.disconnect();
            if (this.passwordAuthRetryCnt > 1) {
                this.generationResult = false;
                this.generateLog.add("ERROR: Could not contact remote device for upload.");
                this.generateLog.add("ERROR: Authentication failure");
                this.ShowResultDialog("The MPFS image could not be uploaded.");
                return;
            }
            urlPath = protocol + "://" + IPAddr + "/" + uploadPath;
            int totalNumberOfBytes = 0;
            String initialBoundaryStr = "-------------------" + boundary + "\r\n";
            String contentDisposition = "Content-Disposition: form-data; name=\"file\"; filename=\"" + imageFile.getName() + "\"\r\n";
            String contentType = "Content-Type: application/octet-stream\r\n";
            String newLine = "\r\n";
            String endBoundaryStr = "\r\n-----------------------" + boundary + "--\r\n";
            totalNumberOfBytes = initialBoundaryStr.length() + contentDisposition.length() + contentType.length() + newLine.length() + endBoundaryStr.length();
            URL url1 = new URL(urlPath);
            HttpURLConnection uConn1 = (HttpURLConnection)url1.openConnection();
            uConn1.setFixedLengthStreamingMode(this.uploadFileLength + totalNumberOfBytes);
            uConn1.setRequestProperty("Authorization", "Basic " + new BASE64Encoder().encode(auth.getBytes()));
            uConn1.setDoOutput(true);
            uConn1.setDoInput(true);
            uConn1.setRequestProperty("MIME-version", "1.0");
            uConn1.setRequestProperty("Content-Type", "multipart/form-data;  boundary=" + boundary);
            uConn1.setRequestProperty("Expect", "100-continue");
            uConn1.setRequestProperty("Accept", "");
            uConn1.setRequestProperty("Cache-Control", "no-cache");
            this.lblMessage.setText("Waiting for upload to complete...");
            FileInputStream inputFile = new FileInputStream(imageFile);
            DataInputStream in = new DataInputStream(inputFile);
            DataOutputStream outStream = new DataOutputStream(uConn1.getOutputStream());
            outStream.write(initialBoundaryStr.getBytes(), 0, initialBoundaryStr.length());
            outStream.write(contentDisposition.getBytes(), 0, contentDisposition.length());
            outStream.write(contentType.getBytes(), 0, contentType.length());
            outStream.write(newLine.getBytes(), 0, newLine.length());
            int bufByte = 10000;
            this.jProgressBar1.setStringPainted(false);
            this.jProgressBar1.setMaximum(100);
            this.jProgressBar1.setMinimum(0);
            this.jProgressBar1.setValue(0);
            this.progressVal = this.uploadFileLength < bufByte ? this.uploadFileLength : this.uploadFileLength / bufByte;
            this.progressVal_temp = this.progressVal;
            byte[] tempbuf = new byte[bufByte];
            while ((byteRead = in.read(tempbuf)) != -1) {
                outStream.write(tempbuf, 0, byteRead);
                this.progressByteCount += byteRead;
                ++this.percen;
                this.lblMessage.setText("Uploading image (" + this.progressByteCount + " / " + this.uploadFileLength + " bytes)");
                this.jProgressBar1.setValue(100 / this.progressVal * this.percen);
            }
            outStream.write(endBoundaryStr.getBytes(), 0, endBoundaryStr.length());
            in.close();
            outStream.flush();
            outStream.close();
            this.jProgressBar1.setValue(100);
            this.lblMessage.setText("Uploading image (" + this.uploadFileLength + " / " + this.uploadFileLength + " bytes)");
            uConn1.disconnect();
            this.progressByteCount = 0;
            this.percen = 0;
            this.lblMessage.setText("Process Complete... See status dialog.");
        }
        catch (Exception uploadException) {
            this.generationResult = false;
            this.uploadExceptionString = uploadException.getMessage();
            this.lblMessage.setText("Waiting for upload to complete...");
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (MainMPFS.this.uploadExceptionString == null && MainMPFS.this.generationResult) {
                    MainMPFS.this.ShowResultDialog("The MPFS2 image upload was successfully completed.");
                } else {
                    MainMPFS.this.generationResult = false;
                    MainMPFS.this.generateLog.add("ERROR: Could not contact remote device for upload.");
                    MainMPFS.this.generateLog.add("ERROR: " + MainMPFS.this.uploadExceptionString);
                    MainMPFS.this.ShowResultDialog("The MPFS2 image could not be uploaded.");
                }
                MainMPFS.this.uploadExceptionString = null;
            }
        });
    }

    void ftpImageUpload(String userName, String pass, String IPAddr, String uploadPath, File imageFile, String protocol) {
        try {
            int byteRead;
            this.lblMessage.setText("Contacting device for upload...");
            String auth = userName + ":" + pass;
            String urlPath = protocol + "://" + auth + "@" + IPAddr + "/" + uploadPath;
            URL url1 = new URL(urlPath);
            URLConnection uConn1 = url1.openConnection();
            uConn1.setDoOutput(true);
            uConn1.setDoInput(true);
            uConn1.setRequestProperty("Cache-Control", "no-cache");
            this.lblMessage.setText("Waiting for upload to complete...");
            FileInputStream inputFile = new FileInputStream(imageFile);
            DataInputStream in = new DataInputStream(inputFile);
            DataOutputStream outStream = new DataOutputStream(uConn1.getOutputStream());
            int bufByte = 10000;
            this.jProgressBar1.setStringPainted(false);
            this.jProgressBar1.setMaximum(100);
            this.jProgressBar1.setMinimum(0);
            this.jProgressBar1.setValue(0);
            this.progressVal_temp = this.progressVal = this.uploadFileLength / bufByte;
            byte[] tempbuf = new byte[bufByte];
            while ((byteRead = in.read(tempbuf)) != -1) {
                outStream.write(tempbuf, 0, byteRead);
                this.progressByteCount += byteRead;
                ++this.percen;
                this.lblMessage.setText("Uploading image (" + this.progressByteCount + " / " + this.uploadFileLength + " bytes)");
                this.jProgressBar1.setValue(100 / this.progressVal * this.percen);
            }
            in.close();
            outStream.flush();
            outStream.close();
            this.jProgressBar1.setValue(100);
            System.out.println("outputstream Size:" + outStream.size());
            this.progressByteCount = 0;
            this.percen = 0;
            this.lblMessage.setText("Process Complete... See status dialog.");
        }
        catch (Exception uploadException) {
            this.lblMessage.setText("Waiting for upload to complete...");
            this.generationResult = false;
            this.uploadExceptionString = uploadException.getMessage();
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                MainMPFS.this.lblMessage.setText("Process Complete... See status dialog.");
                if (MainMPFS.this.uploadExceptionString == null && MainMPFS.this.generationResult) {
                    MainMPFS.this.ShowResultDialog("The MPFS image upload was successfully completed.");
                } else {
                    MainMPFS.this.generationResult = false;
                    MainMPFS.this.generateLog.add("ERROR: Could not contact remote device for upload.");
                    MainMPFS.this.generateLog.add("The remote server returned an error: " + MainMPFS.this.uploadExceptionString);
                    MainMPFS.this.ShowResultDialog("The MPFS image could not be uploaded.");
                }
                MainMPFS.this.uploadExceptionString = null;
            }
        });
    }

    private void ShowResultDialog(String message) {
        LogWindow dlg = this.generationResult ? new LogWindow((Frame)this, true, "OptionPane.informationIcon") : new LogWindow((Frame)this, true, "OptionPane.errorIcon");
        dlg.setListArray(this.generateLog);
        dlg.setLabelMsg(message);
        dlg.setVisible(true);
        this.lblMessage.setText("[Generator Idle]");
        this.jProgressBar1.setValue(0);
    }

    private void btnSrcBrowseActionPerformed(ActionEvent evt) {
        String srcPath;
        SourceSettings browseButton = new SourceSettings(this, true);
        if (this.getRadBotWebPageDirStatus()) {
            String srcPath2 = browseButton.getDirctoryPath();
            if (srcPath2 != null) {
                this.TextSrcDir.setText(srcPath2);
                this.txtProjectDir.setText(browseButton.getParentDirctoryPath());
                this.srourceDirectoryPath = this.TextSrcDir.getText();
            }
        } else if (this.getRadBotPreBuildDirStatus() && (srcPath = browseButton.getDirctoryPath()) != null) {
            this.TextSrcDir.setText(srcPath);
            this.projectBinFilePath = this.TextSrcDir.getText();
        }
        this.txtUploadPath.setText(this.uploadSettings.getUploadPathStr());
    }

    private void radC18C32ActionPerformed(ActionEvent evt) {
        this.lbnImageType.setText("[.c]");
        this.jPanel4.setVisible(false);
        this.btnGenAndUpload.setText("Generate");
        this.lblProjectImg.setVisible(true);
        this.txtProjectImageName.setVisible(true);
        this.lbnImageType.setVisible(true);
        this.setSize(638, 420);
        this.radPreBuildDir.setEnabled(true);
        this.btnAdvSetting.setEnabled(true);
        this.btnAdvSetting.setFocusable(true);
    }

    private void radAsmActionPerformed(ActionEvent evt) {
        this.lbnImageType.setText("[.s]");
        this.jPanel4.setVisible(false);
        this.btnGenAndUpload.setText("Generate");
        this.lblProjectImg.setVisible(true);
        this.txtProjectImageName.setVisible(true);
        this.lbnImageType.setVisible(true);
        this.setSize(638, 420);
        this.radPreBuildDir.setEnabled(true);
        this.btnAdvSetting.setEnabled(true);
        this.btnAdvSetting.setFocusable(true);
    }

    private void chkBoxUploadActionPerformed(ActionEvent evt) {
        String str = new String();
        str = this.txtUploadPath.getText();
        this.txtUploadPath.setText(this.txtUploadPath.getText());
    }

    private void radWebDirActionPerformed(ActionEvent evt) {
        this.jPanel2.setEnabled(true);
        this.jPanel3.setEnabled(true);
        this.jPanel2.setVisible(true);
        this.jPanel3.setVisible(true);
        this.setSize(638, 520);
        this.TextSrcDir.setText(this.srourceDirectoryPath);
        if (this.radBin.isSelected()) {
            this.radBinActionPerformed(null);
        } else if (this.radC18C32.isSelected()) {
            this.radC18C32ActionPerformed(null);
        } else if (this.radAsm.isSelected()) {
            this.radAsmActionPerformed(null);
        } else if (this.radMdd.isSelected()) {
            this.radMddActionPerformed(null);
        }
        this.chkBoxUpload.setVisible(true);
        this.chkBoxUpload.setEnabled(true);
        if (this.chkBoxUpload.isSelected() && this.radBin.isSelected()) {
            this.btnGenAndUpload.setText("Generate and Upload");
        } else if (!this.chkBoxUpload.isSelected()) {
            this.btnGenAndUpload.setText("Generate");
        }
        this.txtUploadPath.setText(this.uploadSettings.getUploadPathStr());
    }

    private void btnProjectDirActionPerformed(ActionEvent evt) {
        SourceSettings ProjectDir = new SourceSettings(this, true);
        if (ProjectDir.getOutputDirctoryPath() != null) {
            this.txtProjectDir.setText(ProjectDir.getParentDirctoryPath());
        }
    }

    private void btnAdvSettingActionPerformed(ActionEvent evt) {
        this.advSetting.setVisible(true);
        this.advSetting.defaultAdvanceSetting();
        this.outPutVersion = MPFS_OUTPUT_VERSION.MPFS2;
        this.txtUploadPath.setText(this.uploadSettings.getUploadPathStr());
    }

    private void btnUploadSettingActionPerformed(ActionEvent evt) {
        this.uploadSettings.setVisible(true);
        this.txtUploadPath.setText(this.uploadSettings.getUploadPathStr());
        this.uploadProtocol = this.uploadSettings.getUploadProtocolradBut() ? UPLOAD_PROTOCOL_OPTION.HTTP : UPLOAD_PROTOCOL_OPTION.FTP;
        this.txtUploadPath.setText(this.uploadSettings.getUploadPathStr());
    }

    private void chkBoxUploadStateChanged(ChangeEvent evt) {
        if (this.chkBoxUpload.isSelected()) {
            this.txtUploadPath.setEnabled(true);
            this.btnUploadSetting.setEnabled(true);
            String str = new String();
            str = this.txtUploadPath.getText();
            this.txtUploadPath.setText(this.txtUploadPath.getText());
            this.btnGenAndUpload.setText("Generate and Upload");
        } else {
            this.txtUploadPath.setEnabled(false);
            this.btnUploadSetting.setEnabled(false);
            this.btnGenAndUpload.setText("Generate");
        }
    }

    private void radPreBuildDirActionPerformed(ActionEvent evt) {
        this.jPanel4.setVisible(true);
        this.jPanel2.setEnabled(false);
        this.jPanel3.setEnabled(false);
        this.jPanel2.setVisible(false);
        this.jPanel3.setVisible(false);
        this.setSize(638, 300);
        this.TextSrcDir.setText(this.projectBinFilePath);
        this.chkBoxUpload.setEnabled(false);
        this.chkBoxUpload.setVisible(false);
        this.btnGenAndUpload.setText("Upload");
        this.txtUploadPath.setText(this.uploadSettings.getUploadPathStr());
        this.txtUploadPath.setEnabled(true);
        this.btnUploadSetting.setEnabled(true);
    }

    private void radBinActionPerformed(ActionEvent evt) {
        this.lbnImageType.setText("[.bin]");
        this.jPanel4.setVisible(true);
        if (this.chkBoxUpload.isSelected()) {
            this.btnGenAndUpload.setText("Generate and Upload");
        } else {
            this.btnGenAndUpload.setText("Generate");
        }
        this.lblProjectImg.setVisible(true);
        this.txtProjectImageName.setVisible(true);
        this.lbnImageType.setVisible(true);
        this.setSize(638, 520);
        this.radPreBuildDir.setEnabled(true);
        this.btnAdvSetting.setEnabled(true);
        this.btnAdvSetting.setFocusable(true);
    }

    private void radMddActionPerformed(ActionEvent evt) {
        this.jPanel4.setVisible(false);
        this.btnGenAndUpload.setText("Generate");
        this.lblProjectImg.setVisible(false);
        this.txtProjectImageName.setVisible(false);
        this.lbnImageType.setVisible(false);
        this.setSize(638, 420);
        this.radPreBuildDir.setEnabled(false);
        this.btnAdvSetting.setEnabled(false);
    }

    private void lebelAboutMouseClicked(MouseEvent evt) {
        this.aboutBox.setVisible(true);
    }

    private void TextSrcDirActionPerformed(ActionEvent evt) {
        File dir = new File(this.TextSrcDir.getText());
        String imageName = this.txtProjectImageName.getText();
        if (!imageName.endsWith(".bin")) {
            imageName = imageName.concat(".bin");
        }
        if (this.radWebDir.isEnabled()) {
            this.txtProjectDir.setText(dir.getParent());
            this.srourceDirectoryPath = this.TextSrcDir.getText();
            this.projectDirectoryPath = this.txtProjectDir.getText();
            this.projectBinFilePath = this.projectDirectoryPath + File.separator + imageName;
        }
    }

    void toolTipSettings() {
        String infoString = "<html><body bgcolor=\"#FFFFCC\"> <b>";
        infoString = infoString + "<headings> <font size=\"4\">" + " MPFS Generator Help </font></headings></b><br>";
        this.radWebDir.setToolTipText(infoString + "Generate a new image from a directory of files." + "</body></html>");
        this.radPreBuildDir.setToolTipText(infoString + "Upload an existing BIN image to a device." + "</body></html>");
        this.TextSrcDir.setToolTipText(infoString + "Selects the source file(s) " + "for the remainder of the process." + "</body></html>");
        this.radBin.setToolTipText(infoString + "Output a BIN image to be <br>" + "uploaded to external storage,<br>such as EEPROM or serial Flash." + "</body></html>");
        this.radC18C32.setToolTipText(infoString + "Output an image compatible with " + "<br>C18/C32 to be stored in internal Flash <br>progra" + "m memory." + "</body></html>");
        this.radAsm.setToolTipText(infoString + "Output an image compatible with C30" + "<br>to be stored in internal Flash program<br> memory. " + "Remember to add the <br>generated .S file to your project." + "</body></html>");
        this.radMdd.setToolTipText(infoString + "Use this option to store pages " + "<br>on drive using MDD file system." + "</body></html>");
        this.txtProjectDir.setToolTipText(infoString + "Select your MPLAB project " + "directory. <br>Your image file will be placed here, <br>al" + "ong with HTTPPrint.h if applicable." + "</body></html>");
        this.txtProjectImageName.setToolTipText(infoString + "File name for the image" + "<br>you'd like to create." + "</body></html>");
        this.txtUploadPath.setToolTipText(infoString + "Your MPFS image will be " + "uploaded <br>here.  Use the Settings button to <br>modify thi" + "s destination." + "</body></html>");
        this.chkBoxUpload.setToolTipText(infoString + "Select this box to upload <br>" + "your image upon generation." + "</body></html>");
    }

    public boolean getRadBotWebPageDirStatus() {
        return this.radWebDir.isSelected();
    }

    public boolean getRadBotPreBuildDirStatus() {
        return this.radPreBuildDir.isSelected();
    }

    private void MainKeyEventActionIntialization() {
        AbstractAction ESCactionListener = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainMPFS.this.setVisible(false);
                System.exit(0);
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0, true);
        JRootPane comp = this.getRootPane();
        comp.getInputMap(2).put(stroke, "ESCAPE");
        ActionMap actionMap = comp.getActionMap();
        actionMap.put("ESCAPE", ESCactionListener);
        this.btnAdvSetting.getRootPane().setDefaultButton(this.btnAdvSetting);
        this.btnUploadSetting.getRootPane().setDefaultButton(this.btnUploadSetting);
        this.btnSrcBrowse.getRootPane().setDefaultButton(this.btnSrcBrowse);
        this.btnGenAndUpload.getRootPane().setDefaultButton(this.btnGenAndUpload);
        this.btnProjectDir.getRootPane().setDefaultButton(this.btnProjectDir);
    }

    public static void main(String[] args) {
        if (args.length != 0) {
            boolean genResult;
            if (args.length < 3) {
                System.out.println("\nUsage: MPFS2 [options] <SourceDir> <ProjectDir> <OutputFile>\n    /BIN\t\t(/b)\t: Output a BIN image (Default)\n    /C18_C32\t\t(/c)\t: Output a C18 or C32 image\n    /ASM30\t\t(/s)\t: Output an ASM30 image\n    /mpfs2\t\t(/2)\t: MPFS2 format (Default)\n    /html \"...\"\t\t(/h)\t: Dynamic file types (\"*.htm, *.html, *.xml, *.cgi\")\n    /xgzip \"...\"\t(/z)\t: Non-compressible types (\"snmp.bib, *.inc\")\n\nSourceDir, ProjectDir, and OutputFile are required and should be enclosed in quotes.\nOutputFile is placed relative to ProjectDir and *CANNOT* be a full path name.");
                return;
            }
            String sourceDir = args[args.length - 3];
            String projectDir = args[args.length - 2];
            String outputFile = args[args.length - 1];
            MPFS2Lib builder = new MPFS2Lib();
            MPFS2Lib.MPFSClassicBuilder classicBuilder = null;
            MPFS2Lib.MPFSOutputFormat fmt = MPFS2Lib.MPFSOutputFormat.BIN;
            int version = 2;
            int reserveBlock = 64;
            String htmlTypes = "*.htm, *.html, *.xml, *.cgi";
            String noGZipTypes = "*.inc, snmp.bib";
            for (int i = 0; i < args.length - 3; ++i) {
                String arg = args[i].toLowerCase();
                if (arg.compareTo("/bin") == 0 || arg.compareTo("/b") == 0) {
                    fmt = MPFS2Lib.MPFSOutputFormat.BIN;
                    continue;
                }
                if (arg.compareTo("/c18_c32") == 0 || arg.compareTo("/c") == 0) {
                    fmt = MPFS2Lib.MPFSOutputFormat.C18;
                    continue;
                }
                if (arg.compareTo("/asm30") == 0 || arg.compareTo("/s") == 0) {
                    fmt = MPFS2Lib.MPFSOutputFormat.ASM30;
                    continue;
                }
                if (arg.compareTo("/mpfs2") == 0 || arg.compareTo("/2") == 0) {
                    version = 2;
                    continue;
                }
                if (arg.compareTo("/html") == 0 || arg.compareTo("/h") == 0) {
                    htmlTypes = args[++i];
                    continue;
                }
                if (arg.compareTo("/xgzip") == 0 || arg.compareTo("/z") == 0) {
                    noGZipTypes = args[++i];
                    continue;
                }
                System.out.println("The command-line option \"" + args[i] + "\" was not recognized.");
                return;
            }
            if (version == 2) {
                builder.MPFS2Builder(projectDir, outputFile);
                builder.DynamicTypes(htmlTypes);
                builder.NonGZipTypes(noGZipTypes);
                builder.AddDirectory(sourceDir);
                genResult = builder.Generate(fmt);
            } else {
                MPFS2Lib mPFS2Lib = builder;
                mPFS2Lib.getClass();
                classicBuilder = mPFS2Lib.new MPFS2Lib.MPFSClassicBuilder(projectDir, outputFile);
                classicBuilder.ReserveBlock = reserveBlock;
                classicBuilder.AddDirectory(sourceDir, "");
                genResult = classicBuilder.Generate(fmt);
            }
            if (genResult) {
                System.out.println("The MPFS2 image was successfully generated.\n");
                return;
            }
            System.out.println("Errors were encountered while generating the MPFS2 image.\n");
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                new MainMPFS().setVisible(true);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UPLOAD_PROTOCOL_OPTION {
        HTTP,
        FTP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MPFS_OUTPUT_VERSION {
        MPFS2,
        MPFS_CLASSIC;

    }
}

