/*
 * Decompiled with CFR 0.152.
 */
package mib2bib;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import mib2bib.SnmpCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mib2bib {
    static String VERSION_INFO = "  v2.0.0  ";
    final int OID_STRING_LEN = 256;
    static final String commandHelp = "Detailed command help.\n\n$DeclareVar(oidName, oidDataType, oidType, oidAccess, oidString)\noidName: \n        Up to 32 characters long name of this OID. This name is also used in mib.h file for application usage.\noidDataType: \n        Any one of following keywords: \n        BYTE - 8-bit data type.\n        WORD - 16-bit data type.\n        DWORD - 32-bit data type.\n        OCTET_STRING - Byte array.\n        ASCII_STRING - ASCII String.\n        IP_ADDRESS - 4-byte long IP address.\n        COUNTER32 - 32-bit counter data type.\n        TIME_TICKS - 32-bit time tick data type.\n        GAUGE32 - 32-bit gauge data type.\n        OID - Dotted decimal OID string.\nAccess: \n        Any one of following keywords:\n        READONLY - This is read-only OID.\n        READWRITE - This is read-write OID.\noidString: \n        OID String value in \"dotted-decimal\" notation. All OID string must being with same root OID. If specifying internet OID, first decimal value must 43. e.g. 43.6.1.2.1.1.5.\n\n$StaticVar(oidName, oidValue...)\noidName: \n        oidName as defined by previous DeclareVar.\noidValue: \n        Static data value of data type as defined by previous DeclareVar.\n\n$DynamicVar(oidName, ID)\noidName: \n        oidName as defined by previous DeclareVar.\nID: \n        A 0-255 identifier value to uniquely identify this variable.\n\n$SequenceVar(oidName, indexOID)\noidName: \n        oidName as defined by previous DeclareVar.\nindexOID: \n        An oid name as defined by previous DeclareVar that will be index for oidName\n\n$AgentID(oidName, ID)\noidName: \n        oidName as defined by previous DeclareVar. This variable must be of static OID data type.\nID: \n        A 0-255 identifier value to uniquely identify this AgentID. Application must define one and only one AgentID if SNMPNotify() is to be used.Application must pass this ID in SNMPNotify().\n";
    static String VERSION_MESSAGE = "mib2bib";
    static final String help = "Converts Microchip Stack MIB data file into Binary Information Base and generates 'C' definition file.\n\nmib2bib [/?] [/h] [/q] <MIBFile> [/b=<OutputBIBDir>] /i=<OutputIncDir>]\n        /? : Displays this message\n        /h : Displays detailed help for all commands.\n        /q : Quitely overwrites output file \"snmp.bib\"\n        MIBFile: Microchip Stack MIB input data file.\n        /b=<OutputBIBDir> : Output directory where output BIB file should be generated.\n                   If no OutputBIBDir is specified, current directory will be used.\n        /i=<OutputIncDir> : Output directory where Inc file should be generated.\n                   If no OutputIncDir is specified, current directory will be used.\n\nOutput BIB file name is internally set to \"snmp.bib\".\n'C' definition file name is set to \"mib.h\".\nInclude \"snmp.bib\" file in MPFS image and \"mib.h\" in your application file that handles SNMP callbacks.\n\nExamples:  1. mib2bib MySNMP.mib\n              Generates snmp.bib file from MySNMP.mib file.\n\n           2. mib2bib MySNMP.mib /q\n              Overwrites existing snmp.bib file in current directory.\n\n           3. mib2bib MySNMP.mib /b=WebPages /q\n              Overwrites existing snmp.bib file in WebPages directory.\n";
    public PROGRAM_ARGS programArgs = new PROGRAM_ARGS();
    public static ERROR_INFO errorInfo;
    public SnmpCommand snmpParamCommands;
    SnmpCommand.declareVar SnmpDeclareVarCmd;
    SnmpCommand.staticVar SnmpStaticVarCmd;
    SnmpCommand.dynamicVar SnmpDynamicVarCmd;
    SnmpCommand.sequenceVar SnmpSequenceVarCmd;
    SnmpCommand.agentID SnmpAgentIDCmd;
    public static String INPUT_FILE;
    public static String OUTPUT_FILE;
    public static String OUTPUT_INC_FILE;
    public static int lineNumber;
    static String[] CommandList;

    public mib2bib(String[] argc) {
        errorInfo = new ERROR_INFO();
        this.snmpParamCommands = new SnmpCommand(this);
        this.SnmpDeclareVarCmd = this.snmpParamCommands.new SnmpCommand.declareVar();
        this.SnmpStaticVarCmd = this.snmpParamCommands.new SnmpCommand.staticVar();
        this.SnmpSequenceVarCmd = this.snmpParamCommands.new SnmpCommand.sequenceVar();
        this.SnmpDynamicVarCmd = this.snmpParamCommands.new SnmpCommand.dynamicVar();
        this.SnmpAgentIDCmd = this.snmpParamCommands.new SnmpCommand.agentID();
        this.mib2BibStart(argc);
    }

    public PROGRAM_RESULT ProcessArguments(String[] args) {
        File tempFile;
        String pFullPath;
        String mibFilePath = new File(".").getAbsolutePath();
        this.programArgs.bOverwrite = false;
        this.programArgs.bDebug = false;
        this.programArgs.binputFile = false;
        this.programArgs.InputFile = "";
        this.programArgs.binFile = "";
        this.programArgs.incFile = "";
        if (args.length > 0) {
            block11: for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.isEmpty()) continue;
                char ch = arg.charAt(0);
                switch (ch) {
                    case '-': 
                    case '/': {
                        char ch2 = arg.charAt(1);
                        switch (ch2) {
                            case '?': {
                                System.out.println(help);
                                return PROGRAM_RESULT.RESULT_SHOW_HELP;
                            }
                            case 'Q': 
                            case 'q': {
                                this.programArgs.bOverwrite = true;
                                continue block11;
                            }
                            case 'D': 
                            case 'd': {
                                this.programArgs.bDebug = true;
                                continue block11;
                            }
                            case 'H': 
                            case 'h': {
                                System.out.println(commandHelp);
                                return PROGRAM_RESULT.RESULT_EXIT;
                            }
                            case 'I': 
                            case 'i': {
                                String[] tempStr = arg.split("=");
                                if (tempStr.length > 2) {
                                    return PROGRAM_RESULT.RESULT_INVALID_FILE;
                                }
                                this.programArgs.incFile = tempStr[1];
                                File file = new File(this.programArgs.incFile);
                                if (!file.exists()) {
                                    System.out.println("Output Inc directory " + this.programArgs.incFile.toString() + " does not exist.\n");
                                    return PROGRAM_RESULT.RESULT_INVALID_FILE;
                                }
                                this.programArgs.incFile = this.programArgs.incFile + "\\" + OUTPUT_INC_FILE;
                                continue block11;
                            }
                            case 'B': 
                            case 'b': {
                                String[] tempStr = arg.split("=");
                                if (tempStr.length > 2) {
                                    return PROGRAM_RESULT.RESULT_INVALID_FILE;
                                }
                                this.programArgs.binFile = tempStr[1];
                                File file = new File(this.programArgs.binFile);
                                if (!file.exists()) {
                                    System.out.println("Output Bib directory" + this.programArgs.binFile.toString() + " does not exist.\n");
                                    return PROGRAM_RESULT.RESULT_INVALID_FILE;
                                }
                                this.programArgs.binFile = this.programArgs.binFile + "\\" + OUTPUT_FILE;
                                continue block11;
                            }
                        }
                        System.out.println("Unknown option " + arg + " received.\n");
                        return PROGRAM_RESULT.RESULT_EXTRA_ARGS;
                    }
                    default: {
                        if (!this.programArgs.InputFile.isEmpty() && this.programArgs.binputFile) {
                            System.out.println("More than one Input MIB file received.\n");
                            return PROGRAM_RESULT.RESULT_EXTRA_ARGS;
                        }
                        this.programArgs.InputFile = pFullPath = new File(args[i]).getAbsolutePath();
                        this.programArgs.binputFile = true;
                    }
                }
            }
        }
        if (this.programArgs.bDebug) {
            this.PrintErrorMessages();
        }
        if (this.programArgs.InputFile.isEmpty() && args.length == 0) {
            System.out.println("No input MIB file was specified.\n\n");
            System.out.println(help);
            return PROGRAM_RESULT.RESULT_SHOW_HELP;
        }
        if (!this.programArgs.binputFile) {
            this.programArgs.InputFile = args[0];
        }
        if (!(tempFile = new File(this.programArgs.InputFile).getAbsoluteFile()).exists()) {
            System.out.println("Input file " + this.programArgs.InputFile.toString() + " does not exist.\n\n");
            return PROGRAM_RESULT.RESULT_FILE_NOT_FOUND;
        }
        if (this.programArgs.binFile.isEmpty()) {
            this.programArgs.binFile = OUTPUT_FILE;
        }
        if (this.programArgs.incFile.isEmpty()) {
            this.programArgs.incFile = OUTPUT_INC_FILE;
        }
        this.programArgs.InputFile = pFullPath = new File(this.programArgs.InputFile).getAbsoluteFile().toString();
        this.programArgs.binFile = pFullPath = new File(this.programArgs.binFile).getAbsoluteFile().toString();
        this.programArgs.incFile = pFullPath = new File(this.programArgs.incFile).getAbsoluteFile().toString();
        return PROGRAM_RESULT.RESULT_NO_ERROR;
    }

    void PrintErrorMessages() {
        ERROR_INFO errorMsg = new ERROR_INFO();
        errorMsg.printErrorInfo(FILE_ERROR_CODE.UNEXPECTED_EOF);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.UNEXPECTED_EOL);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.INVALID_ESC_SEQUENCE);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.EMPTY_COMMAND_STRING);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.UNEXPECTED_RIGHT_PAR);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.INVALID_COMMAND_INFO);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.UNEXPECTED_ESC_CHAR);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.UNKNOWN_COMMAND);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.DEFINE_INVALID_ARGS);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.DUPLICATE_DEFINE);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.UNKNOWN_DATA_TYPE);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.UNKNOWN_OID_TYPE);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.INVALID_OID_LEN);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.DYNAMIC_OID_INVALID_ARGS);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.OID_NOT_DEFINED);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.INVALID_OID_ID);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.STATIC_OID_INVALID_ARGS);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.SEQUENCE_OID_INVALID_ARGS);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.OID_VALUE_ASSIGNED);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.INVALID_INDEX_COUNT);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.STATIC_SEQUENCE_OID);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.ROOT_NOT_SAME_OR_DUPLICATE);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.INVALID_INDEX_DEFINED);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.UNKNOWN_OID_ACCESS);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.OID_ID_ASSIGNED);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.OID_ID_DUPLICATE);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.NO_OID_STATIC_VALUE);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.NO_OID_INDEX);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.OID_DATA_SCOPE_UNKNOWN);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.INVALID_DATA);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.AGENT_ID_INVALID_ARGS);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.NOT_OID_DATA_TYPE);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.NOT_A_CONSTANT_DATA_TYPE);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.ALREADY_AN_AGENT_ID);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.AGENT_ID_ALREADY_DEFINED);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.OID_WITH_READWRITE_ACCESS);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.DYNAMIC_OID_TYPE);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.ALREADY_DYNAMIC);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.ALREADY_STATIC);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.NOT_AN_INTERNET_ROOT);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.VALUE_TRUNCATED);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.TOO_LONG_STRING);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.INVALID_OID_NAME);
        errorMsg.printErrorInfo(FILE_ERROR_CODE.TOO_MANY_DYNAMIC_OIDS);
    }

    public PARSE_RESULT GetLine(File file, List<String> pParamList, int line, String newLine) {
        char[] tempParam = new char[1024];
        char COMMAND_CHAR = '$';
        int index = 0;
        GetLineState state = GetLineState.SM_NEW_LINE;
        pParamList.clear();
        int paramLen = 0;
        boolean lbEndOfFile = false;
        boolean lbDone = false;
        PARSE_RESULT lenumResult = PARSE_RESULT.PARSE_ERROR;
        for (int i = 0; i < 1024; ++i) {
            tempParam[i] = '\u0000';
        }
        while (!lbEndOfFile && !lbDone) {
            if (newLine == null) {
                lbEndOfFile = true;
            }
            if (index >= newLine.length()) {
                lbDone = true;
                break;
            }
            char c = newLine.charAt(index++);
            switch (state) {
                case SM_NEW_LINE: {
                    if (lbEndOfFile) {
                        lbDone = true;
                        lenumResult = PARSE_RESULT.PARSE_NO_MORE;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    if (c == '\r' || c == '\n') {
                        ++lineNumber;
                        break;
                    }
                    if (c == COMMAND_CHAR) {
                        paramLen = 0;
                        state = GetLineState.SM_COMMAND;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = GetLineState.SM_COMMENT;
                    break;
                }
                case SM_COMMAND: {
                    if (lbEndOfFile) {
                        this.ShowError(file, lineNumber, FILE_ERROR_CODE.UNEXPECTED_EOF);
                        lbDone = true;
                        lenumResult = PARSE_RESULT.PARSE_NO_MORE;
                        break;
                    }
                    if (c == '(') {
                        if (paramLen == 0) {
                            this.ShowError(file, lineNumber, FILE_ERROR_CODE.EMPTY_COMMAND_STRING);
                            lbDone = true;
                            lenumResult = PARSE_RESULT.PARSE_NO_MORE;
                            break;
                        }
                        tempParam[paramLen] = '\u0000';
                        String tempStr = new String(tempParam, 0, paramLen);
                        paramLen = 0;
                        pParamList.add(tempStr);
                        state = GetLineState.SM_ARGS;
                        break;
                    }
                    if (c == ')') {
                        this.ShowError(file, lineNumber, FILE_ERROR_CODE.UNEXPECTED_RIGHT_PAR);
                        lbDone = true;
                        lenumResult = PARSE_RESULT.PARSE_ERROR;
                        break;
                    }
                    if (c == '\\') {
                        this.ShowError(file, lineNumber, FILE_ERROR_CODE.UNEXPECTED_ESC_CHAR);
                        lbDone = true;
                        lenumResult = PARSE_RESULT.PARSE_ERROR;
                        break;
                    }
                    tempParam[paramLen++] = c;
                    break;
                }
                case SM_ARGS: {
                    if (lbEndOfFile) {
                        this.ShowError(file, lineNumber, FILE_ERROR_CODE.UNEXPECTED_EOF);
                        lenumResult = PARSE_RESULT.PARSE_ERROR;
                        lbDone = true;
                        break;
                    }
                    if (paramLen == 0 && (c == ' ' || c == '\t')) break;
                    if (c == '\\') {
                        state = GetLineState.SM_ESCAPE;
                    }
                    if (c == ',') {
                        tempParam[paramLen] = '\u0000';
                        String tempStr = new String(tempParam, 0, paramLen);
                        paramLen = 0;
                        pParamList.add(tempStr);
                        break;
                    }
                    if (c == ')') {
                        tempParam[paramLen] = '\u0000';
                        String tempStr = new String(tempParam, 0, paramLen);
                        paramLen = 0;
                        pParamList.add(tempStr);
                        lbDone = true;
                        if (pParamList.size() > 0) {
                            lenumResult = PARSE_RESULT.PARSE_OK;
                            break;
                        }
                        this.ShowError(file, lineNumber, FILE_ERROR_CODE.INVALID_COMMAND_INFO);
                        lenumResult = PARSE_RESULT.PARSE_ERROR;
                        break;
                    }
                    if (c == '\r' || c == '\n') {
                        this.ShowError(file, lineNumber, FILE_ERROR_CODE.UNEXPECTED_EOL);
                        lbDone = true;
                        lenumResult = PARSE_RESULT.PARSE_ERROR;
                        break;
                    }
                    tempParam[paramLen++] = c;
                    break;
                }
                case SM_ESCAPE: {
                    if (lbEndOfFile) {
                        this.ShowError(file, lineNumber, FILE_ERROR_CODE.UNEXPECTED_EOF);
                        lbDone = true;
                        lenumResult = PARSE_RESULT.PARSE_ERROR;
                        break;
                    }
                    if (c == '\\' || c == ',' || c == ')' || c == '(') {
                        tempParam[paramLen++] = c;
                        state = GetLineState.SM_ARGS;
                        break;
                    }
                    if (c == '\n' || c == '\r') {
                        this.ShowError(file, lineNumber, FILE_ERROR_CODE.UNEXPECTED_EOF);
                        lbDone = true;
                        lenumResult = PARSE_RESULT.PARSE_ERROR;
                        break;
                    }
                    this.ShowError(file, lineNumber, FILE_ERROR_CODE.INVALID_ESC_SEQUENCE);
                    lbDone = true;
                    lenumResult = PARSE_RESULT.PARSE_ERROR;
                    break;
                }
                case SM_COMMENT: {
                    if (lbEndOfFile) {
                        lbDone = true;
                        lenumResult = PARSE_RESULT.PARSE_NO_MORE;
                        break;
                    }
                    if (c != '\r' && c != '\n') break;
                    ++lineNumber;
                    state = GetLineState.SM_NEW_LINE;
                    break;
                }
                case SM_LINE_CONTINUE: {
                    if (lbEndOfFile) {
                        this.ShowError(file, lineNumber, FILE_ERROR_CODE.UNEXPECTED_EOF);
                        lbDone = true;
                        lenumResult = PARSE_RESULT.PARSE_ERROR;
                        break;
                    }
                    if (c != '\r' && c != '\n') break;
                    ++lineNumber;
                    state = GetLineState.SM_ARGS;
                    break;
                }
                case SM_END_OF_COMMAND: {
                    if (lbEndOfFile) {
                        lbDone = true;
                        if (pParamList.size() > 0) {
                            lenumResult = PARSE_RESULT.PARSE_NO_MORE;
                            break;
                        }
                        this.ShowError(file, lineNumber, FILE_ERROR_CODE.INVALID_COMMAND_INFO);
                        lenumResult = PARSE_RESULT.PARSE_ERROR;
                        break;
                    }
                    if (c != '\r' && c != '\n') break;
                    ++lineNumber;
                    state = GetLineState.SM_NEW_LINE;
                    lbDone = true;
                    lenumResult = PARSE_RESULT.PARSE_OK;
                }
            }
        }
        line = lineNumber;
        return lenumResult;
    }

    public boolean ProcessCommand(List pList, File file, int line) {
        int paramCount = pList.size();
        if (paramCount <= 0) {
            this.ShowError(file, line, FILE_ERROR_CODE.INVALID_COMMAND_INFO);
            return false;
        }
        if (pList.get(0).toString().compareTo("DeclareVar") == 0) {
            return this.SnmpDeclareVarCmd.HandleDeclareVar(pList, file, line);
        }
        if (pList.get(0).toString().compareTo("StaticVar") == 0) {
            return this.SnmpStaticVarCmd.HandleStaticVar(pList, file, line);
        }
        if (pList.get(0).toString().compareTo("DynamicVar") == 0) {
            return this.SnmpDynamicVarCmd.HandleDynamicVar(pList, file, line);
        }
        if (pList.get(0).toString().compareTo("SequenceVar") == 0) {
            return this.SnmpSequenceVarCmd.HandleSequenceVar(pList, file, line);
        }
        if (pList.get(0).toString().compareTo("AgentID") == 0) {
            return this.SnmpAgentIDCmd.HandleAgentID(pList, file, line);
        }
        this.ShowError(file, line, FILE_ERROR_CODE.INVALID_COMMAND_INFO);
        return false;
    }

    public int ParseFile(String input) {
        int line = 0;
        PARSE_RESULT parseResult = PARSE_RESULT.PARSE_ERROR;
        int errorCount = 0;
        File hFile = new File(input);
        if (!hFile.exists()) {
            return 0;
        }
        ArrayList<String> pCommandParams = new ArrayList<String>();
        try {
            FileInputStream inputFile = new FileInputStream(hFile);
            DataInputStream in = new DataInputStream(inputFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            do {
                String strLine = br.readLine();
                ++line;
                if (strLine == null) {
                    parseResult = PARSE_RESULT.PARSE_NO_MORE;
                    if (line != 0 || pCommandParams.size() != 0) break;
                    this.ShowError(hFile, lineNumber, FILE_ERROR_CODE.UNEXPECTED_EOF);
                    ++errorCount;
                    break;
                }
                strLine.concat("\r\n");
                if (!strLine.startsWith("$", 0)) continue;
                parseResult = this.GetLine(hFile, pCommandParams, line, strLine);
                if (parseResult == PARSE_RESULT.PARSE_OK) {
                    if (this.programArgs.bDebug) {
                        for (int i = 0; i < pCommandParams.size(); ++i) {
                            System.out.println(((String)pCommandParams.get(i)).toString());
                        }
                        System.out.println("\n");
                    }
                    if (this.ProcessCommand(pCommandParams, hFile, line)) continue;
                    ++errorCount;
                    continue;
                }
                if (parseResult != PARSE_RESULT.PARSE_ERROR) continue;
                ++errorCount;
            } while (parseResult != PARSE_RESULT.PARSE_NO_MORE);
            br.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
        }
        return errorCount;
    }

    void ShowWarning(File file, int line, FILE_ERROR_CODE code) {
        String str = errorInfo.ErrorInfoStr(code);
        if (str != null) {
            System.out.println(file.getName() + line + "Warning [" + (Object)((Object)code) + "]" + str);
        } else {
            System.out.println(file.getName() + line + "Warning [" + (Object)((Object)code) + "] Unknown warning code.\n");
        }
    }

    public void ShowError(File file, int line, FILE_ERROR_CODE code) {
        String str = errorInfo.ErrorInfoStr(code);
        if (str != null) {
            System.out.println(file.getName() + line + "Error [" + (Object)((Object)code) + "]" + str);
        } else {
            System.out.println(file.getName() + line + "Error [" + (Object)((Object)code) + "]Unknown error code.\n ");
        }
    }

    void mib2BibStart(String[] argc) {
        this.programArgs = new PROGRAM_ARGS();
        PROGRAM_RESULT lenmResults = this.ProcessArguments(argc);
        if (lenmResults != PROGRAM_RESULT.RESULT_NO_ERROR) {
            return;
        }
        System.out.println("Input MIB File :" + this.programArgs.InputFile + "\n");
        System.out.println("Output BIB File:" + this.programArgs.binFile + "\n");
        System.out.println("Output Inc File:" + this.programArgs.incFile + "\n");
        System.out.println("\n");
        int liResult = this.ParseFile(this.programArgs.InputFile);
        if (liResult > 0) {
            System.out.println("\nTotal of " + liResult + "error(s) detected.\n");
        }
        if (liResult == 0) {
            liResult = this.snmpParamCommands.ValidateFile(this.programArgs.InputFile);
        }
        if (liResult == 0) {
            this.snmpParamCommands.ProcessFile(this.programArgs.binFile, this.programArgs.incFile, this.programArgs.bOverwrite);
        }
    }

    public static void main(String[] argc) {
        VERSION_INFO = VERSION_INFO + " <Thursday, June 16, 2011>\n";
        VERSION_MESSAGE = VERSION_MESSAGE + VERSION_INFO + "Copyright (c) 2003 Microchip Technology Inc.\n";
        System.out.println(VERSION_MESSAGE);
        new mib2bib(argc);
    }

    static {
        INPUT_FILE = "snmp.mib";
        OUTPUT_FILE = "snmp.bib";
        OUTPUT_INC_FILE = "mib.h";
        lineNumber = 1;
        CommandList = new String[]{"DeclareVar", "DynamicVar", "StaticVar", "SequenceVar", "AgentID"};
    }

    public class ERROR_INFO {
        String[] errorMessages;
        FILE_ERROR_CODE errorCode;

        void printErrorInfo(FILE_ERROR_CODE errorCode) {
            switch (errorCode) {
                case UNEXPECTED_EOF: {
                    System.out.println("Unexpected end-of-file found.");
                    break;
                }
                case UNEXPECTED_EOL: {
                    System.out.println("Unexpected end-of-line found.");
                    break;
                }
                case INVALID_ESC_SEQUENCE: {
                    System.out.println("Invalid escape sequence detected;  Only ',', '\\', '(', or ')' may follow '\\'");
                    break;
                }
                case EMPTY_COMMAND_STRING: {
                    System.out.println("Unexpected empty command string received.");
                    break;
                }
                case UNEXPECTED_RIGHT_PAR: {
                    System.out.println("Unexpected empty command string received.");
                    break;
                }
                case INVALID_COMMAND_INFO: {
                    System.out.println("Invalid or empty command received.");
                    break;
                }
                case UNEXPECTED_ESC_CHAR: {
                    System.out.println("Unexpected escape character received.");
                    break;
                }
                case UNKNOWN_COMMAND: {
                    System.out.println("Unknown command received.");
                    break;
                }
                case DEFINE_INVALID_ARGS: {
                    System.out.println("Invalid parameters: Expected $DeclareVar(oidName, dataType, oidType, access, oid)");
                    break;
                }
                case DUPLICATE_DEFINE: {
                    System.out.println("Duplicate OID name found.");
                    break;
                }
                case UNKNOWN_DATA_TYPE: {
                    System.out.println("Unknown data type received.");
                    break;
                }
                case UNKNOWN_OID_TYPE: {
                    System.out.println("Unknown OID type received.");
                    break;
                }
                case INVALID_OID_LEN: {
                    System.out.println("Empty OID string received.");
                    break;
                }
                case DYNAMIC_OID_INVALID_ARGS: {
                    System.out.println("Invalid parameters: Expected $DynamicVar(oidName, id)");
                    break;
                }
                case OID_NOT_DEFINED: {
                    System.out.println("OID name is not defined.");
                    break;
                }
                case INVALID_OID_ID: {
                    System.out.println("Invalid OID id received - must be between 0-255 inclusive.");
                    break;
                }
                case STATIC_OID_INVALID_ARGS: {
                    System.out.println("Invalid parameters: Expected $StaticVar(oidName, value)");
                    break;
                }
                case SEQUENCE_OID_INVALID_ARGS: {
                    System.out.println("Invalid parameters: Expected $SequenceVar(oidName, index)");
                    break;
                }
                case OID_VALUE_ASSIGNED: {
                    System.out.println("Invalid number of index parameters received.");
                    break;
                }
                case INVALID_INDEX_COUNT: {
                    System.out.println("Current OID already contains a Static value.");
                    break;
                }
                case STATIC_SEQUENCE_OID: {
                    System.out.println("OID of Sequence type cannot contain static data.");
                    break;
                }
                case ROOT_NOT_SAME_OR_DUPLICATE: {
                    System.out.println("This is duplicate OID or Root of this OID is not same as previous OID(s), or this OID is a child of a previously defined OID.");
                    break;
                }
                case INVALID_INDEX_DEFINED: {
                    System.out.println("Invalid index received: Must be BYTE data value.");
                    break;
                }
                case UNKNOWN_OID_ACCESS: {
                    System.out.println("Invalid OID access type received: Must be \"READONLY\" or \"READWRITE\".");
                    break;
                }
                case OID_ID_ASSIGNED: {
                    System.out.println("Current OID is already assigned an ID value.");
                    break;
                }
                case OID_ID_DUPLICATE: {
                    System.out.println("Duplicate dynamic ID found.");
                    break;
                }
                case NO_OID_STATIC_VALUE: {
                    System.out.println("No static value found for this OID.");
                    break;
                }
                case NO_OID_INDEX: {
                    System.out.println("No index value found for this OID.");
                    break;
                }
                case OID_DATA_SCOPE_UNKNOWN: {
                    System.out.println("OID data scope (dynamic/static) is not defined.");
                    break;
                }
                case INVALID_DATA: {
                    System.out.println("Invalid data value found.");
                    break;
                }
                case AGENT_ID_INVALID_ARGS: {
                    System.out.println("Invalid parameters: Expected $AgentID(oidName, id)");
                    break;
                }
                case NOT_OID_DATA_TYPE: {
                    System.out.println("Only OID data type is allowed for this command.");
                    break;
                }
                case NOT_A_CONSTANT_DATA_TYPE: {
                    System.out.println("This OID must contain static OID data.");
                    break;
                }
                case ALREADY_AN_AGENT_ID: {
                    System.out.println("This OID is already declared as an Agent ID.");
                    break;
                }
                case AGENT_ID_ALREADY_DEFINED: {
                    System.out.println("An Agent ID is already assigned.");
                    break;
                }
                case OID_WITH_READWRITE_ACCESS: {
                    System.out.println("OID with READWRITE access cannot be Static.");
                    break;
                }
                case DYNAMIC_OID_TYPE: {
                    System.out.println("OID of OID data type cannot be Dynamic.");
                    break;
                }
                case ALREADY_DYNAMIC: {
                    System.out.println("This OID is already declared as Dynamic.");
                    break;
                }
                case ALREADY_STATIC: {
                    System.out.println("This OID is already declared as Static.");
                    break;
                }
                case NOT_AN_INTERNET_ROOT: {
                    System.out.println("This OID does not contain Internet root. Internet root of '43' must be used if this Internet MIB.");
                    break;
                }
                case VALUE_TRUNCATED: {
                    System.out.println("Given value was truncated to fit in specified data type.");
                    break;
                }
                case TOO_LONG_STRING: {
                    System.out.println("Given string exceeds maximum length of 127.");
                    break;
                }
                case INVALID_OID_NAME: {
                    System.out.println("Invalid OID name detected.  OID Name must follow standard 'C' variable naming convention.");
                    break;
                }
                case TOO_MANY_DYNAMIC_OIDS: {
                    System.out.println("Total number of Dynamic OIDs exceeds 256.\n");
                }
            }
        }

        String ErrorInfoStr(FILE_ERROR_CODE errorCode) {
            switch (errorCode) {
                case UNEXPECTED_EOF: {
                    return "Unexpected end-of-file found.";
                }
                case UNEXPECTED_EOL: {
                    return "Unexpected end-of-line found.";
                }
                case INVALID_ESC_SEQUENCE: {
                    return "Invalid escape sequence detected;  Only ',', '\\', '(', or ')' may follow '\\'";
                }
                case EMPTY_COMMAND_STRING: {
                    return "Unexpected empty command string received.";
                }
                case UNEXPECTED_RIGHT_PAR: {
                    return "Unexpected empty command string received.";
                }
                case INVALID_COMMAND_INFO: {
                    return "Invalid or empty command received.";
                }
                case UNEXPECTED_ESC_CHAR: {
                    return "Unexpected escape character received.";
                }
                case UNKNOWN_COMMAND: {
                    return "Unknown command received.";
                }
                case DEFINE_INVALID_ARGS: {
                    return "Invalid parameters: Expected $DeclareVar(oidName, dataType, oidType, access, oid)";
                }
                case DUPLICATE_DEFINE: {
                    return "Duplicate OID name found.";
                }
                case UNKNOWN_DATA_TYPE: {
                    return "Unknown data type received.";
                }
                case UNKNOWN_OID_TYPE: {
                    return "Unknown OID type received.";
                }
                case INVALID_OID_LEN: {
                    return "Empty OID string received.";
                }
                case DYNAMIC_OID_INVALID_ARGS: {
                    return "Invalid parameters: Expected $DynamicVar(oidName, id)";
                }
                case OID_NOT_DEFINED: {
                    return "OID name is not defined.";
                }
                case INVALID_OID_ID: {
                    return "Invalid OID id received - must be between 0-255 inclusive.";
                }
                case STATIC_OID_INVALID_ARGS: {
                    return "Invalid parameters: Expected $StaticVar(oidName, value)";
                }
                case SEQUENCE_OID_INVALID_ARGS: {
                    return "Invalid parameters: Expected $SequenceVar(oidName, index)";
                }
                case OID_VALUE_ASSIGNED: {
                    return "Invalid number of index parameters received.";
                }
                case INVALID_INDEX_COUNT: {
                    return "Current OID already contains a Static value.";
                }
                case STATIC_SEQUENCE_OID: {
                    return "OID of Sequence type cannot contain static data.";
                }
                case ROOT_NOT_SAME_OR_DUPLICATE: {
                    return "This is duplicate OID or Root of this OID is not same as previous OID(s), or this OID is a child of a previously defined OID.";
                }
                case INVALID_INDEX_DEFINED: {
                    return "Invalid index received: Must be BYTE data value.";
                }
                case UNKNOWN_OID_ACCESS: {
                    return "Invalid OID access type received: Must be \"READONLY\" or \"READWRITE\".";
                }
                case OID_ID_ASSIGNED: {
                    return "Current OID is already assigned an ID value.";
                }
                case OID_ID_DUPLICATE: {
                    return "Duplicate dynamic ID found.";
                }
                case NO_OID_STATIC_VALUE: {
                    return "No static value found for this OID.";
                }
                case NO_OID_INDEX: {
                    return "No index value found for this OID.";
                }
                case OID_DATA_SCOPE_UNKNOWN: {
                    return "OID data scope (dynamic/static) is not defined.";
                }
                case INVALID_DATA: {
                    return "Invalid data value found.";
                }
                case AGENT_ID_INVALID_ARGS: {
                    return "Invalid parameters: Expected $AgentID(oidName, id)";
                }
                case NOT_OID_DATA_TYPE: {
                    return "Only OID data type is allowed for this command.";
                }
                case NOT_A_CONSTANT_DATA_TYPE: {
                    return "This OID must contain static OID data.";
                }
                case ALREADY_AN_AGENT_ID: {
                    return "This OID is already declared as an Agent ID.";
                }
                case AGENT_ID_ALREADY_DEFINED: {
                    return "An Agent ID is already assigned.";
                }
                case OID_WITH_READWRITE_ACCESS: {
                    return "OID with READWRITE access cannot be Static.";
                }
                case DYNAMIC_OID_TYPE: {
                    return "OID of OID data type cannot be Dynamic.";
                }
                case ALREADY_DYNAMIC: {
                    return "This OID is already declared as Dynamic.";
                }
                case ALREADY_STATIC: {
                    return "This OID is already declared as Static.";
                }
                case NOT_AN_INTERNET_ROOT: {
                    return "This OID does not contain Internet root. Internet root of '43' must be used if this Internet MIB.";
                }
                case VALUE_TRUNCATED: {
                    return "Given value was truncated to fit in specified data type.";
                }
                case TOO_LONG_STRING: {
                    return "Given string exceeds maximum length of 127.";
                }
                case INVALID_OID_NAME: {
                    return "Invalid OID name detected.  OID Name must follow standard 'C' variable naming convention.";
                }
                case TOO_MANY_DYNAMIC_OIDS: {
                    return "Total number of Dynamic OIDs exceeds 256.\n";
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FILE_ERROR_CODE {
        UNEXPECTED_EOF,
        UNEXPECTED_EOL,
        INVALID_ESC_SEQUENCE,
        EMPTY_COMMAND_STRING,
        UNEXPECTED_RIGHT_PAR,
        INVALID_COMMAND_INFO,
        UNEXPECTED_ESC_CHAR,
        UNKNOWN_COMMAND,
        DEFINE_INVALID_ARGS,
        DUPLICATE_DEFINE,
        UNKNOWN_DATA_TYPE,
        UNKNOWN_OID_TYPE,
        INVALID_OID_LEN,
        DYNAMIC_OID_INVALID_ARGS,
        OID_NOT_DEFINED,
        INVALID_OID_ID,
        STATIC_OID_INVALID_ARGS,
        SEQUENCE_OID_INVALID_ARGS,
        OID_VALUE_ASSIGNED,
        INVALID_INDEX_COUNT,
        STATIC_SEQUENCE_OID,
        ROOT_NOT_SAME_OR_DUPLICATE,
        INVALID_INDEX_DEFINED,
        UNKNOWN_OID_ACCESS,
        OID_ID_ASSIGNED,
        OID_ID_DUPLICATE,
        NO_OID_STATIC_VALUE,
        NO_OID_INDEX,
        OID_DATA_SCOPE_UNKNOWN,
        INVALID_DATA,
        AGENT_ID_INVALID_ARGS,
        NOT_OID_DATA_TYPE,
        NOT_A_CONSTANT_DATA_TYPE,
        ALREADY_AN_AGENT_ID,
        AGENT_ID_ALREADY_DEFINED,
        OID_WITH_READWRITE_ACCESS,
        DYNAMIC_OID_TYPE,
        ALREADY_DYNAMIC,
        ALREADY_STATIC,
        NOT_AN_INTERNET_ROOT,
        VALUE_TRUNCATED,
        TOO_LONG_STRING,
        INVALID_OID_NAME,
        TOO_MANY_DYNAMIC_OIDS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum GetLineState {
        SM_COMMAND,
        SM_COMMENT,
        SM_NEW_LINE,
        SM_ARGS,
        SM_ESCAPE,
        SM_LINE_CONTINUE,
        SM_END_OF_COMMAND;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PARSE_RESULT {
        PARSE_OK,
        PARSE_NO_MORE,
        PARSE_ERROR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PROGRAM_RESULT {
        RESULT_NO_ERROR,
        RESULT_EXIT,
        RESULT_INSUFFICIENT_ARGS,
        RESULT_EXTRA_ARGS,
        RESULT_SHOW_HELP,
        RESULT_FILE_NOT_FOUND,
        RESULT_INVALID_FILE,
        RESULT_INPUT_ERROR,
        RESULT_OUTPUT_ERROR;

    }

    public class PROGRAM_ARGS {
        boolean bDebug;
        boolean bOverwrite;
        boolean binputFile;
        String InputFile;
        String binFile;
        String incFile;
    }
}

