/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : stm32f10x_wwdg.h
* Author             : MCD Application Team
* Date First Issued  : 09/29/2006
* Description        : This file contains all the functions prototypes for the
*                      WWDG firmware library.
********************************************************************************
* History:
* 04/02/2007: V0.2
* 02/05/2007: V0.1
* 09/29/2006: V0.01
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __STM32F10x_WWDG_H
#define __STM32F10x_WWDG_H

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_map.h"

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* WWDG Prescaler */
#define WWDG_Prescaler_1    ((u32)0x00000000)
#define WWDG_Prescaler_2    ((u32)0x00000080)
#define WWDG_Prescaler_4    ((u32)0x00000100)
#define WWDG_Prescaler_8    ((u32)0x00000180)

#define IS_WWDG_PRESCALER(PRESCALER) ((PRESCALER == WWDG_Prescaler_1) || \
                                      (PRESCALER == WWDG_Prescaler_2) || \
                                      (PRESCALER == WWDG_Prescaler_4) || \
                                      (PRESCALER == WWDG_Prescaler_8))

#define IS_WWDG_WINDOW_VALUE(VALUE) (VALUE <= 0x7F)

#define IS_WWDG_COUNTER(COUNTER) ((COUNTER >= 0x40) && (COUNTER <= 0x7F))

/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */
void WWDG_DeInit(void);
void WWDG_SetPrescaler(u32 WWDG_Prescaler);
void WWDG_SetWindowValue(u8 WindowValue);
void WWDG_EnableIT(void);
void WWDG_SetCounter(u8 Counter);
void WWDG_Enable(u8 Counter);
FlagStatus WWDG_GetFlagStatus(void);
void WWDG_ClearFlag(void);

#endif /* __STM32F10x_WWDG_H */

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/
