/*							*/
/*	D-STAR room client Program               	*/
/*      	    V00.05  09/29/2011                  */
/*  				Satoshi Yasuda		*/
/*				7m3tjz/ad6gz		*/
/*                              	                */


#include "FreeRTOS.h"
#include "queue.h"
#include "lcd.h"
#include "../USB/usb_host_local.h"
#include "node.h"

int	usb_control_msg (USB_DEVICE_INFO usbDeviceInfo, BYTE bmRequestType, int request, int Value, int Index, char *data, int Length, int timeout);
void	RF_CallsignPrint (unsigned char header[]);

void	read_from_rig(USB_DEVICE_INFO usbDeviceInfo) 	/* read from rig (DV packet) */
{
	unsigned char buffer[41];
	int	ret;

	/***  from RIG  ***/

    ret = usb_control_msg(usbDeviceInfo, 0xC0, GET_HEADER, 0, 0, buffer, 32, 100);
	ret = usb_control_msg(usbDeviceInfo, 0xC0, GET_HEADER, 0, 0, &buffer[32], 9, 100);

	RF_CallsignPrint (buffer);

	return;
}

void	RF_CallsignPrint (unsigned char header[])
{
	xLCDMessage xMessage;
	extern xQueueHandle xLCDQueue;
	int	i;

	for ( i = 0 ; i < 8 ; i++)
	{
		LCDText[i] = header[i+27];
		LCDText[i+8] = header[i+19];
	}
		xMessage.pcMessage = LCDText;
 		xMessage.xMinDisplayTime = 1000 / portTICK_RATE_MS;
		xQueueSend( xLCDQueue, &xMessage, 0 );
	return;
}
