package tamanegisoul.pl.picasa;

import tamanegisoul.pl.AppContext;
import tamanegisoul.pl.AppUtils;
import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.os.Bundle;
import android.util.Log;

/**
 * アカウント管理クラス。
 * @author tamanegisoul
 */
public class AppAccountManager implements AccountManagerCallback<Bundle> {

    public static final AppAccountManager sInstance = new AppAccountManager();

    private AccountManager mAccountManager;
    private Account mCurrentAccount;
    private GetAuthTokenCallback mCallback;
    private boolean mIsAuthTokenInvalidated;

    private AppAccountManager() {
        super();
        mAccountManager = AccountManager.get(AppContext.instance.getContext());
    }

    /**
     * googleアカウントを取得する。
     * @param accountName アカウント名（xxx@gmail.com）
     * @return googleアカウント
     */
    public Account getAccount(String accountName) {
        for (Account item : mAccountManager.getAccountsByType("com.google")) {
            if (item.name.equals(accountName)) {
                return item;
            }
        }
        return null;
    }

    /**
     * Picasaの認証トークンを取得する。
     * @param account アカウント
     * @param callback トークン取得後のコールバック
     */
    public void getAuthToken(Account account, GetAuthTokenCallback callback) {
        mCurrentAccount = account;
        this.mCallback = callback;
        getAuthToken();
    }
    
    private void getAuthToken() {
        mAccountManager.getAuthToken(mCurrentAccount, "lh2", true, this, null);
    }

    @Override
    public void run(AccountManagerFuture<Bundle> result) {
        try {
            String authToken = result.getResult().getString(AccountManager.KEY_AUTHTOKEN);
            AppUtils.d(getClass(), authToken);
            if(mIsAuthTokenInvalidated){
                mIsAuthTokenInvalidated = false;
                mCallback.gotToken(authToken);
            }else{
                // 一旦キャッシュを無効化して再取得する（本当は有効期限切れたら再取得、が良いのだが…）
                mIsAuthTokenInvalidated = true;
                mAccountManager.invalidateAuthToken("com.google", authToken);
                getAuthToken();
            }
        } catch (Exception e) {
            // TODO: handle exception
            Log.e(AppContext.NAME, "", e);
            throw new RuntimeException(e);
        }
    }
}
