package tamanegisoul.pl.action;

import java.util.ArrayList;

import tamanegisoul.pl.AppContext;
import tamanegisoul.pl.AppPreferences;
import tamanegisoul.pl.R;
import tamanegisoul.pl.R.id;
import tamanegisoul.pl.R.layout;
import tamanegisoul.pl.R.string;
import tamanegisoul.pl.picasa.AppAccountManager;
import tamanegisoul.pl.picasa.Picasa;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.View.OnClickListener;
import android.view.View.OnTouchListener;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

public class MainActivity extends Activity implements OnTouchListener, OnClickListener {

    private static final int MENU_PREFERENCES = Menu.FIRST + 1;
    private static final int MENU_DEBUG = Menu.FIRST + 99;

    private String account;
    private String authToken;
    private ArrayList<Object[]> albumList;
    private Boolean isAuthTokenInvalidated = false;

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable("account", account);
        outState.putSerializable("authToken", authToken);
        outState.putSerializable("albumList", albumList);
        outState.putSerializable("isAuthTokenInvalidated", isAuthTokenInvalidated);
    }

    @SuppressWarnings("unchecked")
    @Override
    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        account = savedInstanceState.getString("account");
        authToken = savedInstanceState.getString("authToken");
        albumList = (ArrayList<Object[]>) savedInstanceState.getSerializable("albumList");
        isAuthTokenInvalidated = savedInstanceState.getBoolean("isAuthTokenInvalidated");
    }

    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        Log.d(AppContext.NAME, "Main.onCreate");
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null)
            AppContext.instance.init(getApplicationContext());
        setContentView(R.layout.main);
        ((Button)findViewById(R.id.cache_button)).setOnClickListener(this);
    }

    @Override
    public void onResume() {
        super.onResume();
        final String account = AppPreferences.instance.getString(AppPreferences.KEY_ACCOUNT);
        if(account == null) {
            startActivity(new Intent(this.getApplicationContext(), AppPreferenceActivity.class));
        } else if(!Picasa.isInitiated()){
            final ProgressDialog mProgressDialog = new ProgressDialog(this);
            mProgressDialog.setMessage(getResources().getText(R.string.progress_login));
            mProgressDialog.setCancelable(false);
            mProgressDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
            mProgressDialog.show();
            new Thread(new Runnable() {
                @Override
                public void run() {
                    Picasa.init(AppAccountManager.sInstance.getAccount(account));
                    while(true){
                        if(Picasa.isInitiated()) {
                            try {
                                Thread.sleep(100);
                            } catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        break;
                    }
                    mProgressDialog.dismiss();
                }
            }).start();
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuItem menuItem = menu.add(Menu.NONE, MENU_PREFERENCES, Menu.NONE, R.string.menu_preferences);
        menuItem.setIcon(android.R.drawable.ic_menu_preferences);
        menu.add(Menu.NONE, MENU_DEBUG, Menu.NONE, R.string.menu_debug);
        return super.onCreateOptionsMenu(menu);
    }

    @Override
    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        switch (item.getItemId()) {
        case MENU_PREFERENCES:
            startActivity(new Intent(this.getApplicationContext(), AppPreferenceActivity.class));
            break;
        case MENU_DEBUG:
            startActivity(new Intent(this.getApplicationContext(), DebugActivity.class));
            break;
        default:
            break;
        }
        return super.onMenuItemSelected(featureId, item);
    }

    private void createView() {
        ViewGroup vv = (ViewGroup) findViewById(R.id.scroll);
        vv.removeAllViews();
        for (Object[] s : albumList) {
            View v = this.getLayoutInflater().inflate(R.layout.album_list_item, null);
            vv.addView(v);
            TextView tv = (TextView) v.findViewById(R.id.accounts);
            tv.setText(s[0] + "/" + s[1]);
            ImageView iv = (ImageView) v.findViewById(R.id.albumImage);
            iv.setImageBitmap((Bitmap) s[2]);
            iv.invalidate();
        }

    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        Log.e("hoge", String.valueOf(event.getAction()));
        if (event.getAction() == MotionEvent.ACTION_MOVE) {
            Log.e("hoge", String.valueOf(event.getX()));
        }
        return false;
    }

    @Override
    public void onClick(View v) {
        if(v.getId() == R.id.cache_button){
            startActivity(new Intent(this, SynchronizeActivity.class));
        }
    }
}