package tamanegisoul.pl.action;

import tamanegisoul.pl.AppContext;
import tamanegisoul.pl.R;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;

public class DebugActivity extends Activity implements OnClickListener {
	
	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		Log.d(AppContext.NAME, "DebugActivity.onCreate");
		super.onCreate(savedInstanceState);
		setContentView(R.layout.debug);

		((Button)findViewById(R.id.pictviewbutton)).setOnClickListener(this);
		((Button)findViewById(R.id.synchronizebutton)).setOnClickListener(this);
	}
	
	@Override
	public void onResume() {
		Log.d(AppContext.NAME, "DebugActivity.onResume");
		super.onResume();
	}

	@Override
	public void onClick(View v) {
		switch (v.getId()) {
		case R.id.pictviewbutton:
			Log.d(AppContext.NAME, "DebugActivity: pictview clicked.");
			startActivity(new Intent(this.getApplicationContext(), PictViewerActivity.class));
			break;
		case R.id.synchronizebutton:
			Log.d(AppContext.NAME, "DebugActivity: synchronize clicked.");
			startActivity(new Intent(this.getApplicationContext(), SynchronizeActivity.class));
			break;
		default:
			break;
		}
	}
}