/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class InQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = -5801329450358952434L;
    private ValueExp val;
    private ValueExp[] valueList;

    public InQueryExp() {
    }

    public InQueryExp(ValueExp valueExp, ValueExp[] valueExpArray) {
        this.val = valueExp;
        this.valueList = valueExpArray;
    }

    public ValueExp getCheckedValue() {
        return this.val;
    }

    public ValueExp[] getExplicitValues() {
        return this.valueList;
    }

    public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        if (this.valueList != null) {
            ValueExp valueExp = this.val.apply(objectName);
            boolean bl = valueExp instanceof NumericValueExp;
            for (int i = 0; i < this.valueList.length; ++i) {
                if (!(bl ? ((NumericValueExp)this.valueList[i]).doubleValue() == ((NumericValueExp)valueExp).doubleValue() : ((StringValueExp)this.valueList[i]).getValue().equals(((StringValueExp)valueExp).getValue()))) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.val + " in (" + this.generateValueList() + ")";
    }

    private String generateValueList() {
        if (this.valueList == null || this.valueList.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(this.valueList[0].toString());
        for (int i = 1; i < this.valueList.length; ++i) {
            stringBuffer.append(", ");
            stringBuffer.append(this.valueList[i]);
        }
        return stringBuffer.toString();
    }
}

