/*
 * Decompiled with CFR 0.152.
 */
package ch.ntb.usb;

import ch.ntb.usb.Device;
import ch.ntb.usb.logger.LogUtil;
import java.util.LinkedList;
import java.util.logging.Logger;

public class USB {
    public static final int REQ_GET_STATUS = 0;
    public static final int REQ_CLEAR_FEATURE = 1;
    public static final int REQ_SET_FEATURE = 3;
    public static final int REQ_SET_ADDRESS = 5;
    public static final int REQ_GET_DESCRIPTOR = 6;
    public static final int REQ_SET_DESCRIPTOR = 7;
    public static final int REQ_GET_CONFIGURATION = 8;
    public static final int REQ_SET_CONFIGURATION = 9;
    public static final int REQ_GET_INTERFACE = 10;
    public static final int REQ_SET_INTERFACE = 11;
    public static final int REQ_SYNCH_FRAME = 12;
    public static final int REQ_TYPE_DIR_HOST_TO_DEVICE = 0;
    public static final int REQ_TYPE_DIR_DEVICE_TO_HOST = 128;
    public static final int REQ_TYPE_TYPE_STANDARD = 0;
    public static final int REQ_TYPE_TYPE_CLASS = 32;
    public static final int REQ_TYPE_TYPE_VENDOR = 64;
    public static final int REQ_TYPE_TYPE_RESERVED = 96;
    public static final int REQ_TYPE_RECIP_DEVICE = 0;
    public static final int REQ_TYPE_RECIP_INTERFACE = 1;
    public static final int REQ_TYPE_RECIP_ENDPOINT = 2;
    public static final int REQ_TYPE_RECIP_OTHER = 3;
    public static int HIGHSPEED_MAX_BULK_PACKET_SIZE = 512;
    public static int FULLSPEED_MAX_BULK_PACKET_SIZE = 64;
    private static final Logger logger = LogUtil.getLogger("ch.ntb.usb");
    private static LinkedList<Device> devices = new LinkedList();

    public static Device getDevice(short idVendor, short idProduct) {
        Device dev = USB.getRegisteredDevice(idVendor, idProduct);
        if (dev != null) {
            logger.info("return already registered device");
            return dev;
        }
        dev = new Device(idVendor, idProduct);
        logger.info("create new device");
        devices.add(dev);
        return dev;
    }

    private static Device getRegisteredDevice(short idVendor, short idProduct) {
        for (Device dev : devices) {
            if (dev.getIdVendor() != idVendor || dev.getIdProduct() != idProduct) continue;
            return dev;
        }
        return null;
    }
}

