/*
 * Decompiled with CFR 0.152.
 */
package ch.ntb.usb.logger;

import java.io.InputStream;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LogUtil {
    private static final boolean debugLogUtil = false;
    private static final String PLUGIN_ID = "ch.ntb.usb";
    private static final String PROPERTIES_FILE = ".configure";
    private static final String LOGGER_WARNING = "Warning in class " + LogUtil.class.getName() + ": could not load the logger properties file " + ".configure";
    private static boolean debugEnabled;

    private static void debugMsg(String method, String message) {
    }

    public static void setLevel(Logger logger, Level loglevel) {
        Handler[] h = logger.getHandlers();
        for (int i = 0; i < h.length; ++i) {
            System.out.println("setLevel " + loglevel.toString());
            h[i].setLevel(loglevel);
        }
        logger.setLevel(loglevel);
    }

    public static Logger getLogger(String name) {
        LogUtil.debugMsg("getLogger", name);
        LogManager manager = LogManager.getLogManager();
        Logger logger = manager.getLogger(name);
        if (logger == null) {
            logger = Logger.getLogger(name);
            LogUtil.setLevel(logger, Level.OFF);
            manager.addLogger(logger);
            LogUtil.debugMsg("getLogger", "creating new logger");
        }
        if (logger.getLevel() == null) {
            LogUtil.debugMsg("getLogger", "level == null -> setLevel to OFF ");
            LogUtil.setLevel(logger, Level.OFF);
        }
        LogUtil.debugMsg("getLogger", "logLevel " + logger.getLevel().getName());
        return logger;
    }

    private static void initLevel(Logger logger, Level loglevel) {
        Handler[] h = logger.getHandlers();
        for (int i = 0; i < h.length; ++i) {
            logger.removeHandler(h[i]);
        }
        ConsoleHandler console = new ConsoleHandler();
        console.setLevel(loglevel);
        logger.addHandler(console);
        logger.setLevel(loglevel);
        logger.setUseParentHandlers(false);
    }

    private static void createLoggersFromProperties() {
        try {
            LogUtil.debugMsg(LogUtil.class.getName(), "createLoggersFromProperties");
            InputStream is = LogUtil.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE);
            if (is == null) {
                System.err.println(LOGGER_WARNING);
            } else {
                Properties prop = new Properties();
                prop.load(is);
                LogUtil.debugMsg("createLoggersFromProperties", "properties file loaded: .configure");
                LogUtil.debugMsg("createLoggersFromProperties", "file content:\n" + prop.toString());
                debugEnabled = Boolean.parseBoolean(prop.getProperty("ch.ntb.usb/debug"));
                LogUtil.debugMsg("createLoggersFromProperties", "debuging enabled: " + debugEnabled);
                boolean moreLoggers = true;
                int loggerCount = 0;
                while (moreLoggers) {
                    String loggerProp = prop.getProperty("ch.ntb.usb/debug/logger" + loggerCount);
                    ++loggerCount;
                    if (loggerProp != null) {
                        int slashIndex = loggerProp.indexOf(47);
                        String loggerName = loggerProp.substring(0, slashIndex).trim();
                        String logLevel = loggerProp.substring(slashIndex + 1, loggerProp.length());
                        Level level = debugEnabled ? Level.parse(logLevel) : Level.OFF;
                        Logger logger = LogUtil.getLogger(loggerName);
                        LogUtil.initLevel(logger, level);
                        LogUtil.debugMsg("createLoggersFromProperties", "create logger " + loggerName + " with level " + level.toString());
                        continue;
                    }
                    moreLoggers = false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        LogUtil.createLoggersFromProperties();
    }
}

