/*
 * Decompiled with CFR 0.152.
 */
package ch.ntb.usb.testApp;

import ch.ntb.usb.testApp.AbstractDeviceInfo;
import ch.ntb.usb.testApp.TestDevice;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class TestApp
extends JFrame {
    private static final long serialVersionUID = 994508729204158681L;
    TestDevice dev;
    private JPanel rootPanel = null;
    private JPanel sendReceivePanel = null;
    private JPanel settingsPanel = null;
    private JButton openDeviceButton = null;
    private JButton closeDevice = null;
    private JButton resetButton = null;
    private JPanel settingsPanelTop = null;
    private JPanel settingsPanelBottom = null;
    JTextField vendorIDText = null;
    JTextField productIDText = null;
    private JPanel vendorIDPanel = null;
    private JPanel productIDPanel = null;
    private JPanel configurationPanel = null;
    JTextField configurationText = null;
    private JPanel interfacePanel = null;
    JTextField interfaceText = null;
    private JPanel altInterfacePanel = null;
    JTextField altInterfaceText = null;
    private JPanel settingsPanelTop2Left = null;
    private JPanel settingsPanelTop2Right = null;
    private JPanel outEpPanel = null;
    JTextField outEpText = null;
    private JPanel inEpPanel = null;
    JTextField inEpText = null;
    private JPanel timeoutPanel = null;
    private JTextField timeoutText = null;
    private JPanel sendDataPanel = null;
    private JPanel sendRecButtonsPanel = null;
    private JButton sendButton = null;
    private JButton recButton = null;
    JTextField sendDataText = null;
    JComboBox sendTypeComboBox = null;
    private JComboBox recTypeComboBox = null;
    private JPanel sendRecButtonsPanelTop = null;
    private JPanel sendRecButtonsPanelBottom = null;

    public TestApp(TestDevice devInfo) {
        this.dev = devInfo;
        this.initialize();
    }

    private void initialize() {
        this.setTitle("USB Test Application");
        this.setContentPane(this.getRootPanel());
        this.vendorIDText.setText(TestApp.toHexString(this.dev.getIdVendor() & 0xFFFF));
        this.productIDText.setText(TestApp.toHexString(this.dev.getIdProduct() & 0xFFFF));
        this.configurationText.setText(new Integer(this.dev.getConfiguration()).toString());
        this.interfaceText.setText(new Integer(this.dev.getInterface()).toString());
        this.altInterfaceText.setText(new Integer(this.dev.getAltinterface()).toString());
        this.timeoutText.setText(new Integer(this.dev.getTimeout()).toString());
        this.sendDataText.setText(this.dev.getSendData());
        this.setOutEpAddr();
        this.setInEpAddr();
        this.pack();
        this.setVisible(true);
    }

    void setOutEpAddr() {
        switch (this.dev.getOutMode()) {
            case Bulk: {
                this.outEpText.setText(TestApp.toHexString(this.dev.getOutEPBulk()));
                break;
            }
            case Interrupt: {
                this.outEpText.setText(TestApp.toHexString(this.dev.getOutEPInt()));
                break;
            }
        }
    }

    void setInEpAddr() {
        switch (this.dev.getInMode()) {
            case Bulk: {
                this.inEpText.setText(TestApp.toHexString(this.dev.getInEPBulk()));
                break;
            }
            case Interrupt: {
                this.inEpText.setText(TestApp.toHexString(this.dev.getInEPInt()));
                break;
            }
        }
    }

    private JPanel getRootPanel() {
        if (this.rootPanel == null) {
            this.rootPanel = new JPanel();
            this.rootPanel.setLayout(new BoxLayout(this.getRootPanel(), 1));
            this.rootPanel.add((Component)this.getSettingsPanel(), null);
            this.rootPanel.add((Component)this.getSendReceivePanel(), null);
        }
        return this.rootPanel;
    }

    private JPanel getSendReceivePanel() {
        if (this.sendReceivePanel == null) {
            BorderLayout borderLayout2 = new BorderLayout();
            borderLayout2.setHgap(5);
            this.sendReceivePanel = new JPanel();
            this.sendReceivePanel.setLayout(borderLayout2);
            this.sendReceivePanel.setBorder(BorderFactory.createTitledBorder(null, "Send and Receive Data", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.sendReceivePanel.add((Component)this.getSendRecButtonsPanel(), "North");
            this.sendReceivePanel.add((Component)this.getSendDataPanel(), "South");
        }
        return this.sendReceivePanel;
    }

    private JPanel getSettingsPanel() {
        if (this.settingsPanel == null) {
            this.settingsPanel = new JPanel();
            this.settingsPanel.setLayout(new BoxLayout(this.getSettingsPanel(), 1));
            this.settingsPanel.setBorder(BorderFactory.createTitledBorder(null, "Device Settings", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.settingsPanel.add((Component)this.getSettingsPanelTop(), null);
            this.settingsPanel.add((Component)this.getSettingsPanelBottom(), null);
        }
        return this.settingsPanel;
    }

    private JButton getOpenDeviceButton() {
        if (this.openDeviceButton == null) {
            this.openDeviceButton = new JButton();
            this.openDeviceButton.setText("Open Device");
            this.openDeviceButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TestApp.this.dev.setIdVendor((short)TestApp.this.parseInt(TestApp.this.vendorIDText.getText().trim()));
                    TestApp.this.dev.setIdProduct((short)TestApp.this.parseInt(TestApp.this.productIDText.getText().trim()));
                    TestApp.this.dev.setConfiguration(TestApp.this.parseInt(TestApp.this.configurationText.getText().trim()));
                    TestApp.this.dev.setInterface(TestApp.this.parseInt(TestApp.this.interfaceText.getText().trim()));
                    TestApp.this.dev.setAltinterface(TestApp.this.parseInt(TestApp.this.altInterfaceText.getText().trim()));
                    TestApp.this.dev.openUsbDevice();
                }
            });
        }
        return this.openDeviceButton;
    }

    private JButton getCloseDevice() {
        if (this.closeDevice == null) {
            this.closeDevice = new JButton();
            this.closeDevice.setText("Close Device");
            this.closeDevice.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TestApp.this.dev.closeUsbDevice();
                }
            });
        }
        return this.closeDevice;
    }

    private JButton getResetButton() {
        if (this.resetButton == null) {
            this.resetButton = new JButton();
            this.resetButton.setText("Reset Device");
            this.resetButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TestApp.this.dev.resetUsbDevice();
                }
            });
        }
        return this.resetButton;
    }

    private JPanel getSettingsPanelTop() {
        if (this.settingsPanelTop == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setVgap(1);
            flowLayout.setAlignment(0);
            this.settingsPanelTop = new JPanel();
            this.settingsPanelTop.setLayout(flowLayout);
            this.settingsPanelTop.add((Component)this.getVendorIDPanel(), null);
            this.settingsPanelTop.add((Component)this.getProductIDPanel(), null);
            this.settingsPanelTop.add((Component)this.getConfigurationPanel(), null);
            this.settingsPanelTop.add((Component)this.getInterfacePanel(), null);
            this.settingsPanelTop.add((Component)this.getAltInterfacePanel(), null);
        }
        return this.settingsPanelTop;
    }

    private JPanel getSettingsPanelBottom() {
        if (this.settingsPanelBottom == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            flowLayout1.setVgap(1);
            flowLayout1.setHgap(0);
            flowLayout1.setAlignment(0);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = -1;
            gridBagConstraints1.gridy = -1;
            this.settingsPanelBottom = new JPanel();
            this.settingsPanelBottom.setLayout(flowLayout1);
            this.settingsPanelBottom.add((Component)this.getSettingsPanelTop2Left(), null);
            this.settingsPanelBottom.add((Component)this.getSettingsPanelTop2Right(), null);
        }
        return this.settingsPanelBottom;
    }

    private JTextField getVendorIDText() {
        if (this.vendorIDText == null) {
            this.vendorIDText = new JTextField();
            this.vendorIDText.setPreferredSize(new Dimension(100, 20));
        }
        return this.vendorIDText;
    }

    private JTextField getProductIDText() {
        if (this.productIDText == null) {
            this.productIDText = new JTextField();
            this.productIDText.setPreferredSize(new Dimension(100, 20));
        }
        return this.productIDText;
    }

    private JPanel getVendorIDPanel() {
        if (this.vendorIDPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 3;
            gridBagConstraints3.gridy = -1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.gridx = -1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = -1;
            gridBagConstraints5.gridy = -1;
            this.vendorIDPanel = new JPanel();
            this.vendorIDPanel.setBorder(BorderFactory.createTitledBorder(null, "VendorID", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.vendorIDPanel.setLayout(new BoxLayout(this.getVendorIDPanel(), 0));
            this.vendorIDPanel.add((Component)this.getVendorIDText(), null);
        }
        return this.vendorIDPanel;
    }

    private JPanel getProductIDPanel() {
        if (this.productIDPanel == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 3;
            gridBagConstraints4.gridy = -1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridx = -1;
            this.productIDPanel = new JPanel();
            this.productIDPanel.setBorder(BorderFactory.createTitledBorder(null, "ProductID", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.productIDPanel.setLayout(new BoxLayout(this.getProductIDPanel(), 0));
            this.productIDPanel.add((Component)this.getProductIDText(), null);
        }
        return this.productIDPanel;
    }

    private JPanel getConfigurationPanel() {
        if (this.configurationPanel == null) {
            this.configurationPanel = new JPanel();
            this.configurationPanel.setLayout(new BoxLayout(this.getConfigurationPanel(), 0));
            this.configurationPanel.setBorder(BorderFactory.createTitledBorder(null, "Configuration", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.configurationPanel.add((Component)this.getConfigurationText(), null);
        }
        return this.configurationPanel;
    }

    private JTextField getConfigurationText() {
        if (this.configurationText == null) {
            this.configurationText = new JTextField();
            this.configurationText.setPreferredSize(new Dimension(100, 20));
        }
        return this.configurationText;
    }

    private JPanel getInterfacePanel() {
        if (this.interfacePanel == null) {
            this.interfacePanel = new JPanel();
            this.interfacePanel.setLayout(new BoxLayout(this.getInterfacePanel(), 0));
            this.interfacePanel.setBorder(BorderFactory.createTitledBorder(null, "Interface", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.interfacePanel.add((Component)this.getInterfaceText(), null);
        }
        return this.interfacePanel;
    }

    private JTextField getInterfaceText() {
        if (this.interfaceText == null) {
            this.interfaceText = new JTextField();
            this.interfaceText.setPreferredSize(new Dimension(100, 20));
        }
        return this.interfaceText;
    }

    private JPanel getAltInterfacePanel() {
        if (this.altInterfacePanel == null) {
            this.altInterfacePanel = new JPanel();
            this.altInterfacePanel.setLayout(new BoxLayout(this.getAltInterfacePanel(), 0));
            this.altInterfacePanel.setBorder(BorderFactory.createTitledBorder(null, "Alternate Int", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.altInterfacePanel.add((Component)this.getAltInterfaceText(), null);
        }
        return this.altInterfacePanel;
    }

    private JTextField getAltInterfaceText() {
        if (this.altInterfaceText == null) {
            this.altInterfaceText = new JTextField();
            this.altInterfaceText.setPreferredSize(new Dimension(100, 20));
        }
        return this.altInterfaceText;
    }

    private JPanel getSettingsPanelTop2Left() {
        if (this.settingsPanelTop2Left == null) {
            FlowLayout flowLayout2 = new FlowLayout();
            flowLayout2.setVgap(2);
            flowLayout2.setAlignment(0);
            flowLayout2.setHgap(5);
            this.settingsPanelTop2Left = new JPanel();
            this.settingsPanelTop2Left.setLayout(flowLayout2);
            this.settingsPanelTop2Left.add((Component)this.getOutEpPanel(), null);
            this.settingsPanelTop2Left.add((Component)this.getInEpPanel(), null);
            this.settingsPanelTop2Left.add((Component)this.getTimeoutPanel(), null);
        }
        return this.settingsPanelTop2Left;
    }

    private JPanel getSettingsPanelTop2Right() {
        if (this.settingsPanelTop2Right == null) {
            FlowLayout flowLayout3 = new FlowLayout();
            flowLayout3.setVgap(2);
            this.settingsPanelTop2Right = new JPanel();
            this.settingsPanelTop2Right.setLayout(flowLayout3);
            this.settingsPanelTop2Right.add((Component)this.getOpenDeviceButton(), null);
            this.settingsPanelTop2Right.add((Component)this.getCloseDevice(), null);
            this.settingsPanelTop2Right.add((Component)this.getResetButton(), null);
        }
        return this.settingsPanelTop2Right;
    }

    private JPanel getOutEpPanel() {
        if (this.outEpPanel == null) {
            this.outEpPanel = new JPanel();
            this.outEpPanel.setLayout(new BoxLayout(this.getOutEpPanel(), 0));
            this.outEpPanel.setBorder(BorderFactory.createTitledBorder(null, "OUT EP", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.outEpPanel.add((Component)this.getOutEpText(), null);
        }
        return this.outEpPanel;
    }

    private JTextField getOutEpText() {
        if (this.outEpText == null) {
            this.outEpText = new JTextField();
            this.outEpText.setPreferredSize(new Dimension(100, 20));
        }
        return this.outEpText;
    }

    private JPanel getInEpPanel() {
        if (this.inEpPanel == null) {
            this.inEpPanel = new JPanel();
            this.inEpPanel.setLayout(new BoxLayout(this.getInEpPanel(), 0));
            this.inEpPanel.setBorder(BorderFactory.createTitledBorder(null, "IN EP", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.inEpPanel.add((Component)this.getInEpText(), null);
        }
        return this.inEpPanel;
    }

    private JTextField getInEpText() {
        if (this.inEpText == null) {
            this.inEpText = new JTextField();
            this.inEpText.setPreferredSize(new Dimension(100, 20));
        }
        return this.inEpText;
    }

    private JPanel getTimeoutPanel() {
        if (this.timeoutPanel == null) {
            this.timeoutPanel = new JPanel();
            this.timeoutPanel.setLayout(new BoxLayout(this.getTimeoutPanel(), 0));
            this.timeoutPanel.setBorder(BorderFactory.createTitledBorder(null, "Timeout", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.timeoutPanel.add((Component)this.getTimeoutText(), null);
        }
        return this.timeoutPanel;
    }

    private JTextField getTimeoutText() {
        if (this.timeoutText == null) {
            this.timeoutText = new JTextField();
            this.timeoutText.setPreferredSize(new Dimension(100, 20));
        }
        return this.timeoutText;
    }

    private JPanel getSendDataPanel() {
        if (this.sendDataPanel == null) {
            FlowLayout flowLayout4 = new FlowLayout();
            flowLayout4.setAlignment(0);
            this.sendDataPanel = new JPanel();
            this.sendDataPanel.setLayout(flowLayout4);
            this.sendDataPanel.setBorder(BorderFactory.createTitledBorder(null, "Data to send [hex]", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.sendDataPanel.add((Component)this.getSendRecDataText(), null);
        }
        return this.sendDataPanel;
    }

    private JPanel getSendRecButtonsPanel() {
        if (this.sendRecButtonsPanel == null) {
            FlowLayout flowLayout5 = new FlowLayout();
            flowLayout5.setAlignment(0);
            flowLayout5.setVgap(0);
            this.sendRecButtonsPanel = new JPanel();
            this.sendRecButtonsPanel.setLayout(flowLayout5);
            this.sendRecButtonsPanel.add((Component)this.getSendRecButtonsPanelTop(), null);
            this.sendRecButtonsPanel.add((Component)this.getSendRecButtonsPanelBottom(), null);
        }
        return this.sendRecButtonsPanel;
    }

    private JButton getSendButton() {
        if (this.sendButton == null) {
            this.sendButton = new JButton();
            this.sendButton.setText("Send");
            this.sendButton.setName("sendButton");
            this.sendButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int index = TestApp.this.sendTypeComboBox.getSelectedIndex();
                    if (index == AbstractDeviceInfo.TransferMode.Bulk.ordinal()) {
                        TestApp.this.dev.setOutEPBulk(TestApp.this.parseInt(TestApp.this.outEpText.getText().trim()));
                        TestApp.this.dev.setMode(AbstractDeviceInfo.TransferMode.Bulk);
                    } else if (index == AbstractDeviceInfo.TransferMode.Interrupt.ordinal()) {
                        TestApp.this.dev.setOutEPInt(TestApp.this.parseInt(TestApp.this.outEpText.getText().trim()));
                        TestApp.this.dev.setMode(AbstractDeviceInfo.TransferMode.Interrupt);
                    }
                    byte[] data = TestApp.this.parseByteArray(TestApp.this.sendDataText.getText().trim());
                    TestApp.this.dev.write(data, data.length);
                }
            });
        }
        return this.sendButton;
    }

    private JButton getRecButton() {
        if (this.recButton == null) {
            this.recButton = new JButton();
            this.recButton.setText("Receive");
            this.recButton.setName("recButton");
            this.recButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int index = TestApp.this.sendTypeComboBox.getSelectedIndex();
                    if (index == AbstractDeviceInfo.TransferMode.Bulk.ordinal()) {
                        TestApp.this.dev.setInEPBulk(TestApp.this.parseInt(TestApp.this.inEpText.getText().trim()));
                        TestApp.this.dev.setMode(AbstractDeviceInfo.TransferMode.Bulk);
                    } else if (index == AbstractDeviceInfo.TransferMode.Interrupt.ordinal()) {
                        TestApp.this.dev.setInEPInt(TestApp.this.parseInt(TestApp.this.inEpText.getText().trim()));
                        TestApp.this.dev.setMode(AbstractDeviceInfo.TransferMode.Interrupt);
                    }
                    TestApp.this.dev.read();
                }
            });
        }
        return this.recButton;
    }

    private JTextField getSendRecDataText() {
        if (this.sendDataText == null) {
            this.sendDataText = new JTextField();
            this.sendDataText.setPreferredSize(new Dimension(650, 20));
        }
        return this.sendDataText;
    }

    int parseInt(String s) {
        if (s == "") {
            return 0;
        }
        if (s.indexOf(120) > 0) {
            if (s.length() <= 2) {
                return 0;
            }
            return Integer.parseInt(s.substring(s.indexOf(120) + 1, s.length()), 16);
        }
        return Integer.parseInt(s);
    }

    byte[] parseByteArray(String s) {
        int HEX_WIDTH = 5;
        StringBuffer sb = new StringBuffer();
        int stringIndex = 0;
        int spaceIndex = 0;
        while (stringIndex + 3 < s.length()) {
            String ss = s.substring(spaceIndex, spaceIndex + 4);
            spaceIndex = s.indexOf(32, stringIndex) + 1;
            sb.append((char)this.parseInt(ss));
            stringIndex += 5;
        }
        return sb.toString().getBytes();
    }

    private static String toHexString(int value) {
        return "0x" + Integer.toHexString(value);
    }

    private JComboBox getSendTypeComboBox() {
        if (this.sendTypeComboBox == null) {
            this.sendTypeComboBox = new JComboBox<String>(this.dev.getTransferTypes());
            this.sendTypeComboBox.setSelectedIndex(this.dev.getOutMode().ordinal());
            this.sendTypeComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        String mode = (String)e.getItem();
                        if (mode.equalsIgnoreCase("Bulk")) {
                            TestApp.this.dev.setOutMode(AbstractDeviceInfo.TransferMode.Bulk);
                            TestApp.this.setOutEpAddr();
                        } else if (mode.equalsIgnoreCase("Interrupt")) {
                            TestApp.this.dev.setOutMode(AbstractDeviceInfo.TransferMode.Interrupt);
                            TestApp.this.setOutEpAddr();
                        }
                    }
                }
            });
        }
        return this.sendTypeComboBox;
    }

    private JComboBox getRecTypeComboBox() {
        if (this.recTypeComboBox == null) {
            this.recTypeComboBox = new JComboBox<String>(this.dev.getTransferTypes());
            this.recTypeComboBox.setSelectedIndex(this.dev.getInMode().ordinal());
            this.recTypeComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        String mode = (String)e.getItem();
                        if (mode.equalsIgnoreCase("Bulk")) {
                            TestApp.this.dev.setInMode(AbstractDeviceInfo.TransferMode.Bulk);
                            TestApp.this.setInEpAddr();
                        } else if (mode.equalsIgnoreCase("Interrupt")) {
                            TestApp.this.dev.setInMode(AbstractDeviceInfo.TransferMode.Interrupt);
                            TestApp.this.setInEpAddr();
                        }
                    }
                }
            });
        }
        return this.recTypeComboBox;
    }

    private JPanel getSendRecButtonsPanelTop() {
        if (this.sendRecButtonsPanelTop == null) {
            BorderLayout borderLayout1 = new BorderLayout();
            borderLayout1.setHgap(5);
            this.sendRecButtonsPanelTop = new JPanel();
            this.sendRecButtonsPanelTop.setBorder(BorderFactory.createTitledBorder(null, "OUT", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.sendRecButtonsPanelTop.setLayout(borderLayout1);
            this.sendRecButtonsPanelTop.add((Component)this.getSendButton(), "East");
            this.sendRecButtonsPanelTop.add((Component)this.getSendTypeComboBox(), "West");
        }
        return this.sendRecButtonsPanelTop;
    }

    private JPanel getSendRecButtonsPanelBottom() {
        if (this.sendRecButtonsPanelBottom == null) {
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setHgap(5);
            this.sendRecButtonsPanelBottom = new JPanel();
            this.sendRecButtonsPanelBottom.setBorder(BorderFactory.createTitledBorder(null, "IN", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.sendRecButtonsPanelBottom.setLayout(borderLayout);
            this.sendRecButtonsPanelBottom.add((Component)this.getRecButton(), "East");
            this.sendRecButtonsPanelBottom.add((Component)this.getRecTypeComboBox(), "West");
        }
        return this.sendRecButtonsPanelBottom;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TestApp app = new TestApp(new TestDevice());
        app.setDefaultCloseOperation(3);
    }
}

