/*
 * Decompiled with CFR 0.152.
 */
package ch.ntb.usb.testApp;

import ch.ntb.usb.Device;
import ch.ntb.usb.USB;
import ch.ntb.usb.USBException;
import ch.ntb.usb.logger.LogUtil;
import ch.ntb.usb.testApp.AbstractDeviceInfo;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDevice
extends AbstractDeviceInfo {
    private static final Logger logger = LogUtil.getLogger("ch.ntb.usb.test");
    private String sendData = "0x5b 0x02 0x01 0x00 0x03 0x03 0xf0 0xf0 0x1f";
    private Vector<String> transferTypes;
    private static Device dev = null;
    private AbstractDeviceInfo.TransferMode inMode;
    private AbstractDeviceInfo.TransferMode outMode;

    public TestDevice() {
        logger.setLevel(Level.ALL);
        this.transferTypes = new Vector();
        this.transferTypes.add(AbstractDeviceInfo.TransferMode.Bulk.ordinal(), AbstractDeviceInfo.TransferMode.Bulk.name());
        this.transferTypes.add(AbstractDeviceInfo.TransferMode.Interrupt.ordinal(), AbstractDeviceInfo.TransferMode.Interrupt.name());
        this.inMode = AbstractDeviceInfo.TransferMode.Bulk;
        this.outMode = AbstractDeviceInfo.TransferMode.Bulk;
    }

    @Override
    public void initValues() {
        this.setIdVendor((short)-32203);
        this.setIdProduct((short)546);
        this.setTimeout(2000);
        this.setConfiguration(1);
        this.setInterface(0);
        this.setAltinterface(-1);
        this.setOutEPBulk(1);
        this.setInEPBulk(130);
        this.setOutEPInt(3);
        this.setInEPInt(132);
        this.setSleepTimeout(2000);
        this.setMaxDataSize(USB.FULLSPEED_MAX_BULK_PACKET_SIZE);
        this.setMode(AbstractDeviceInfo.TransferMode.Bulk);
    }

    public void openUsbDevice() {
        dev = USB.getDevice(this.getIdVendor(), this.getIdProduct());
        try {
            dev.open(this.getConfiguration(), this.getInterface(), this.getAltinterface());
            logger.info("device opened, interface claimed");
        }
        catch (USBException e) {
            e.printStackTrace();
        }
    }

    public void closeUsbDevice() {
        try {
            if (dev != null) {
                dev.close();
                logger.info("device closed");
            } else {
                logger.warning("no device to close -> open first");
            }
        }
        catch (USBException e) {
            e.printStackTrace();
        }
    }

    public void resetUsbDevice() {
        try {
            if (dev != null) {
                dev.reset();
                logger.info("device reset");
            } else {
                logger.warning("no device to reset -> open first");
            }
        }
        catch (USBException e) {
            e.printStackTrace();
        }
    }

    public void write(byte[] data, int length) {
        int lenWritten = 0;
        try {
            if (dev != null) {
                StringBuffer sb = new StringBuffer();
                switch (this.getOutMode()) {
                    case Bulk: {
                        lenWritten = dev.writeBulk(this.getOutEPBulk(), data, length, this.getTimeout(), false);
                        sb.append("write_bulk, ep: 0x" + Integer.toHexString(this.getOutEPBulk()) + ", " + lenWritten + " Bytes sent: ");
                        break;
                    }
                    case Interrupt: {
                        lenWritten = dev.writeInterrupt(this.getOutEPInt(), data, length, this.getTimeout(), false);
                        sb.append("write_interrupt, ep: 0x" + Integer.toHexString(this.getOutEPInt()) + ", " + lenWritten + " Bytes sent: ");
                    }
                }
                for (int i = 0; i < lenWritten; ++i) {
                    sb.append("0x" + String.format("%1$02X", data[i]) + " ");
                }
                logger.info(sb.toString());
            } else {
                logger.warning("no device opened");
            }
        }
        catch (USBException e) {
            e.printStackTrace();
        }
    }

    public void read() {
        if (dev != null) {
            byte[] data = new byte[dev.getMaxPacketSize()];
            int lenRead = 0;
            try {
                StringBuffer sb = new StringBuffer();
                switch (this.getInMode()) {
                    case Bulk: {
                        lenRead = dev.readBulk(this.getInEPBulk(), data, dev.getMaxPacketSize(), this.getTimeout(), false);
                        sb.append("read_bulk, ep: 0x" + Integer.toHexString(this.getInEPBulk()) + ", " + lenRead + " Bytes received: Data: ");
                        break;
                    }
                    case Interrupt: {
                        lenRead = dev.readInterrupt(this.getInEPInt(), data, dev.getMaxPacketSize(), this.getTimeout(), false);
                        sb.append("read_interrupt, ep: 0x" + Integer.toHexString(this.getInEPInt()) + ", " + lenRead + " Bytes received: Data: ");
                    }
                }
                for (int i = 0; i < lenRead; ++i) {
                    sb.append("0x" + String.format("%1$02X", data[i]) + " ");
                }
                logger.info(sb.toString());
            }
            catch (USBException e) {
                e.printStackTrace();
            }
        } else {
            logger.warning("no device opened");
        }
    }

    public String getSendData() {
        return this.sendData;
    }

    public void setSendData(String sendData) {
        this.sendData = sendData;
    }

    public Vector<String> getTransferTypes() {
        return this.transferTypes;
    }

    public AbstractDeviceInfo.TransferMode getOutMode() {
        return this.outMode;
    }

    public void setOutMode(AbstractDeviceInfo.TransferMode outMode) {
        this.outMode = outMode;
    }

    public AbstractDeviceInfo.TransferMode getInMode() {
        return this.inMode;
    }

    public void setInMode(AbstractDeviceInfo.TransferMode inMode) {
        this.inMode = inMode;
    }
}

