/*
 * Decompiled with CFR 0.152.
 */
package ch.ntb.usb.usbView;

import ch.ntb.usb.LibusbJava;
import ch.ntb.usb.Usb_Bus;
import ch.ntb.usb.Usb_Config_Descriptor;
import ch.ntb.usb.Usb_Device;
import ch.ntb.usb.Usb_Device_Descriptor;
import ch.ntb.usb.Usb_Endpoint_Descriptor;
import ch.ntb.usb.Usb_Interface_Descriptor;
import ch.ntb.usb.testApp.AbstractDeviceInfo;
import ch.ntb.usb.testApp.TestApp;
import ch.ntb.usb.testApp.TestDevice;
import ch.ntb.usb.usbView.UsbTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

public class UsbView
extends JFrame {
    private static final long serialVersionUID = 4693554326612734263L;
    private static final int APP_WIDTH = 600;
    private static final int APP_HIGHT = 800;
    private JPanel jContentPane = null;
    private JMenuBar jJMenuBar = null;
    private JMenu commandsMenu = null;
    private JMenuItem exitMenuItem = null;
    private JMenuItem updateMenuItem = null;
    JTree usbTree = null;
    private JSplitPane jSplitPane = null;
    private JTextArea jPropertiesArea = null;
    UsbTreeModel treeModel;
    JPopupMenu testAppPopup;
    protected JPopupMenu endpointPopup;

    public UsbView() {
        this.initialize();
    }

    private void initialize() {
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(this.getJJMenuBar());
        this.setSize(600, 800);
        this.setContentPane(this.getJContentPane());
        this.setTitle("USB View");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJSplitPane(), "Center");
        }
        return this.jContentPane;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFileMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.commandsMenu == null) {
            this.commandsMenu = new JMenu();
            this.commandsMenu.setText("Commands");
            this.commandsMenu.add(this.getUpdateMenuItem());
            this.commandsMenu.add(this.getExitMenuItem());
        }
        return this.commandsMenu;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText("Exit");
            this.exitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        return this.exitMenuItem;
    }

    private JMenuItem getUpdateMenuItem() {
        if (this.updateMenuItem == null) {
            this.updateMenuItem = new JMenuItem();
            this.updateMenuItem.setText("Update");
            this.updateMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0, true));
            this.updateMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LibusbJava.usb_init();
                    LibusbJava.usb_find_busses();
                    LibusbJava.usb_find_devices();
                    Usb_Bus bus = LibusbJava.usb_get_busses();
                    if (bus != null) {
                        UsbView.this.treeModel.fireTreeStructureChanged(bus);
                        UsbView.this.expandAll(UsbView.this.usbTree);
                    }
                }
            });
        }
        return this.updateMenuItem;
    }

    private JTree getUsbTree() {
        if (this.usbTree == null) {
            LibusbJava.usb_init();
            LibusbJava.usb_find_busses();
            LibusbJava.usb_find_devices();
            Usb_Bus bus = LibusbJava.usb_get_busses();
            this.treeModel = new UsbTreeModel(bus, this.jPropertiesArea);
            this.usbTree = new JTree(this.treeModel);
            this.expandAll(this.usbTree);
            this.usbTree.addTreeSelectionListener(this.treeModel);
            this.getJTestAppPopup();
            this.usbTree.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    JTree tree;
                    TreePath path;
                    Object source;
                    if (e.isPopupTrigger() && (source = e.getSource()) instanceof JTree && (path = (tree = (JTree)source).getPathForLocation(e.getX(), e.getY())) != null && path.getLastPathComponent() instanceof Usb_Interface_Descriptor) {
                        UsbView.this.usbTree.setSelectionPath(path);
                        UsbView.this.testAppPopup.show(tree, e.getX(), e.getY());
                    }
                }

                public void mouseReleased(MouseEvent e) {
                    JTree tree;
                    TreePath path;
                    Object source;
                    if (e.isPopupTrigger() && e.isPopupTrigger() && (source = e.getSource()) instanceof JTree && (path = (tree = (JTree)source).getPathForLocation(e.getX(), e.getY())) != null && path.getLastPathComponent() instanceof Usb_Interface_Descriptor) {
                        UsbView.this.usbTree.setSelectionPath(path);
                        UsbView.this.testAppPopup.show(tree, e.getX(), e.getY());
                    }
                }
            });
        }
        return this.usbTree;
    }

    private void getJTestAppPopup() {
        this.testAppPopup = new JPopupMenu();
        this.endpointPopup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Start a test application using this interface");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                this.initAndStartTestApp();
            }

            private void initAndStartTestApp() {
                TreePath path;
                TreePath parent;
                JTree tree = (JTree)UsbView.this.testAppPopup.getInvoker();
                Usb_Endpoint_Descriptor[] endpoints = null;
                int altinterface = -1;
                int interface_ = -1;
                int configuration = -1;
                short vendorId = -1;
                short productId = -1;
                for (parent = path = tree.getSelectionPath(); parent != null && !(parent.getLastPathComponent() instanceof Usb_Bus); parent = parent.getParentPath()) {
                    Object usbObj = parent.getLastPathComponent();
                    if (usbObj instanceof Usb_Interface_Descriptor) {
                        Usb_Interface_Descriptor usbIntDesc = (Usb_Interface_Descriptor)usbObj;
                        endpoints = usbIntDesc.getEndpoint();
                        interface_ = usbIntDesc.getBInterfaceNumber();
                        altinterface = usbIntDesc.getBAlternateSetting();
                        continue;
                    }
                    if (usbObj instanceof Usb_Config_Descriptor) {
                        configuration = ((Usb_Config_Descriptor)usbObj).getBConfigurationValue();
                        continue;
                    }
                    if (!(usbObj instanceof Usb_Device)) continue;
                    Usb_Device_Descriptor devDesc = ((Usb_Device)usbObj).getDescriptor();
                    productId = devDesc.getIdProduct();
                    vendorId = devDesc.getIdVendor();
                }
                if (parent != null) {
                    int type;
                    int i;
                    Usb_Endpoint_Descriptor[] outEPs = null;
                    int nofOutEPs = 0;
                    Usb_Endpoint_Descriptor[] inEPs = null;
                    int nofInEPs = 0;
                    if (endpoints != null) {
                        outEPs = new Usb_Endpoint_Descriptor[endpoints.length];
                        inEPs = new Usb_Endpoint_Descriptor[endpoints.length];
                        for (int i2 = 0; i2 < endpoints.length; ++i2) {
                            int epAddr = endpoints[i2].getBEndpointAddress() & 0xFF;
                            if ((epAddr & 0x80) > 0) {
                                inEPs[nofInEPs++] = endpoints[i2];
                                continue;
                            }
                            outEPs[nofOutEPs++] = endpoints[i2];
                        }
                    }
                    TestDevice testDevice = new TestDevice();
                    testDevice.setIdProduct(productId);
                    testDevice.setIdVendor(vendorId);
                    testDevice.setAltinterface(altinterface);
                    testDevice.setConfiguration(configuration);
                    testDevice.setInterface(interface_);
                    if (inEPs != null) {
                        block10: for (i = 0; i < nofInEPs; ++i) {
                            type = inEPs[i].getBmAttributes() & 3;
                            switch (type) {
                                case 2: {
                                    testDevice.setInEPBulk(inEPs[i].getBEndpointAddress() & 0xFF);
                                    testDevice.setInMode(AbstractDeviceInfo.TransferMode.Bulk);
                                    continue block10;
                                }
                                case 3: {
                                    testDevice.setInEPInt(inEPs[i].getBEndpointAddress() & 0xFF);
                                    testDevice.setInMode(AbstractDeviceInfo.TransferMode.Interrupt);
                                    continue block10;
                                }
                            }
                        }
                    }
                    if (outEPs != null) {
                        block11: for (i = 0; i < nofOutEPs; ++i) {
                            type = outEPs[i].getBmAttributes() & 3;
                            switch (type) {
                                case 2: {
                                    testDevice.setOutEPBulk(outEPs[i].getBEndpointAddress() & 0xFF);
                                    testDevice.setOutMode(AbstractDeviceInfo.TransferMode.Bulk);
                                    continue block11;
                                }
                                case 3: {
                                    testDevice.setOutEPInt(outEPs[i].getBEndpointAddress() & 0xFF);
                                    testDevice.setOutMode(AbstractDeviceInfo.TransferMode.Interrupt);
                                    continue block11;
                                }
                            }
                        }
                    }
                    TestApp app = new TestApp(testDevice);
                    app.setVisible(true);
                } else {
                    System.out.println("error, could not find device node");
                }
            }
        });
        this.testAppPopup.add(menuItem);
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setOrientation(0);
            this.jSplitPane.setContinuousLayout(true);
            this.jSplitPane.setDividerLocation(400);
            this.jSplitPane.setBottomComponent(this.createScrollPane(this.getJPropertiesArea()));
            this.jSplitPane.setTopComponent(this.createScrollPane(this.getUsbTree()));
        }
        return this.jSplitPane;
    }

    private JTextArea getJPropertiesArea() {
        if (this.jPropertiesArea == null) {
            this.jPropertiesArea = new JTextArea();
        }
        return this.jPropertiesArea;
    }

    private JScrollPane createScrollPane(Component view) {
        JScrollPane scrollPane = new JScrollPane(view);
        return scrollPane;
    }

    public static void main(String[] args) {
        UsbView application = new UsbView();
        application.setVisible(true);
    }

    void expandAll(JTree tree) {
        for (int row = 0; row < tree.getRowCount(); ++row) {
            tree.expandRow(row);
        }
    }
}

