/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hpsf.CustomProperty;
import org.apache.poi.hpsf.MutableProperty;

public class CustomProperties
extends HashMap {
    private Map dictionaryIDToName = new HashMap();
    private Map dictionaryNameToID = new HashMap();
    private boolean isPure = true;

    public CustomProperty put(String name, CustomProperty cp) {
        if (name == null) {
            this.isPure = false;
            return null;
        }
        if (!name.equals(cp.getName())) {
            throw new IllegalArgumentException("Parameter \"name\" (" + name + ") and custom property's name (" + cp.getName() + ") do not match.");
        }
        Long idKey = new Long(cp.getID());
        Long oldID = (Long)this.dictionaryNameToID.get(name);
        this.dictionaryIDToName.remove(oldID);
        this.dictionaryNameToID.put(name, idKey);
        this.dictionaryIDToName.put(idKey, name);
        CustomProperty oldCp = (CustomProperty)super.remove(oldID);
        super.put(idKey, cp);
        return oldCp;
    }

    private Object put(CustomProperty customProperty) throws ClassCastException {
        String name = customProperty.getName();
        Long oldId = (Long)this.dictionaryNameToID.get(name);
        if (oldId != null) {
            customProperty.setID(oldId);
        } else {
            long max = 1L;
            Iterator i = this.dictionaryIDToName.keySet().iterator();
            while (i.hasNext()) {
                long id = (Long)i.next();
                if (id <= max) continue;
                max = id;
            }
            customProperty.setID(max + 1L);
        }
        return this.put(name, customProperty);
    }

    public Object remove(String name) {
        Long id = (Long)this.dictionaryNameToID.get(name);
        if (id == null) {
            return null;
        }
        this.dictionaryIDToName.remove(id);
        this.dictionaryNameToID.remove(name);
        return super.remove(id);
    }

    public Object put(String name, String value) {
        MutableProperty p = new MutableProperty();
        p.setID(-1L);
        p.setType(31L);
        p.setValue(value);
        CustomProperty cp = new CustomProperty(p, name);
        return this.put(cp);
    }

    public Object put(String name, Long value) {
        MutableProperty p = new MutableProperty();
        p.setID(-1L);
        p.setType(20L);
        p.setValue(value);
        CustomProperty cp = new CustomProperty(p, name);
        return this.put(cp);
    }

    public Object put(String name, Double value) {
        MutableProperty p = new MutableProperty();
        p.setID(-1L);
        p.setType(5L);
        p.setValue(value);
        CustomProperty cp = new CustomProperty(p, name);
        return this.put(cp);
    }

    public Object put(String name, Integer value) {
        MutableProperty p = new MutableProperty();
        p.setID(-1L);
        p.setType(3L);
        p.setValue(value);
        CustomProperty cp = new CustomProperty(p, name);
        return this.put(cp);
    }

    public Object put(String name, Boolean value) {
        MutableProperty p = new MutableProperty();
        p.setID(-1L);
        p.setType(11L);
        p.setValue(value);
        CustomProperty cp = new CustomProperty(p, name);
        return this.put(cp);
    }

    public Object get(String name) {
        Long id = (Long)this.dictionaryNameToID.get(name);
        CustomProperty cp = (CustomProperty)super.get(id);
        return cp != null ? cp.getValue() : null;
    }

    public Object put(String name, Date value) {
        MutableProperty p = new MutableProperty();
        p.setID(-1L);
        p.setType(64L);
        p.setValue(value);
        CustomProperty cp = new CustomProperty(p, name);
        return this.put(cp);
    }

    public Set keySet() {
        return this.dictionaryNameToID.keySet();
    }

    public Set nameSet() {
        return this.dictionaryNameToID.keySet();
    }

    public Set idSet() {
        return this.dictionaryNameToID.keySet();
    }

    public void setCodepage(int codepage) {
        MutableProperty p = new MutableProperty();
        p.setID(1L);
        p.setType(2L);
        p.setValue(new Integer(codepage));
        this.put(new CustomProperty(p));
    }

    Map getDictionary() {
        return this.dictionaryIDToName;
    }

    public boolean containsKey(Object key) {
        if (key instanceof Long) {
            return super.containsKey((Long)key);
        }
        if (key instanceof String) {
            return super.containsKey((Long)this.dictionaryNameToID.get(key));
        }
        return false;
    }

    public boolean containsValue(Object value) {
        if (value instanceof CustomProperty) {
            return super.containsValue((CustomProperty)value);
        }
        Iterator iterator = super.values().iterator();
        while (iterator.hasNext()) {
            CustomProperty cp = (CustomProperty)iterator.next();
            if (cp.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public int getCodepage() {
        int codepage = -1;
        Iterator i = this.values().iterator();
        while (codepage == -1 && i.hasNext()) {
            CustomProperty cp = (CustomProperty)i.next();
            if (cp.getID() != 1L) continue;
            codepage = (Integer)cp.getValue();
        }
        return codepage;
    }

    public boolean isPure() {
        return this.isPure;
    }

    public void setPure(boolean isPure) {
        this.isPure = isPure;
    }
}

