/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.model.WorkbookRecordList;
import org.apache.poi.hssf.record.CRNCountRecord;
import org.apache.poi.hssf.record.CRNRecord;
import org.apache.poi.hssf.record.ExternSheetRecord;
import org.apache.poi.hssf.record.ExternalNameRecord;
import org.apache.poi.hssf.record.NameCommentRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SupBookRecord;
import org.apache.poi.ss.formula.ptg.ErrPtg;
import org.apache.poi.ss.formula.ptg.NameXPtg;
import org.apache.poi.ss.formula.ptg.Ptg;

final class LinkTable {
    private ExternalBookBlock[] _externalBookBlocks;
    private final ExternSheetRecord _externSheetRecord;
    private final List _definedNames;
    private final int _recordCount;
    private final WorkbookRecordList _workbookRecordList;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LinkTable(List inputList, int startIndex, WorkbookRecordList workbookRecordList, Map commentRecords) {
        Class<?> clazz;
        Class clazz2;
        this._workbookRecordList = workbookRecordList;
        RecordStream rs = new RecordStream(inputList, startIndex);
        ArrayList<ExternalBookBlock> temp = new ArrayList<ExternalBookBlock>();
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                temp.add(new ExternalBookBlock(rs));
            }
            clazz2 = rs.peekNextClass();
            clazz = class$2;
            if (clazz != null) continue;
            try {
                clazz = Class.forName("org.apache.poi.hssf.record.SupBookRecord");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (clazz2 == clazz);
        this._externalBookBlocks = new ExternalBookBlock[temp.size()];
        temp.toArray(this._externalBookBlocks);
        temp.clear();
        if (this._externalBookBlocks.length > 0) {
            Class clazz3 = rs.peekNextClass();
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("org.apache.poi.hssf.record.ExternSheetRecord");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this._externSheetRecord = clazz3 != clazz4 ? null : LinkTable.readExtSheetRecord(rs);
        } else {
            this._externSheetRecord = null;
        }
        this._definedNames = new ArrayList();
        while (true) {
            Class nextClass = rs.peekNextClass();
            Class<?> clazz5 = class$4;
            if (clazz5 == null) {
                try {
                    clazz5 = Class.forName("org.apache.poi.hssf.record.NameRecord");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (nextClass == clazz5) {
                NameRecord nr = (NameRecord)rs.getNext();
                this._definedNames.add(nr);
                continue;
            }
            Class<?> clazz6 = class$5;
            if (clazz6 == null) {
                try {
                    clazz6 = Class.forName("org.apache.poi.hssf.record.NameCommentRecord");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (nextClass != clazz6) {
                this._recordCount = rs.getCountRead();
                this._workbookRecordList.getRecords().addAll(inputList.subList(startIndex, startIndex + this._recordCount));
                return;
            }
            NameCommentRecord ncr = (NameCommentRecord)rs.getNext();
            commentRecords.put(ncr.getNameText(), ncr);
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ExternSheetRecord readExtSheetRecord(RecordStream rs) {
        Class<?> clazz;
        Class clazz2;
        ArrayList<ExternSheetRecord> temp = new ArrayList<ExternSheetRecord>(2);
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                temp.add((ExternSheetRecord)rs.getNext());
            }
            clazz2 = rs.peekNextClass();
            clazz = class$3;
            if (clazz != null) continue;
            try {
                clazz = Class.forName("org.apache.poi.hssf.record.ExternSheetRecord");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (clazz2 == clazz);
        int nItems = temp.size();
        if (nItems < 1) {
            throw new RuntimeException("Expected an EXTERNSHEET record but got (" + rs.peekNextClass().getName() + ")");
        }
        if (nItems == 1) {
            return (ExternSheetRecord)temp.get(0);
        }
        ExternSheetRecord[] esrs = new ExternSheetRecord[nItems];
        temp.toArray(esrs);
        return ExternSheetRecord.combine(esrs);
    }

    public LinkTable(int numberOfSheets, WorkbookRecordList workbookRecordList) {
        this._workbookRecordList = workbookRecordList;
        this._definedNames = new ArrayList();
        this._externalBookBlocks = new ExternalBookBlock[]{new ExternalBookBlock(numberOfSheets)};
        this._externSheetRecord = new ExternSheetRecord();
        this._recordCount = 2;
        SupBookRecord supbook = this._externalBookBlocks[0].getExternalBookRecord();
        int idx = this.findFirstRecordLocBySid((short)140);
        if (idx < 0) {
            throw new RuntimeException("CountryRecord not found");
        }
        this._workbookRecordList.add(idx + 1, this._externSheetRecord);
        this._workbookRecordList.add(idx + 1, supbook);
    }

    public int getRecordCount() {
        return this._recordCount;
    }

    public NameRecord getSpecificBuiltinRecord(byte builtInCode, int sheetNumber) {
        Iterator iterator = this._definedNames.iterator();
        while (iterator.hasNext()) {
            NameRecord record = (NameRecord)iterator.next();
            if (record.getBuiltInName() != builtInCode || record.getSheetNumber() != sheetNumber) continue;
            return record;
        }
        return null;
    }

    public void removeBuiltinRecord(byte name, int sheetIndex) {
        NameRecord record = this.getSpecificBuiltinRecord(name, sheetIndex);
        if (record != null) {
            this._definedNames.remove(record);
        }
    }

    public int getNumNames() {
        return this._definedNames.size();
    }

    public NameRecord getNameRecord(int index) {
        return (NameRecord)this._definedNames.get(index);
    }

    public void addName(NameRecord name) {
        this._definedNames.add(name);
        int idx = this.findFirstRecordLocBySid((short)23);
        if (idx == -1) {
            idx = this.findFirstRecordLocBySid((short)430);
        }
        if (idx == -1) {
            idx = this.findFirstRecordLocBySid((short)140);
        }
        int countNames = this._definedNames.size();
        this._workbookRecordList.add(idx + countNames, name);
    }

    public void removeName(int namenum) {
        this._definedNames.remove(namenum);
    }

    public boolean nameAlreadyExists(NameRecord name) {
        int i = this.getNumNames() - 1;
        while (i >= 0) {
            NameRecord rec = this.getNameRecord(i);
            if (rec != name && LinkTable.isDuplicatedNames(name, rec)) {
                return true;
            }
            --i;
        }
        return false;
    }

    private static boolean isDuplicatedNames(NameRecord firstName, NameRecord lastName) {
        return lastName.getNameText().equalsIgnoreCase(firstName.getNameText()) && LinkTable.isSameSheetNames(firstName, lastName);
    }

    private static boolean isSameSheetNames(NameRecord firstName, NameRecord lastName) {
        return lastName.getSheetNumber() == firstName.getSheetNumber();
    }

    public String[] getExternalBookAndSheetName(int extRefIndex) {
        int ebIx = this._externSheetRecord.getExtbookIndexFromRefIndex(extRefIndex);
        SupBookRecord ebr = this._externalBookBlocks[ebIx].getExternalBookRecord();
        if (!ebr.isExternalReferences()) {
            return null;
        }
        int shIx = this._externSheetRecord.getFirstSheetIndexFromRefIndex(extRefIndex);
        String usSheetName = null;
        if (shIx >= 0) {
            usSheetName = ebr.getSheetNames()[shIx];
        }
        return new String[]{ebr.getURL(), usSheetName};
    }

    public int getExternalSheetIndex(String workbookName, String sheetName) {
        SupBookRecord ebrTarget = null;
        int externalBookIndex = -1;
        int i = 0;
        while (i < this._externalBookBlocks.length) {
            SupBookRecord ebr = this._externalBookBlocks[i].getExternalBookRecord();
            if (ebr.isExternalReferences() && workbookName.equals(ebr.getURL())) {
                ebrTarget = ebr;
                externalBookIndex = i;
                break;
            }
            ++i;
        }
        if (ebrTarget == null) {
            throw new RuntimeException("No external workbook with name '" + workbookName + "'");
        }
        int sheetIndex = LinkTable.getSheetIndex(ebrTarget.getSheetNames(), sheetName);
        int result = this._externSheetRecord.getRefIxForSheet(externalBookIndex, sheetIndex);
        if (result < 0) {
            throw new RuntimeException("ExternSheetRecord does not contain combination (" + externalBookIndex + ", " + sheetIndex + ")");
        }
        return result;
    }

    private static int getSheetIndex(String[] sheetNames, String sheetName) {
        int i = 0;
        while (i < sheetNames.length) {
            if (sheetNames[i].equals(sheetName)) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("External workbook does not contain sheet '" + sheetName + "'");
    }

    public int getIndexToInternalSheet(int extRefIndex) {
        return this._externSheetRecord.getFirstSheetIndexFromRefIndex(extRefIndex);
    }

    public int getSheetIndexFromExternSheetIndex(int extRefIndex) {
        if (extRefIndex >= this._externSheetRecord.getNumOfRefs()) {
            return -1;
        }
        return this._externSheetRecord.getFirstSheetIndexFromRefIndex(extRefIndex);
    }

    public int checkExternSheet(int sheetIndex) {
        int thisWbIndex = -1;
        int i = 0;
        while (i < this._externalBookBlocks.length) {
            SupBookRecord ebr = this._externalBookBlocks[i].getExternalBookRecord();
            if (ebr.isInternalReferences()) {
                thisWbIndex = i;
                break;
            }
            ++i;
        }
        if (thisWbIndex < 0) {
            throw new RuntimeException("Could not find 'internal references' EXTERNALBOOK");
        }
        i = this._externSheetRecord.getRefIxForSheet(thisWbIndex, sheetIndex);
        if (i >= 0) {
            return i;
        }
        return this._externSheetRecord.addRef(thisWbIndex, sheetIndex, sheetIndex);
    }

    private int findFirstRecordLocBySid(short sid) {
        int index = 0;
        Iterator iterator = this._workbookRecordList.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getSid() == sid) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public String resolveNameXText(int refIndex, int definedNameIndex) {
        int extBookIndex = this._externSheetRecord.getExtbookIndexFromRefIndex(refIndex);
        return this._externalBookBlocks[extBookIndex].getNameText(definedNameIndex);
    }

    public int resolveNameXIx(int refIndex, int definedNameIndex) {
        int extBookIndex = this._externSheetRecord.getExtbookIndexFromRefIndex(refIndex);
        return this._externalBookBlocks[extBookIndex].getNameIx(definedNameIndex);
    }

    public NameXPtg getNameXPtg(String name) {
        int i = 0;
        while (i < this._externalBookBlocks.length) {
            int sheetRefIndex;
            int definedNameIndex = this._externalBookBlocks[i].getIndexOfName(name);
            if (definedNameIndex >= 0 && (sheetRefIndex = this.findRefIndexFromExtBookIndex(i)) >= 0) {
                return new NameXPtg(sheetRefIndex, definedNameIndex);
            }
            ++i;
        }
        return null;
    }

    public NameXPtg addNameXPtg(String name) {
        int extBlockIndex = -1;
        ExternalBookBlock extBlock = null;
        int i = 0;
        while (i < this._externalBookBlocks.length) {
            SupBookRecord ebr = this._externalBookBlocks[i].getExternalBookRecord();
            if (ebr.isAddInFunctions()) {
                extBlock = this._externalBookBlocks[i];
                extBlockIndex = i;
                break;
            }
            ++i;
        }
        if (extBlock == null) {
            extBlock = new ExternalBookBlock();
            ExternalBookBlock[] tmp = new ExternalBookBlock[this._externalBookBlocks.length + 1];
            System.arraycopy(this._externalBookBlocks, 0, tmp, 0, this._externalBookBlocks.length);
            tmp[tmp.length - 1] = extBlock;
            this._externalBookBlocks = tmp;
            extBlockIndex = this._externalBookBlocks.length - 1;
            int idx = this.findFirstRecordLocBySid((short)23);
            this._workbookRecordList.add(idx, extBlock.getExternalBookRecord());
            this._externSheetRecord.addRef(this._externalBookBlocks.length - 1, -2, -2);
        }
        ExternalNameRecord extNameRecord = new ExternalNameRecord();
        extNameRecord.setText(name);
        extNameRecord.setParsedExpression(new Ptg[]{ErrPtg.REF_INVALID});
        int nameIndex = extBlock.addExternalName(extNameRecord);
        int supLinkIndex = 0;
        Iterator iterator = this._workbookRecordList.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record instanceof SupBookRecord && ((SupBookRecord)record).isAddInFunctions()) break;
            ++supLinkIndex;
        }
        int numberOfNames = extBlock.getNumberOfNames();
        this._workbookRecordList.add(supLinkIndex + numberOfNames, extNameRecord);
        int ix = this._externSheetRecord.getRefIxForSheet(extBlockIndex, -2);
        return new NameXPtg(ix, nameIndex);
    }

    private int findRefIndexFromExtBookIndex(int extBookIndex) {
        return this._externSheetRecord.findRefIndexFromExtBookIndex(extBookIndex);
    }

    public boolean changeExternalReference(String oldUrl, String newUrl) {
        int i = 0;
        while (i < this._externalBookBlocks.length) {
            ExternalBookBlock ex = this._externalBookBlocks[i];
            SupBookRecord externalRecord = ex.getExternalBookRecord();
            if (externalRecord.isExternalReferences() && externalRecord.getURL().equals(oldUrl)) {
                externalRecord.setURL(newUrl);
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final class CRNBlock {
        private final CRNCountRecord _countRecord;
        private final CRNRecord[] _crns;

        public CRNBlock(RecordStream rs) {
            this._countRecord = (CRNCountRecord)rs.getNext();
            int nCRNs = this._countRecord.getNumberOfCRNs();
            CRNRecord[] crns = new CRNRecord[nCRNs];
            int i = 0;
            while (i < crns.length) {
                crns[i] = (CRNRecord)rs.getNext();
                ++i;
            }
            this._crns = crns;
        }

        public CRNRecord[] getCrns() {
            return (CRNRecord[])this._crns.clone();
        }
    }

    private static final class ExternalBookBlock {
        private final SupBookRecord _externalBookRecord;
        private ExternalNameRecord[] _externalNameRecords;
        private final CRNBlock[] _crnBlocks;

        /*
         * Handled impossible loop by adding 'first' condition
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ExternalBookBlock(RecordStream rs) {
            Class<?> clazz;
            Class clazz2;
            Class<?> clazz3;
            Class clazz4;
            this._externalBookRecord = (SupBookRecord)rs.getNext();
            ArrayList<Object> temp = new ArrayList<Object>();
            boolean bl = true;
            do {
                if (!bl || (bl = false) || !true) {
                    temp.add(rs.getNext());
                }
                clazz4 = rs.peekNextClass();
                clazz3 = class$0;
                if (clazz3 != null) continue;
                try {
                    clazz3 = Class.forName("org.apache.poi.hssf.record.ExternalNameRecord");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            } while (clazz4 == clazz3);
            this._externalNameRecords = new ExternalNameRecord[temp.size()];
            temp.toArray(this._externalNameRecords);
            temp.clear();
            boolean bl2 = true;
            do {
                if (!bl2 || (bl2 = false) || !true) {
                    temp.add(new CRNBlock(rs));
                }
                clazz2 = rs.peekNextClass();
                clazz = class$1;
                if (clazz != null) continue;
                try {
                    clazz = Class.forName("org.apache.poi.hssf.record.CRNCountRecord");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            } while (clazz2 == clazz);
            this._crnBlocks = new CRNBlock[temp.size()];
            temp.toArray(this._crnBlocks);
        }

        public ExternalBookBlock(int numberOfSheets) {
            this._externalBookRecord = SupBookRecord.createInternalReferences((short)numberOfSheets);
            this._externalNameRecords = new ExternalNameRecord[0];
            this._crnBlocks = new CRNBlock[0];
        }

        public ExternalBookBlock() {
            this._externalBookRecord = SupBookRecord.createAddInFunctions();
            this._externalNameRecords = new ExternalNameRecord[0];
            this._crnBlocks = new CRNBlock[0];
        }

        public SupBookRecord getExternalBookRecord() {
            return this._externalBookRecord;
        }

        public String getNameText(int definedNameIndex) {
            return this._externalNameRecords[definedNameIndex].getText();
        }

        public int getNameIx(int definedNameIndex) {
            return this._externalNameRecords[definedNameIndex].getIx();
        }

        public int getIndexOfName(String name) {
            int i = 0;
            while (i < this._externalNameRecords.length) {
                if (this._externalNameRecords[i].getText().equalsIgnoreCase(name)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public int getNumberOfNames() {
            return this._externalNameRecords.length;
        }

        public int addExternalName(ExternalNameRecord rec) {
            ExternalNameRecord[] tmp = new ExternalNameRecord[this._externalNameRecords.length + 1];
            System.arraycopy(this._externalNameRecords, 0, tmp, 0, this._externalNameRecords.length);
            tmp[tmp.length - 1] = rec;
            this._externalNameRecords = tmp;
            return this._externalNameRecords.length - 1;
        }
    }
}

