/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel.charts;

import org.apache.poi.ss.formula.functions.T;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.charts.ChartDataSource;
import org.apache.poi.ss.util.CellRangeAddress;

public class DataSources {
    static /* synthetic */ Class class$0;

    private DataSources() {
    }

    public static ChartDataSource fromArray(T[] elements) {
        return new ArrayDataSource(elements);
    }

    public static ChartDataSource fromNumericCellRange(Sheet sheet, CellRangeAddress cellRangeAddress) {
        return new AbstractCellRangeDataSource(sheet, cellRangeAddress){

            public Object getPointAt(int index) {
                CellValue cellValue = this.getCellValueAt(index);
                if (cellValue != null && cellValue.getCellType() == 0) {
                    return new Double(cellValue.getNumberValue());
                }
                return null;
            }

            public boolean isNumeric() {
                return true;
            }
        };
    }

    public static ChartDataSource fromStringCellRange(Sheet sheet, CellRangeAddress cellRangeAddress) {
        return new AbstractCellRangeDataSource(sheet, cellRangeAddress){

            public Object getPointAt(int index) {
                CellValue cellValue = this.getCellValueAt(index);
                if (cellValue != null && cellValue.getCellType() == 1) {
                    return cellValue.getStringValue();
                }
                return null;
            }

            public boolean isNumeric() {
                return false;
            }
        };
    }

    private static abstract class AbstractCellRangeDataSource
    implements ChartDataSource {
        private final Sheet sheet;
        private final CellRangeAddress cellRangeAddress;
        private final int numOfCells;
        private FormulaEvaluator evaluator;

        protected AbstractCellRangeDataSource(Sheet sheet, CellRangeAddress cellRangeAddress) {
            this.sheet = sheet;
            this.cellRangeAddress = cellRangeAddress.copy();
            this.numOfCells = this.cellRangeAddress.getNumberOfCells();
            this.evaluator = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator();
        }

        public int getPointCount() {
            return this.numOfCells;
        }

        public boolean isReference() {
            return true;
        }

        public String getFormulaString() {
            return this.cellRangeAddress.formatAsString(this.sheet.getSheetName(), true);
        }

        protected CellValue getCellValueAt(int index) {
            if (index < 0 || index >= this.numOfCells) {
                throw new IndexOutOfBoundsException("Index must be between 0 and " + (this.numOfCells - 1) + " (inclusive), given: " + index);
            }
            int firstRow = this.cellRangeAddress.getFirstRow();
            int firstCol = this.cellRangeAddress.getFirstColumn();
            int lastCol = this.cellRangeAddress.getLastColumn();
            int width = lastCol - firstCol + 1;
            int rowIndex = firstRow + index / width;
            int cellIndex = firstCol + index % width;
            Row row = this.sheet.getRow(rowIndex);
            return row == null ? null : this.evaluator.evaluate(row.getCell(cellIndex));
        }
    }

    private static class ArrayDataSource
    implements ChartDataSource {
        private final T[] elements;

        public ArrayDataSource(T[] elements) {
            this.elements = elements;
        }

        public int getPointCount() {
            return this.elements.length;
        }

        public Object getPointAt(int index) {
            return this.elements[index];
        }

        public boolean isReference() {
            return false;
        }

        public boolean isNumeric() {
            Class<?> arrayComponentType = this.elements.getClass().getComponentType();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Number");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz.isAssignableFrom(arrayComponentType);
        }

        public String getFormulaString() {
            throw new UnsupportedOperationException("Literal data source can not be expressed by reference.");
        }
    }
}

