/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.FontCollection;
import org.apache.poi.hslf.record.PositionDependentRecordContainer;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.TxMasterStyleAtom;

public final class Environment
extends PositionDependentRecordContainer {
    private byte[] _header = new byte[8];
    private static long _type = 1010L;
    private FontCollection fontCollection;
    private TxMasterStyleAtom txmaster;

    public FontCollection getFontCollection() {
        return this.fontCollection;
    }

    protected Environment(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        int i = 0;
        while (i < this._children.length) {
            if (this._children[i] instanceof FontCollection) {
                this.fontCollection = (FontCollection)this._children[i];
            } else if (this._children[i] instanceof TxMasterStyleAtom) {
                this.txmaster = (TxMasterStyleAtom)this._children[i];
            }
            ++i;
        }
        if (this.fontCollection == null) {
            throw new IllegalStateException("Environment didn't contain a FontCollection record!");
        }
    }

    public TxMasterStyleAtom getTxMasterStyleAtom() {
        return this.txmaster;
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream out) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, out);
    }
}

