/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model.types;

import org.apache.poi.hdf.model.hdftypes.HDFType;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public abstract class TLPAbstractType
implements HDFType {
    protected short field_1_itl;
    protected byte field_2_tlp_flags;
    private static BitField fBorders = new BitField(1);
    private static BitField fShading = new BitField(2);
    private static BitField fFont = new BitField(4);
    private static BitField fColor = new BitField(8);
    private static BitField fBestFit = new BitField(16);
    private static BitField fHdrRows = new BitField(32);
    private static BitField fLastRow = new BitField(64);

    protected void fillFields(byte[] data, int offset) {
        this.field_1_itl = LittleEndian.getShort((byte[])data, (int)(0 + offset));
        this.field_2_tlp_flags = data[2 + offset];
    }

    public void serialize(byte[] data, int offset) {
        LittleEndian.putShort((byte[])data, (int)(0 + offset), (short)this.field_1_itl);
        data[2 + offset] = this.field_2_tlp_flags;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[TLP]\n");
        buffer.append("    .itl                  = ");
        buffer.append(" (").append(this.getItl()).append(" )\n");
        buffer.append("    .tlp_flags            = ");
        buffer.append(" (").append(this.getTlp_flags()).append(" )\n");
        buffer.append("         .fBorders                 = ").append(this.isFBorders()).append('\n');
        buffer.append("         .fShading                 = ").append(this.isFShading()).append('\n');
        buffer.append("         .fFont                    = ").append(this.isFFont()).append('\n');
        buffer.append("         .fColor                   = ").append(this.isFColor()).append('\n');
        buffer.append("         .fBestFit                 = ").append(this.isFBestFit()).append('\n');
        buffer.append("         .fHdrRows                 = ").append(this.isFHdrRows()).append('\n');
        buffer.append("         .fLastRow                 = ").append(this.isFLastRow()).append('\n');
        buffer.append("[/TLP]\n");
        return buffer.toString();
    }

    public int getSize() {
        return 7;
    }

    public short getItl() {
        return this.field_1_itl;
    }

    public void setItl(short field_1_itl) {
        this.field_1_itl = field_1_itl;
    }

    public byte getTlp_flags() {
        return this.field_2_tlp_flags;
    }

    public void setTlp_flags(byte field_2_tlp_flags) {
        this.field_2_tlp_flags = field_2_tlp_flags;
    }

    public void setFBorders(boolean value) {
        this.field_2_tlp_flags = (byte)fBorders.setBoolean((int)this.field_2_tlp_flags, value);
    }

    public boolean isFBorders() {
        return fBorders.isSet((int)this.field_2_tlp_flags);
    }

    public void setFShading(boolean value) {
        this.field_2_tlp_flags = (byte)fShading.setBoolean((int)this.field_2_tlp_flags, value);
    }

    public boolean isFShading() {
        return fShading.isSet((int)this.field_2_tlp_flags);
    }

    public void setFFont(boolean value) {
        this.field_2_tlp_flags = (byte)fFont.setBoolean((int)this.field_2_tlp_flags, value);
    }

    public boolean isFFont() {
        return fFont.isSet((int)this.field_2_tlp_flags);
    }

    public void setFColor(boolean value) {
        this.field_2_tlp_flags = (byte)fColor.setBoolean((int)this.field_2_tlp_flags, value);
    }

    public boolean isFColor() {
        return fColor.isSet((int)this.field_2_tlp_flags);
    }

    public void setFBestFit(boolean value) {
        this.field_2_tlp_flags = (byte)fBestFit.setBoolean((int)this.field_2_tlp_flags, value);
    }

    public boolean isFBestFit() {
        return fBestFit.isSet((int)this.field_2_tlp_flags);
    }

    public void setFHdrRows(boolean value) {
        this.field_2_tlp_flags = (byte)fHdrRows.setBoolean((int)this.field_2_tlp_flags, value);
    }

    public boolean isFHdrRows() {
        return fHdrRows.isSet((int)this.field_2_tlp_flags);
    }

    public void setFLastRow(boolean value) {
        this.field_2_tlp_flags = (byte)fLastRow.setBoolean((int)this.field_2_tlp_flags, value);
    }

    public boolean isFLastRow() {
        return fLastRow.isSet((int)this.field_2_tlp_flags);
    }
}

