/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.InflaterInputStream;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherBlipRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hwpf.model.PICF;
import org.apache.poi.hwpf.model.PICFAndOfficeArtData;
import org.apache.poi.hwpf.usermodel.PictureType;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class Picture {
    public static final byte[] BMP = new byte[]{66, 77};
    public static final byte[] COMPRESSED1 = new byte[]{-2, 120, -38};
    public static final byte[] COMPRESSED2 = new byte[]{-2, 120, -100};
    public static final byte[] EMF;
    public static final byte[] GIF;
    public static final byte[] IHDR;
    public static final byte[] JPG;
    private static final POILogger log;
    public static final byte[] PNG;
    public static final byte[] TIFF;
    public static final byte[] TIFF1;
    public static final byte[] WMF1;
    public static final byte[] WMF2;
    private PICF _picf;
    private PICFAndOfficeArtData _picfAndOfficeArtData;
    private List _blipRecords;
    private byte[] content;
    private int dataBlockStartOfsset;
    private int height = -1;
    private int width = -1;
    static /* synthetic */ Class class$0;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 1;
        EMF = byArray;
        GIF = new byte[]{71, 73, 70};
        IHDR = new byte[]{73, 72, 68, 82};
        JPG = new byte[]{-1, -40};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.hwpf.usermodel.Picture");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = POILogFactory.getLogger((Class)clazz);
        PNG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        byte[] byArray2 = new byte[4];
        byArray2[0] = 73;
        byArray2[1] = 73;
        byArray2[2] = 42;
        TIFF = byArray2;
        byte[] byArray3 = new byte[4];
        byArray3[0] = 77;
        byArray3[1] = 77;
        byArray3[3] = 42;
        TIFF1 = byArray3;
        byte[] byArray4 = new byte[6];
        byArray4[0] = -41;
        byArray4[1] = -51;
        byArray4[2] = -58;
        byArray4[3] = -102;
        WMF1 = byArray4;
        byte[] byArray5 = new byte[6];
        byArray5[0] = 1;
        byArray5[2] = 9;
        byArray5[5] = 3;
        WMF2 = byArray5;
    }

    private static int getBigEndianInt(byte[] data, int offset) {
        return ((data[offset] & 0xFF) << 24) + ((data[offset + 1] & 0xFF) << 16) + ((data[offset + 2] & 0xFF) << 8) + (data[offset + 3] & 0xFF);
    }

    private static int getBigEndianShort(byte[] data, int offset) {
        return ((data[offset] & 0xFF) << 8) + (data[offset + 1] & 0xFF);
    }

    private static boolean matchSignature(byte[] pictureData, byte[] signature, int offset) {
        boolean matched = offset < pictureData.length;
        int i = 0;
        while (i + offset < pictureData.length && i < signature.length) {
            if (pictureData[i + offset] != signature[i]) {
                matched = false;
                break;
            }
            ++i;
        }
        return matched;
    }

    public Picture(EscherBlipRecord blipRecord) {
        this._blipRecords = Arrays.asList(blipRecord);
    }

    public Picture(int dataBlockStartOfsset, byte[] _dataStream, boolean fillBytes) {
        this._picfAndOfficeArtData = new PICFAndOfficeArtData(_dataStream, dataBlockStartOfsset);
        this._picf = this._picfAndOfficeArtData.getPicf();
        this.dataBlockStartOfsset = dataBlockStartOfsset;
        if (this._picfAndOfficeArtData != null && this._picfAndOfficeArtData.getBlipRecords() != null) {
            this._blipRecords = this._picfAndOfficeArtData.getBlipRecords();
        }
        if (fillBytes) {
            this.fillImageContent();
        }
    }

    private void fillImageContent() {
        if (this.content != null && this.content.length > 0) {
            return;
        }
        byte[] rawContent = this.getRawContent();
        if (Picture.matchSignature(rawContent, COMPRESSED1, 32) || Picture.matchSignature(rawContent, COMPRESSED2, 32)) {
            try {
                int readBytes;
                InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(rawContent, 33, rawContent.length - 33));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                while ((readBytes = in.read(buf)) > 0) {
                    out.write(buf, 0, readBytes);
                }
                this.content = out.toByteArray();
            }
            catch (IOException e) {
                log.log(POILogger.INFO, (Object)"Possibly corrupt compression or non-compressed data", (Throwable)e);
            }
        } else {
            this.content = rawContent;
        }
    }

    private void fillJPGWidthHeight() {
        byte[] jpegContent = this.getContent();
        int pointer = 2;
        byte firstByte = jpegContent[pointer];
        byte secondByte = jpegContent[pointer + 1];
        int endOfPicture = jpegContent.length;
        while (pointer < endOfPicture - 1) {
            do {
                firstByte = jpegContent[pointer];
                secondByte = jpegContent[pointer + 1];
            } while (firstByte != -1 && (pointer += 2) < endOfPicture - 1);
            if (firstByte == -1 && pointer < endOfPicture - 1) {
                if (secondByte == -39 || secondByte == -38) break;
                if ((secondByte & 0xF0) == 192 && secondByte != -60 && secondByte != -56 && secondByte != -52) {
                    this.height = Picture.getBigEndianShort(jpegContent, pointer += 5);
                    this.width = Picture.getBigEndianShort(jpegContent, pointer + 2);
                    break;
                }
                ++pointer;
                int length = Picture.getBigEndianShort(jpegContent, ++pointer);
                pointer += length;
                continue;
            }
            ++pointer;
        }
    }

    void fillPNGWidthHeight() {
        int HEADER_START;
        byte[] pngContent = this.getContent();
        if (Picture.matchSignature(pngContent, IHDR, HEADER_START = PNG.length + 4)) {
            int IHDR_CHUNK_WIDTH = HEADER_START + 4;
            this.width = Picture.getBigEndianInt(pngContent, IHDR_CHUNK_WIDTH);
            this.height = Picture.getBigEndianInt(pngContent, IHDR_CHUNK_WIDTH + 4);
        }
    }

    private void fillWidthHeight() {
        PictureType pictureType = this.suggestPictureType();
        if (PictureType.JPEG.equals(pictureType)) {
            this.fillJPGWidthHeight();
        } else if (PictureType.PNG.equals(pictureType)) {
            this.fillPNGWidthHeight();
        }
    }

    public int getAspectRatioX() {
        return this._picf.getMx() / 10;
    }

    public int getAspectRatioY() {
        return this._picf.getMy() / 10;
    }

    public byte[] getContent() {
        this.fillImageContent();
        return this.content;
    }

    public int getDxaCropLeft() {
        return this._picf.getDxaReserved1();
    }

    public int getDxaCropRight() {
        return this._picf.getDxaReserved2();
    }

    public int getDxaGoal() {
        return this._picf.getDxaGoal();
    }

    public int getDyaCropBottom() {
        return this._picf.getDyaReserved2();
    }

    public int getDyaCropTop() {
        return this._picf.getDyaReserved1();
    }

    public int getDyaGoal() {
        return this._picf.getDyaGoal();
    }

    public int getHeight() {
        if (this.height == -1) {
            this.fillWidthHeight();
        }
        return this.height;
    }

    public int getHorizontalScalingFactor() {
        return this._picf.getMx();
    }

    public String getMimeType() {
        return this.suggestPictureType().getMime();
    }

    public byte[] getRawContent() {
        if (this._blipRecords == null || this._blipRecords.size() != 1) {
            return new byte[0];
        }
        EscherRecord escherRecord = (EscherRecord)this._blipRecords.get(0);
        if (escherRecord instanceof EscherBlipRecord) {
            return ((EscherBlipRecord)escherRecord).getPicturedata();
        }
        if (escherRecord instanceof EscherBSERecord) {
            return ((EscherBSERecord)escherRecord).getBlipRecord().getPicturedata();
        }
        return new byte[0];
    }

    public int getSize() {
        return this.getContent().length;
    }

    public int getStartOffset() {
        return this.dataBlockStartOfsset;
    }

    public int getVerticalScalingFactor() {
        return this._picf.getMy();
    }

    public int getWidth() {
        if (this.width == -1) {
            this.fillWidthHeight();
        }
        return this.width;
    }

    public String suggestFileExtension() {
        return this.suggestPictureType().getExtension();
    }

    public String suggestFullFileName() {
        String fileExt = this.suggestFileExtension();
        return String.valueOf(Integer.toHexString(this.dataBlockStartOfsset)) + (fileExt.length() > 0 ? "." + fileExt : "");
    }

    public PictureType suggestPictureType() {
        if (this._blipRecords == null || this._blipRecords.size() != 1) {
            return PictureType.UNKNOWN;
        }
        EscherRecord escherRecord = (EscherRecord)this._blipRecords.get(0);
        switch (escherRecord.getRecordId()) {
            case -4089: {
                EscherBSERecord bseRecord = (EscherBSERecord)escherRecord;
                switch (bseRecord.getBlipTypeWin32()) {
                    case 0: {
                        return PictureType.UNKNOWN;
                    }
                    case 1: {
                        return PictureType.UNKNOWN;
                    }
                    case 2: {
                        return PictureType.EMF;
                    }
                    case 3: {
                        return PictureType.WMF;
                    }
                    case 4: {
                        return PictureType.PICT;
                    }
                    case 5: {
                        return PictureType.JPEG;
                    }
                    case 6: {
                        return PictureType.PNG;
                    }
                    case 7: {
                        return PictureType.BMP;
                    }
                    case 17: {
                        return PictureType.TIFF;
                    }
                    case 18: {
                        return PictureType.JPEG;
                    }
                }
                return PictureType.UNKNOWN;
            }
            case -4070: {
                return PictureType.EMF;
            }
            case -4069: {
                return PictureType.WMF;
            }
            case -4068: {
                return PictureType.PICT;
            }
            case -4067: {
                return PictureType.JPEG;
            }
            case -4066: {
                return PictureType.PNG;
            }
            case -4065: {
                return PictureType.BMP;
            }
            case -4055: {
                return PictureType.TIFF;
            }
            case -4054: {
                return PictureType.JPEG;
            }
        }
        return PictureType.UNKNOWN;
    }

    public void writeImageContent(OutputStream out) throws IOException {
        byte[] content = this.getContent();
        if (content != null && content.length > 0) {
            out.write(content, 0, content.length);
        }
    }
}

