/*
 *  ====================================================================
 *    Licensed to the Apache Software Foundation (ASF) under one or more
 *    contributor license agreements.  See the NOTICE file distributed with
 *    this work for additional information regarding copyright ownership.
 *    The ASF licenses this file to You under the Apache License, Version 2.0
 *    (the "License"); you may not use this file except in compliance with
 *    the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS = new SlideLayout();
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 * ====================================================================
 */

package org.apache.poi.xslf.usermodel;

/**
 * Date: 11/5/11
 *
 * @author Yegor Kozlov
 */
public class SlideLayout {
    /**
     * Title layout with centered title and subtitle placeholders
     */
	public static final SlideLayout TITLE = new SlideLayout();
    /**
     * Title and text
     */
	public static final SlideLayout TEXT = new SlideLayout();

	public static final SlideLayout TWO_COL_TX = new SlideLayout();
	public static final SlideLayout TBL = new SlideLayout();
	public static final SlideLayout TEXT_AND_CHART = new SlideLayout();

    /**
     * Title, chart on left and text on right
     */
	public static final SlideLayout CHART_AND_TEXT = new SlideLayout();

	public static final SlideLayout DGM = new SlideLayout();

    /**
     * Title and chart
     */
	public static final SlideLayout CHART = new SlideLayout();

	public static final SlideLayout TX_AND_CLIP_ART = new SlideLayout();
    /**
     * Title, clipart on left, text on right
     */
	public static final SlideLayout CLIP_ART_AND_TEXT = new SlideLayout();

    /**
     * Title only
     */
	public static final SlideLayout TITLE_ONLY = new SlideLayout();

    /**
     * Blank
     */
	public static final SlideLayout BLANK = new SlideLayout();

	public static final SlideLayout TX_AND_OBJ = new SlideLayout();
	public static final SlideLayout OBJ_AND_TX = new SlideLayout();
	public static final SlideLayout OBJ_ONLY = new SlideLayout();
    /**
     * title and content
     */
	public static final SlideLayout TITLE_AND_CONTENT = new SlideLayout();
	public static final SlideLayout TX_AND_MEDIA = new SlideLayout();
	public static final SlideLayout MEDIA_AND_TX = new SlideLayout();
	public static final SlideLayout OBJ_OVER_TX = new SlideLayout();
	public static final SlideLayout TX_OVER_OBJ = new SlideLayout();
	public static final SlideLayout TX_AND_TWO_OBJ = new SlideLayout();
	public static final SlideLayout TWO_OBJ_AND_TX = new SlideLayout();
	public static final SlideLayout TWO_OBJ_OVER_TX = new SlideLayout();
	public static final SlideLayout FOUR_OBJ = new SlideLayout();
	public static final SlideLayout VERT_TX = new SlideLayout();
	public static final SlideLayout CLIP_ART_AND_VERT_TX = new SlideLayout();
	public static final SlideLayout VERT_TITLE_AND_TX = new SlideLayout();
	public static final SlideLayout VERT_TITLE_AND_TX_OVER_CHART = new SlideLayout();
	public static final SlideLayout TWO_OBJ = new SlideLayout();
	public static final SlideLayout OBJ_AND_TWO_OBJ = new SlideLayout();
	public static final SlideLayout TWO_OBJ_AND_OBJ = new SlideLayout();
	public static final SlideLayout CUST = new SlideLayout();
    /**
     * Section Header
     */
	public static final SlideLayout SECTION_HEADER = new SlideLayout();
	public static final SlideLayout TWO_TX_TWO_OBJ = new SlideLayout();
	public static final SlideLayout OBJ_TX = new SlideLayout();
    public static final SlideLayout PIC_TX = new SlideLayout();

	public static SlideLayout[] values() {
		return new SlideLayout[] { TITLE, TEXT, TWO_COL_TX, TBL,
				TEXT_AND_CHART, CHART_AND_TEXT, DGM, CHART, TX_AND_CLIP_ART,
				CLIP_ART_AND_TEXT, TITLE_ONLY, BLANK, TX_AND_OBJ, OBJ_AND_TX,
				OBJ_ONLY, TITLE_AND_CONTENT, TX_AND_MEDIA, MEDIA_AND_TX,
				OBJ_OVER_TX, TX_OVER_OBJ, TX_AND_TWO_OBJ, TWO_OBJ_AND_TX,
				TWO_OBJ_OVER_TX, FOUR_OBJ, VERT_TX, CLIP_ART_AND_VERT_TX,
				VERT_TITLE_AND_TX, VERT_TITLE_AND_TX_OVER_CHART, TWO_OBJ,
				OBJ_AND_TWO_OBJ, TWO_OBJ_AND_OBJ, CUST, SECTION_HEADER,
				TWO_TX_TWO_OBJ, OBJ_TX, PIC_TX };
	}
}
