/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */
package org.apache.poi.hwpf.model;


/**
 * Document text parts that can have text pieces (CPs)
 *
 * @author Sergey Vladimirov (vlsergey {at} gmail {dot} com)
 */

public class SubdocumentType {
	public static final SubdocumentType MAIN = new SubdocumentType();

	public static final SubdocumentType FOOTNOTE = new SubdocumentType();

	public static final SubdocumentType HEADER = new SubdocumentType();

	public static final SubdocumentType MACRO = new SubdocumentType();

	public static final SubdocumentType ANNOTATION = new SubdocumentType();

	public static final SubdocumentType ENDNOTE = new SubdocumentType();

	public static final SubdocumentType TEXTBOX = new SubdocumentType();

	public static final SubdocumentType HEADER_TEXTBOX = new SubdocumentType();

	public static final SubdocumentType[] values() {
		return new SubdocumentType[] {
	            MAIN, FOOTNOTE, HEADER, MACRO, ANNOTATION, ENDNOTE, TEXTBOX,
	            HEADER_TEXTBOX };
	}

}
