/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import org.apache.poi.hwpf.model.Ffn;
import org.apache.poi.hwpf.model.io.HWPFFileSystem;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class FontTable {
    private static final POILogger _logger;
    private short _stringCount;
    private short _extraDataSz;
    private int lcbSttbfffn;
    private int fcSttbfffn;
    private Ffn[] _fontNames = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.hwpf.model.FontTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _logger = POILogFactory.getLogger((Class)clazz);
    }

    public FontTable(byte[] buf, int offset, int lcbSttbfffn) {
        this.lcbSttbfffn = lcbSttbfffn;
        this.fcSttbfffn = offset;
        this._stringCount = LittleEndian.getShort((byte[])buf, (int)offset);
        this._extraDataSz = LittleEndian.getShort((byte[])buf, (int)(offset += 2));
        offset += 2;
        this._fontNames = new Ffn[this._stringCount];
        int i = 0;
        while (i < this._stringCount) {
            this._fontNames[i] = new Ffn(buf, offset);
            offset += this._fontNames[i].getSize();
            ++i;
        }
    }

    public short getStringCount() {
        return this._stringCount;
    }

    public short getExtraDataSz() {
        return this._extraDataSz;
    }

    public Ffn[] getFontNames() {
        return this._fontNames;
    }

    public int getSize() {
        return this.lcbSttbfffn;
    }

    public String getMainFont(int chpFtc) {
        if (chpFtc >= this._stringCount) {
            _logger.log(POILogger.INFO, (Object)"Mismatch in chpFtc with stringCount");
            return null;
        }
        return this._fontNames[chpFtc].getMainFontName();
    }

    public String getAltFont(int chpFtc) {
        if (chpFtc >= this._stringCount) {
            _logger.log(POILogger.INFO, (Object)"Mismatch in chpFtc with stringCount");
            return null;
        }
        return this._fontNames[chpFtc].getAltFontName();
    }

    public void setStringCount(short stringCount) {
        this._stringCount = stringCount;
    }

    public void writeTo(HWPFFileSystem sys) throws IOException {
        HWPFOutputStream tableStream = sys.getStream("1Table");
        this.writeTo(tableStream);
    }

    public void writeTo(HWPFOutputStream tableStream) throws IOException {
        byte[] buf = new byte[2];
        LittleEndian.putShort((byte[])buf, (short)this._stringCount);
        tableStream.write(buf);
        LittleEndian.putShort((byte[])buf, (short)this._extraDataSz);
        tableStream.write(buf);
        int i = 0;
        while (i < this._fontNames.length) {
            tableStream.write(this._fontNames[i].toByteArray());
            ++i;
        }
    }

    public boolean equals(Object o) {
        boolean retVal = true;
        if (((FontTable)o).getStringCount() == this._stringCount) {
            if (((FontTable)o).getExtraDataSz() == this._extraDataSz) {
                Ffn[] fontNamesNew = ((FontTable)o).getFontNames();
                int i = 0;
                while (i < this._stringCount) {
                    if (!this._fontNames[i].equals(fontNamesNew[i])) {
                        retVal = false;
                    }
                    ++i;
                }
            } else {
                retVal = false;
            }
        } else {
            retVal = false;
        }
        return retVal;
    }
}

