/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.poi.hwpf.model.FileInformationBlock;
import org.apache.poi.hwpf.model.LFO;
import org.apache.poi.hwpf.model.LFOData;
import org.apache.poi.hwpf.model.LSTF;
import org.apache.poi.hwpf.model.ListData;
import org.apache.poi.hwpf.model.ListFormatOverride;
import org.apache.poi.hwpf.model.ListLevel;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class ListTables {
    private static POILogger log;
    ListMap _listMap = new ListMap();
    ArrayList _overrideList = new ArrayList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.hwpf.model.ListTables");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = POILogFactory.getLogger((Class)clazz);
    }

    public ListTables() {
    }

    public ListTables(byte[] tableStream, int lstOffset, int lfoOffset) {
        ListFormatOverride lfo;
        int offset = lstOffset;
        int cLst = LittleEndian.getShort((byte[])tableStream, (int)offset);
        int levelOffset = (offset += 2) + cLst * LSTF.getSize();
        int x = 0;
        while (x < cLst) {
            ListData lst = new ListData(tableStream, offset);
            this._listMap.put(new Integer(lst.getLsid()), lst);
            offset += LSTF.getSize();
            int num = lst.numLevels();
            int y = 0;
            while (y < num) {
                ListLevel lvl = new ListLevel();
                levelOffset += lvl.read(tableStream, levelOffset);
                lst.setLevel(y, lvl);
                ++y;
            }
            ++x;
        }
        offset = lfoOffset;
        long lfoMac = LittleEndian.getUInt((byte[])tableStream, (int)offset);
        offset += 4;
        x = 0;
        while ((long)x < lfoMac) {
            lfo = new ListFormatOverride(tableStream, offset);
            offset += LFO.getSize();
            this._overrideList.add(lfo);
            ++x;
        }
        x = 0;
        while ((long)x < lfoMac) {
            lfo = (ListFormatOverride)this._overrideList.get(x);
            LFOData lfoData = new LFOData(tableStream, offset, lfo.numOverrides());
            lfo.setLfoData(lfoData);
            offset += lfoData.getSizeInBytes();
            ++x;
        }
    }

    public int addList(ListData lst, ListFormatOverride override) {
        int lsid = lst.getLsid();
        while (this._listMap.get(new Integer(lsid)) != null) {
            lsid = lst.resetListID();
            override.setLsid(lsid);
        }
        this._listMap.put(new Integer(lsid), lst);
        this._overrideList.add(override);
        return lsid;
    }

    public void writeListDataTo(FileInformationBlock fib, HWPFOutputStream tableStream) throws IOException {
        int startOffset = tableStream.getOffset();
        fib.setFcPlcfLst(startOffset);
        int listSize = this._listMap.size();
        ByteArrayOutputStream levelBuf = new ByteArrayOutputStream();
        byte[] shortHolder = new byte[2];
        LittleEndian.putShort((byte[])shortHolder, (short)((short)listSize));
        tableStream.write(shortHolder);
        Iterator iterator = this._listMap.sortedKeys().iterator();
        while (iterator.hasNext()) {
            Integer x = (Integer)iterator.next();
            ListData lst = (ListData)this._listMap.get(x);
            tableStream.write(lst.toByteArray());
            ListLevel[] lvls = lst.getLevels();
            int y = 0;
            while (y < lvls.length) {
                levelBuf.write(lvls[y].toByteArray());
                ++y;
            }
        }
        fib.setLcbPlcfLst(tableStream.getOffset() - startOffset);
        tableStream.write(levelBuf.toByteArray());
    }

    public void writeListOverridesTo(HWPFOutputStream tableStream) throws IOException {
        ListFormatOverride lfo;
        LittleEndian.putUInt((long)this._overrideList.size(), (OutputStream)tableStream);
        Iterator iterator = this._overrideList.iterator();
        while (iterator.hasNext()) {
            lfo = (ListFormatOverride)iterator.next();
            tableStream.write(lfo.getLfo().serialize());
        }
        iterator = this._overrideList.iterator();
        while (iterator.hasNext()) {
            lfo = (ListFormatOverride)iterator.next();
            lfo.getLfoData().writeTo(tableStream);
        }
    }

    public ListFormatOverride getOverride(int lfoIndex) {
        return (ListFormatOverride)this._overrideList.get(lfoIndex - 1);
    }

    public int getOverrideCount() {
        return this._overrideList.size();
    }

    public int getOverrideIndexFromListID(int lstid) {
        int returnVal = -1;
        int size = this._overrideList.size();
        int x = 0;
        while (x < size) {
            ListFormatOverride next = (ListFormatOverride)this._overrideList.get(x);
            if (next.getLsid() == lstid) {
                returnVal = x + 1;
                break;
            }
            ++x;
        }
        if (returnVal == -1) {
            throw new NoSuchElementException("No list found with the specified ID");
        }
        return returnVal;
    }

    public ListLevel getLevel(int listID, int level) {
        ListData lst = (ListData)this._listMap.get(new Integer(listID));
        if (level < lst.numLevels()) {
            ListLevel lvl = lst.getLevels()[level];
            return lvl;
        }
        log.log(POILogger.WARN, (Object)("Requested level " + level + " which was greater than the maximum defined (" + lst.numLevels() + ")"));
        return null;
    }

    public ListData getListData(int listID) {
        return (ListData)this._listMap.get(new Integer(listID));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        ListTables tables = (ListTables)obj;
        if (this._listMap.size() == tables._listMap.size()) {
            Iterator it = this._listMap.keySet().iterator();
            while (it.hasNext()) {
                ListData lst2;
                Integer key = (Integer)it.next();
                ListData lst1 = (ListData)this._listMap.get(key);
                if (lst1.equals(lst2 = (ListData)tables._listMap.get(key))) continue;
                return false;
            }
            int size = this._overrideList.size();
            if (size == tables._overrideList.size()) {
                int x = 0;
                while (x < size) {
                    if (!this._overrideList.get(x).equals(tables._overrideList.get(x))) {
                        return false;
                    }
                    ++x;
                }
                return true;
            }
        }
        return false;
    }

    private static class ListMap
    implements Map {
        private ArrayList keyList = new ArrayList();
        private HashMap parent = new HashMap();

        private ListMap() {
        }

        public void clear() {
            this.keyList.clear();
            this.parent.clear();
        }

        public boolean containsKey(Object key) {
            return this.parent.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.parent.containsValue(value);
        }

        public Object get(Object key) {
            return this.parent.get(key);
        }

        public boolean isEmpty() {
            return this.parent.isEmpty();
        }

        public Object put(Object in_key, Object in_value) {
            Integer key = (Integer)in_key;
            ListData value = (ListData)in_value;
            this.keyList.add(key);
            return this.parent.put(key, value);
        }

        public void putAll(Map map) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }

        public Object remove(Object key) {
            this.keyList.remove(key);
            return this.parent.remove(key);
        }

        public int size() {
            return this.parent.size();
        }

        public Set entrySet() {
            throw new IllegalStateException("Use sortedKeys() + get() instead");
        }

        public List sortedKeys() {
            return Collections.unmodifiableList(this.keyList);
        }

        public Set keySet() {
            throw new IllegalStateException("Use sortedKeys() instead");
        }

        public Collection values() {
            ArrayList values = new ArrayList();
            Iterator iterator = this.keyList.iterator();
            while (iterator.hasNext()) {
                Integer key = (Integer)iterator.next();
                values.add(this.parent.get(key));
            }
            return values;
        }
    }
}

