/*
 * Decompiled with CFR 0.152.
 */
package poi.support;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeUtil {
    private NodeUtil() {
    }

    public static String getTextContent(Node node) {
        StringBuffer content = new StringBuffer();
        if (node.getNodeValue() != null) {
            content.append(node.getNodeValue());
        }
        NodeList nodes = node.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node child = nodes.item(i);
            if (child.getNodeValue() != null) {
                content.append(child.getNodeValue());
            }
            if (child.getChildNodes().getLength() > 0) {
                content.append(NodeUtil.getTextContent(child));
            }
            ++i;
        }
        return new String(content);
    }

    public static void setTextContent(Node node, String content) {
        int i = 0;
        int len = node.getChildNodes().getLength();
        while (i < len) {
            node.removeChild(node.getChildNodes().item(0));
            ++i;
        }
        node.appendChild(node.getOwnerDocument().createTextNode(content));
    }
}

