//
//  AsyncConnectionGoogle.m
//  GalapagosReader
//
//  Created by Yoshitaka Sakamaki on 11/04/20.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.

#import "AsyncConnectionGoogle.h"
#import "StringExtensions.h"
#import "Constants.h"
#import "ViennaApp.h"


// Private functions
@interface AsyncConnectionGoogle (Private)
-(void)setURLString:(NSString *)newURLString;
@end

@implementation AsyncConnectionGoogle

-(BOOL)beginLoadDataFromURL:(NSURL *)theUrl
				   delegate:(id)theDelegate
			 didEndSelector:(SEL)endSelector
					 method:(NSString*)theMethod
					   body:(NSString*)theBody
{	
	delegate = theDelegate;
	handler = endSelector;
	[self setURLString:[theUrl absoluteString]];
	
	NSMutableURLRequest * theRequest = [NSMutableURLRequest requestWithURL:theUrl cachePolicy:NSURLRequestReloadIgnoringCacheData timeoutInterval:60.0];
	if (theRequest == nil)
		return NO;
	
	if (httpHeaders != nil)
	{
		for (NSString * httpFieldName in httpHeaders)
		{
			NSString * fieldValue = [httpHeaders objectForKey:httpFieldName];
			if (fieldValue != nil && ![fieldValue isBlank])
				[theRequest addValue:fieldValue forHTTPHeaderField:httpFieldName];
		}
	}
	
	// Some sites refuse to respond without a User-agent string.
	[theRequest addValue:[NSString stringWithFormat:MA_DefaultUserAgentString, [((ViennaApp *)NSApp) applicationVersion]] forHTTPHeaderField:@"User-agent"];
	
	// set method
	if (theMethod != nil)
	{
		[theRequest setHTTPMethod:theMethod];
	}
	
	// set body
	if (theBody != nil) {
		[theRequest setHTTPBody:[theBody dataUsingEncoding:NSUTF8StringEncoding]];
	}
	
	status = MA_Connect_Stopped;
	isConnectionComplete = NO;
	
	// Changed to not use the [NSURLConnection connectionWithRequest:delegate:  and then retain,
	// no sense putting it in an autorelease pool if it has no reason to be there
	connector = [[NSURLConnection alloc] initWithRequest:theRequest delegate:self];
	return connector != nil;
}

@end
