//
//  BookMarkWindow.m
//  GalapagosReader
//
//  Created by Yoshitaka Sakamaki on 平成22/03/06.
//  Copyright 2010 MyHOME. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import "BookMarkWindow.h"

@implementation BookMarkWindow
/* init
 * Initialize the class
 */
-(id)init
{
	if ((self = [super init]) != nil)
	{
		myEntryDict = nil;
		article = nil;
		viewLink = nil;
		equalToArticleListURL = NO;
		isArticleListBookmark = NO;
		isRetryBookmark = NO;
	}
	
	return self;
}

/* showBookmarkSheet
 * ブックマークウィンドウ表示処理
 */
-(void)showBookmarkSheet:(NSWindow*)window 
				 article:(Article*)theArticle
				viewLink:(NSString*)theViewLink
		  didEndSelector:(SEL)endSelector 
				delegate:(id)theDelegate
				 isRetry:(BOOL)isRetry
{	
	handler = endSelector;
	delegate = theDelegate;
	isRetryBookmark = isRetry;
	
	if (!bookmarkWindow)
		[NSBundle loadNibNamed:@"BookMark" owner:self];

	article = theArticle;
	[article retain];
	
	viewLink = theViewLink;
	[viewLink retain];
	
	//Myタグの設定
	NSArray * foldersArray = [[Database sharedDatabase] arrayOfAllFoldersHatena];
	if (0 < [foldersArray count])
	{
		NSMutableArray * tempMyTagsArray = [NSMutableArray array];
		
		for (BookmarkFolder * folder in foldersArray)
		{
			[tempMyTagsArray addObject:[folder name]];
		}
		
		//項目の並べかえ
		NSArray *myTagsArray = [tempMyTagsArray sortedArrayUsingSelector:@selector(caseInsensitiveCompare:)];
		//フィールドに設定
		[myTagsField setObjectValue:myTagsArray];
		
		//TODO:トークンフィールドの大きさを計算したいのだが、いい方法がみつからないので、
		//大雑把にタグ6項目＝１行として、フレームサイズを18づつ広げている
		/*
		 NSLog(@"%f",[myTagsField frame].size.height);
		 NSLog(@"%f",[myTagsField frame].size.width);
		 NSLog(@"%f",[myTagsField bounds].size.height);
		 NSLog(@"%f",[myTagsField bounds].size.width);
		 NSLog(@"%f",[myTagsScroll frame].size.height);
		 NSLog(@"%f",[myTagsScroll frame].size.width);
		 NSLog(@"%f",[myTagsScroll bounds].size.height);
		 NSLog(@"%f",[myTagsScroll bounds].size.width);
		 */
		float fieldHeight=0.0;
		if (0 != [myTagsArray count])
		{
			int lineCount = [myTagsArray count]/6;
			fieldHeight = lineCount*18;
		}
		NSSize fieldSize = NSMakeSize([myTagsField bounds].size.width, fieldHeight);
		[myTagsField setFrameSize:fieldSize];
	}
	
	//Sheetのオープン
	[NSApp beginSheet:bookmarkWindow
	   modalForWindow:window 
		modalDelegate:nil 
	   didEndSelector:nil 
		  contextInfo:nil];
	
	EditManagerHatena *edit = [EditManagerHatena sharedManager];
	
	NSMutableString * bookmarkURL = [NSMutableString string];
	if (viewLink == nil && article != nil)
	{
		//記事リストからのブックマークなのでフラグをONする
		isArticleListBookmark = YES;
		
		//記事リストからURLを設定
		[bookmarkURL setString:[edit getFeedURL:[article link]]];
	} else {
		//記事リストで選択している記事のURL＝現在開いているブラウザのURLか？
		if (article != nil && [viewLink hasPrefix:[edit getFeedURL:[article link]]])
		{
			//記事のURLと現在開いているブラウザのURLは同じなのでフラグをオンにする。
			equalToArticleListURL = YES;
			isArticleListBookmark = YES;
		} else {
			//現在開いているブラウザからのブックマーク登録なのでフラグをOFFにする。
			isArticleListBookmark = NO;
		}
		//ブラウザのアドレスバーからURLを設定
		[bookmarkURL setString:viewLink];
	}
		 
	//&以降のURLは切り捨て
	NSRange startRange;
	// '&'の位置を検索
	startRange= [bookmarkURL rangeOfString:@"&"];
	if (startRange.location != NSNotFound)
	{
		[bookmarkURL deleteCharactersInRange:NSMakeRange(startRange.location,
													[bookmarkURL length] - startRange.location)];
	}	
	
	//エントリー情報をはてなから取得する。
	[edit requestMyEntry:bookmarkURL
				  window:bookmarkWindow 
		  didEndSelector:@selector(completeRequestMyEntry:)
				delegate:self];		
	 
}

/* completeRequestMyEntry
 * はてなサーバからエントリー情報取得が完了された際に呼び出される。
 */
-(void)completeRequestMyEntry:(NSString*)bookmarkURL
{

	//サーバエラーまたは、ネットワーク異常だとnil
	if (nil == bookmarkURL)
	{
		[titleField setTextColor:[NSColor colorWithCalibratedHue:1.0 saturation:1.0 brightness:1.0 alpha:1.0]];
		[titleField setStringValue:@"ネットワーク異常のようです。通信状態を確認ください"];
		[addButton setEnabled:NO];
		return;
	}
	
	BOOL successFlag = YES;
	EditManagerHatena * edit = [EditManagerHatena sharedManager];
	myEntryDict = [edit getMyEntry];
	[myEntryDict retain];

	
	//myEntryDictにbookmarked_Dataがあれば登録済のブックマークとみなす。
	NSDictionary * bookmarkedDataDict = [myEntryDict objectForKey:MA_BOOKMARKED_DATA_HATENA];
	if ( nil != bookmarkedDataDict)
	{
		if ( NO == isRetryBookmark)
		{
			//ブックマーク日
			[bookmarkDateField setStringValue:
			 [NSString stringWithFormat:@"このエントリーは %@ にブックマークされました", [bookmarkedDataDict objectForKey:MA_TIMESTAMP_HATENA]]];
			[bookmarkDateField setHidden:NO];
			
			//コメント
			[commentField setStringValue:[bookmarkedDataDict objectForKey:MA_COMMENT_HATENA]];

			//登録タグ
			[tagsField setObjectValue:[bookmarkedDataDict objectForKey:MA_TAGS_HATENA]];

			
		}
		
		//削除ボタンを表示
		[deleteButton setHidden:NO];
		
		if (viewLink == nil && article != nil && NO == [article isBookmarked])
		{
			//他のアプリでブックマーク登録したようなので、ブックマークフラグをONにする。
			[[Database sharedDatabase] markArticleBookmark:[article folderId]
													  guid:[article guid] 
												isBookmark:YES];
			[article markBookmarked:YES];
		}		
	} else {
		//DBのブックマークフラグチェックする。
		if (viewLink == nil && article != nil && YES == [article isBookmarked])
		{
			//オンになっているのであれば、別のアプリケーションで登録解除したようなので、オフにする。
			[[Database sharedDatabase] markArticleBookmark:[article folderId]
													  guid:[article guid] 
												isBookmark:NO];
			[article markBookmarked:NO];
		}
	}
	
	
	//URL
	//はてなエントリで既にURLが用意されていれば、優先的に利用する。ただし、空は許さない。
	/*
	NSLog(@"%@", [entry objectForKey:MA_URL_HATENA]);
	if (nil != [entry objectForKey:MA_URL_HATENA]
		||
		NO == [[entry objectForKey:MA_URL_HATENA] isEqualToString:@""])
	{
		[urlField setStringValue:[entry objectForKey:MA_URL_HATENA]];
		[urlField setHidden:NO];
	} else {
		successFlag = NO;
	}
	 */
	/* TODO:直接対象のサーバから取得したURLを設定している。このままでいいかはそのうち判断することとする。
	 */
	[urlField setStringValue:bookmarkURL];
	[urlField setHidden:NO];

	
	//タイトル
	if (nil != [myEntryDict objectForKey:MA_TITLE_HATENA]
		&&
		NO == [[myEntryDict objectForKey:MA_TITLE_HATENA] isEqualToString:@""]) {
		NSMutableString * titleString = [NSMutableString string];
		[titleString setString:[myEntryDict objectForKey:MA_TITLE_HATENA]];
		
		//文字列："\n" "\t" があれば削除する。
		[titleString replaceOccurrencesOfString:@"\\n"
									 withString:@""
										options:NSLiteralSearch
										  range:NSMakeRange(0, [titleString length])];
		[titleString replaceOccurrencesOfString:@"\\t"
									 withString:@""
										options:NSLiteralSearch
										  range:NSMakeRange(0, [titleString length])];
		
		[titleField setStringValue:titleString];
		[addButton setEnabled:YES];
	} else {
		//直接対象のサーバへ取得しに行く。
		NSString * title = [edit getFeedTitle:bookmarkURL];
		if (NO == [title isEqualToString:@""]) {
			[titleField setStringValue:title];
			[addButton setEnabled:YES];
		} else {
			successFlag = NO;
		}
	}
	
	
	//ブックマーク数
	if ( nil != [myEntryDict objectForKey:MA_COUNT_HATENA])
	{
		[bookMarkCountField setStringValue:[NSString stringWithFormat:@"%@users", [myEntryDict objectForKey:MA_COUNT_HATENA]]];
	} else {
		[bookMarkCountField setStringValue:[NSString stringWithFormat:@"0 users"]];
	}
	[bookMarkCountField setHidden:NO];
	
	//おすすめタグ
	if ( nil != [myEntryDict objectForKey:MA_RECOMMEND_TAGS_HATENA])
	{
		NSArray * tagsArray = [myEntryDict objectForKey:MA_RECOMMEND_TAGS_HATENA];
		[recommendField setObjectValue:tagsArray];			

	}
	
	if (NO == successFlag)
	{
		[titleField setTextColor:[NSColor colorWithCalibratedHue:1.0 saturation:1.0 brightness:1.0 alpha:1.0]];
		[titleField setStringValue:@"この記事はブックマークできません"];
		[addButton setEnabled:NO];		
	}
}

-(IBAction)addBookMark:(id)sender
{		
	// timestamp が nilの場合、新規登録とする
	EditManagerHatena *edit = [EditManagerHatena sharedManager];
	if ( nil == [[myEntryDict objectForKey:MA_BOOKMARKED_DATA_HATENA] objectForKey:MA_TIMESTAMP_HATENA])
	{
		//新規追加
		[edit editBookmark:[titleField stringValue]
						  :[urlField stringValue]
						  :[commentField stringValue]
						  :[[tagsField stringValue] componentsSeparatedByString:@","]
						  :[myEntryDict objectForKey:MA_EID_HATENA]
						  :MA_Add_BookMark
						  :handler
						  :delegate
						  :isArticleListBookmark
						  :article];
		
		if (isArticleListBookmark)
		{
			//記事リストからのブックマークなので、ブックマークフラグをONにする。
			[article markBookmarked:YES];
		}

	} else {
		//更新
		[edit editBookmark:[titleField stringValue]
						  :[urlField stringValue]
						  :[commentField stringValue]
						  :[[tagsField stringValue] componentsSeparatedByString:@","]
						  :[myEntryDict objectForKey:MA_EID_HATENA]
						  :MA_Modfy_BookMark
						  :handler
						  :delegate
						  :isArticleListBookmark
						  :article];
	}
	[NSApp endSheet:bookmarkWindow];
	[bookmarkWindow orderOut:self];
}

-(IBAction)deleteBookMark:(id)sender
{
	//ブックマークフラグを解除する。
	[[EditManagerHatena sharedManager] editBookmark:[titleField stringValue]
												   :[urlField stringValue]
												   :[commentField stringValue]
												   :[[tagsField stringValue] componentsSeparatedByString:@","]
												   :[myEntryDict objectForKey:MA_EID_HATENA]
												   :MA_Delete_BookMark
												   :handler
												   :delegate
												   :isArticleListBookmark
												   :article];
	
	if (isArticleListBookmark)
	{
		//記事リストからのブックマークなので、ブックマークフラグをOFFにする。
		[article markBookmarked:NO];
	}
	
	[NSApp endSheet:bookmarkWindow];
	[bookmarkWindow orderOut:self];
}

-(IBAction)cancelBookMark:(id)sender
{
	[NSApp endSheet:bookmarkWindow];
	[bookmarkWindow orderOut:self];
}

/* tokenField
 * NSTokenFieldのデリゲートメソッド。補完候補の配列を返す。
 */
- (NSArray *)tokenField:(NSTokenField *)tokenField completionsForSubstring:(NSString *)substring indexOfToken:(NSInteger)tokenIndex indexOfSelectedItem:(NSInteger *)selectedIndex
{
	BOOL findFlag;
	//NSLog(@"%@", [tokenField stringValue]);
	//マイタグから補完候補を抽出する
	NSMutableArray *result = [NSMutableArray array];
	NSArray *myTagsArray = [[myTagsField stringValue] componentsSeparatedByString:@","];
	for (NSString * tag in myTagsArray)
	{
		if (YES == [tag hasPrefix:substring])
		{
			[result addObject:tag];
		}
	}
	
	//おすすめタグから補完候補を抽出する
	/*
	NSArray *recommendedTagsArray = [[recommendField stringValue] componentsSeparatedByString:@","];
	for (NSString * tag in recommendedTagsArray)
	{
		if (YES == [tag hasPrefix:substring])
		{
			findFlag = NO;
			//すでに設定した補完候補と重複していないか？
			for (NSString * setTag in result)
			{
				if (YES == [setTag isEqualToString:tag])
				{
					findFlag = YES;
					break;
				}
			}
			if (NO == findFlag)
				[result addObject:tag];
		}
	}
	 */
	
	//フィールドに設定されているタグと一致するものは除外する。
	NSArray *tokenFieldTagsArray = [[tokenField stringValue] componentsSeparatedByString:@","];
	for (NSString * tokenFieldTag in tokenFieldTagsArray)
	{
		int removeIndex = 0;
		findFlag = NO;
		for (NSString *resultTag in result)
		{
			if (YES == [tokenFieldTag isEqualToString:resultTag])
			{
				findFlag = YES;
				break;
			}
			removeIndex++;
		}
		if (YES == findFlag)
			[result removeObjectAtIndex:removeIndex];
		
	}
	return result;
}

/* controlTextDidChange
 * コメント欄のデリゲートメソッド。文字数をカウントし、上限に到達すると赤字でユーザに知らせる。
 */
- (void)controlTextDidChange:(NSNotification *)aNotification
{
	// コメントの文字数を設定。
	[commentLengthField setObjectValue:[NSString stringWithFormat:@"%d", [[commentField stringValue] length]]];
	if (MA_COMMENT_LENGTH_MAX_HATENA < [[commentField stringValue] length])
	{
		[commentLengthField setTextColor:[NSColor colorWithCalibratedHue:1.0 saturation:1.0 brightness:1.0 alpha:1.0]];
	} else {
		[commentLengthField setTextColor:[NSColor colorWithCalibratedHue:0.0 saturation:0.0 brightness:0.0 alpha:1.0]];
		
	}
	
	return;
}

/* keyDown
 * ボタン上にフォーカスを合わせてキーダウンすると対象の処理を行うようにしている。
 */
- (void)keyDown:(NSEvent *)theEvent
{
	unichar unicodeKey;
	unicodeKey = [ [ theEvent characters ] characterAtIndex:0 ];
	switch (unicodeKey) {
		case NSCarriageReturnCharacter:
		case NSEnterCharacter:
			if ([[self window] firstResponder] == addButton) {
				[self addBookMark:self];
			} else if ([[self window] firstResponder] == cancelButton) {
				[self cancelBookMark:self];
			} else if ([[self window] firstResponder] == deleteButton) {
				[self deleteBookMark:self];
			}
			break;
		default:
			break;
	}
}

-(void)dealloc
{
	[viewLink release];
	[article release];
	[myEntryDict release];
	[super dealloc];
}

@end
