//
//  BookmarkFolder.h
//  GalapagosReader
//
//  Created by poi-poi-caqpsule on 平成22/04/08.
//  Copyright 2010 MyHOME. All rights reserved.
//
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import <Cocoa/Cocoa.h>
#import "Folder.h"
#import "BookmarkTag.h"

#define MA_Bookmark_Folder		2
#define MA_NON_Tag_Folder		3 //その他

#define IsTagFolder(f)				(([(f) type]) == MA_Bookmark_Folder)
#define IsNonTagFolder(f)			(([(f) type]) == MA_NON_Tag_Folder)

@interface BookmarkFolder : NSObject{
	BOOL isCached;
	int itemId;
	int bookmarkCount;
	int type;
	NSMutableDictionary * attributes;
	NSMutableDictionary * cachedBookmarkTags;
}
-(id)initWithId:(int)newId name:(NSString *)newName type:(int)newType bookmarkCount:(int)count;
-(NSString *)name;
-(int)itemId;
-(int)bookmarkCount;
-(int)type;
-(void)setName:(NSString *)name;
-(BOOL)isTagFolder;
-(BOOL)isNonTagFolder;
-(void)setName:(NSString *)name;
-(void)setBookmarkCount:(int)count;
-(void)setType:(int)newType;
-(NSArray*)bookmarkTags;
-(void)addBookmarkTagsToCache:(BookmarkTag *)newBookmarkTag;
-(void)clearCache;
@end
