//
//  BookmarkTag.m
//  GalapagosReader
//
//  Created by Yoshitaka Sakamaki on 平成22/04/15.
//  Copyright 2010 MyHOME. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import "BookmarkTag.h"
#import "Database.h"

@implementation BookmarkTag
-(id)initWithId:(int)theBookmarkFolderId :(NSString *)theTagName
{
	if ((self = [super init]) != nil)
	{
		bookmarkFolderId = theBookmarkFolderId;
		isCached = NO;
		bookmarkIdArray = [[NSMutableArray array] retain];
		attributes = [[NSMutableDictionary dictionary] retain];
		cachedBookmarks = [[NSMutableDictionary dictionary] retain];
		[attributes setValue:theTagName forKey:@"Name"];
	}
	return self;
}

-(int)bookmarkFolderId
{
	return bookmarkFolderId;
}

-(NSString *)tagName
{
	return [attributes valueForKey:@"Name"];
}

-(NSArray *)bookmarks
{
	if (!isCached)
		[[Database sharedDatabase] arrayOfBookmark:bookmarkFolderId];
	return [cachedBookmarks allValues];
}

-(NSArray *)bookmarkId
{
	return bookmarkIdArray;
}

-(Bookmark *)bookmarkFromBookmarkId:(int)theBookmarkId
{
	return nil;
}

-(void)addBookmarkId:(int)theId
{
	[bookmarkIdArray addObject:[NSNumber numberWithInt:theId]];
}

/* addBookmarkToCache
 */
-(void)addBookmarkToCache:(Bookmark *)newBookmark
{
	[cachedBookmarks setObject:newBookmark 
						   forKey:[NSString stringWithFormat:@"%d", 
								   [newBookmark bookmarkRowid]]];

	isCached = YES;
}

/* dealloc
 * Clean up and release resources.
 */
-(void)dealloc
{
	[bookmarkIdArray release];
	[attributes release];
	[cachedBookmarks release];
	[super dealloc];
}

@end
