//
//  Database.h
//  Vienna
//
//  Created by Steve on Tue Feb 03 2004.
//  Copyright (c) 2004-2005 Steve Palmer. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//  2010/02/02 Yoshitaka Sakamaki : GoogleReader additional processing and synchronization


#import <Cocoa/Cocoa.h>
#import "SQLDatabase.h"
#import "Folder.h"
#import "Field.h"
#import "Criteria.h"
#import "BookmarkFolder.h"

// google_sync_flag
typedef enum {
	MA_Google_NOT_SYNC = 0,
	MA_Google_SYNC
} SyncFlagGoolge;

typedef enum {
	MA_Hatena_NOT_USE = 0,
	MA_Hatena_USE
} UseFlagHatena;

@interface Database : NSObject {
	SQLDatabase * sqlDatabase;
	BOOL initializedfoldersDict;
	BOOL initializedSmartfoldersDict;
	BOOL readOnly;
	int databaseVersion;
	int countOfUnread;
	NSThread * mainThread;
	BOOL inTransaction;
	Folder * trashFolder;
	Folder * searchFolder;
	NSString * searchString;
	NSMutableArray * fieldsOrdered;
	NSMutableDictionary * fieldsByName;
	NSMutableDictionary * fieldsByTitle;
	NSMutableDictionary * foldersDict;
	NSMutableDictionary * smartfoldersDict;
	
	BOOL initializedfoldersDictHatena;
	NSMutableDictionary * foldersDictHatena;
}

// General database functions
+(Database *)sharedDatabase;
-(BOOL)initDatabase:(NSString *)databaseFileName;
-(void)syncLastUpdate;
-(int)databaseVersion;
-(void)beginTransaction;
-(void)commitTransaction;
-(void)compactDatabase;
-(int)countOfUnread;
-(BOOL)readOnly;
-(void)close;

// Fields functions
-(void)addField:(NSString *)name type:(int)type tag:(int)tag sqlField:(NSString *)sqlField visible:(BOOL)visible width:(int)width;
-(NSArray *)arrayOfFields;
-(Field *)fieldByName:(NSString *)name;

// Folder functions
-(void)initFolderArray;
-(int)firstFolderId;
-(int)trashFolderId;
-(int)searchFolderId;
-(NSArray *)arrayOfAllFolders;
-(NSArray *)arrayOfFolders:(int)parentId;
-(Folder *)folderFromID:(int)wantedId;
-(Folder *)folderFromFeedURL:(NSString *)wantedFeedURL;
-(Folder *)folderFromName:(NSString *)wantedName;
-(int)addFolder:(int)parentId afterChild:(int)predecessorId folderName:(NSString *)name type:(int)type canAppendIndex:(BOOL)canAppendIndex;
-(BOOL)deleteFolder:(int)folderId;
-(BOOL)setFolderName:(int)folderId newName:(NSString *)newName;
-(BOOL)setFolderDescription:(int)folderId newDescription:(NSString *)newDescription;
-(BOOL)setFolderHomePage:(int)folderId newHomePage:(NSString *)newLink;
-(BOOL)setFolderFeedURL:(int)folderId newFeedURL:(NSString *)newFeedURL;
-(BOOL)setFolderUsername:(int)folderId newUsername:(NSString *)name;
-(void)purgeDeletedArticles;
-(void)purgeArticlesOlderThanDays:(int)daysToKeep;
-(BOOL)markFolderRead:(int)folderId;
-(void)clearFolderFlag:(int)folderId flagToClear:(unsigned int)flag;
-(void)setFolderFlag:(int)folderId flagToSet:(unsigned int)flag;
-(void)setFolderUnreadCount:(Folder *)folder adjustment:(int)adjustment;
-(void)setFolderLastUpdate:(int)folderId lastUpdate:(NSDate *)lastUpdate;
-(void)setFolderLastUpdateString:(int)folderId lastUpdateString:(NSString *)lastUpdateString;
-(BOOL)setParent:(int)newParentID forFolder:(int)folderId;
-(BOOL)setFirstChild:(int)childId forFolder:(int)folderId;
-(BOOL)setNextSibling:(int)nextSiblingId forFolder:(int)folderId;
-(BOOL)setBloglinesId:(int)folderId newBloglinesId:(long)bloglinesId;
-(void)handleAutoSortFoldersTreeChange:(NSNotification *)notification;
-(void)initFolderArrayHatena;
-(BookmarkFolder *)folderFromNameHatena:(NSString *)wantedName;
-(NSArray *)arrayOfAllFoldersHatena;
-(BookmarkFolder *)bookmarkFolderFromID:(int)wantedId;
-(void)arrayOfBookmarkTag:(int)bookmarkFolderId;
-(NSArray *)arrayOfBookmark:(int)bookmarkFolderId;


// RSS folder functions
+(NSString *)untitledFeedFolderName;
-(int)addRSSFolder:(NSString *)feedName underParent:(int)parentId afterChild:(int)predecessorId subscriptionURL:(NSString *)url;
-(int)addRSSFolderGoogle:(NSString *)feedName underParent:(int)parentId afterChild:(int)predecessorId subscriptionURL:(NSString *)url;

// Search folder functions
-(void)setSearchString:(NSString *)newSearchString;

// Smart folder functions
-(void)initSmartfoldersDict;
-(int)addSmartFolder:(NSString *)folderName underParent:(int)parentId withQuery:(CriteriaTree *)criteriaTree;
-(BOOL)updateSearchFolder:(int)folderId withFolder:(NSString *)folderName withQuery:(CriteriaTree *)criteriaTree;
-(CriteriaTree *)searchStringForSmartFolder:(int)folderId;
-(NSString *)criteriaToSQL:(CriteriaTree *)criteriaTree;

// Article functions
-(BOOL)createArticle:(int)folderID article:(Article *)article guidHistory:(NSArray *)guidHistory;
-(BOOL)deleteArticle:(int)folderId guid:(NSString *)guid;
-(NSArray *)arrayOfUnreadArticles:(int)folderId;
-(NSArray *)arrayOfArticles:(int)folderId filterString:(NSString *)filterString;
-(void)markArticleRead:(int)folderId guid:(NSString *)guid isRead:(BOOL)isRead notifyFlag:(BOOL)notifyFlag;
-(void)markArticleFlagged:(int)folderId guid:(NSString *)guid isFlagged:(BOOL)isFlagged;
-(void)markArticleDeleted:(int)folderId guid:(NSString *)guid isDeleted:(BOOL)isDeleted;
-(BOOL)isTrashEmpty;
-(NSArray *)guidHistoryForFolderId:(int)folderId;
-(void)markArticleBookmark:(int)folderId guid:(NSString *)guid isBookmark:(BOOL)isBookmark;
-(BOOL)setGoogleSyncFlag:(int)folderId newGoogleSyncFlag:(int)googleSyncFlag;
-(BOOL)startup;
-(BOOL)syncFlagGoogleInfo;
-(BOOL)useFlagHatenaInfo;
-(void)updateStartup;
-(void)updateSyncFlagGoogleInfo:(SyncFlagGoolge)syncFlag;
-(void)updateSyncFlagGoogleRssFolders;
-(void)updateUseFlagHatenaInfo:(UseFlagHatena)useFlag;
-(void)addHatenaBookMark:(NSString*)pageURL
					   :(NSString*)title
					   :(NSString*)comment
					   :(NSString*)search
					   :(NSString*)date
					   :(NSArray*)tags;

-(int)addFolderHatena:(NSString *)name;

-(NSString*)getTimeStampHatena;

-(void)updateBookMark:(NSString*)bookmarkURL
					 :(NSString*)title
					 :(NSString*)search
					 :(NSString*)tagsAndComment
					 :(NSArray*)tagsArray;
-(void)deleteBookmark:(NSString*)bookmarkURL;
-(void)deleteAllBookmark;
-(void) countBookmark;
-(void)updateStarItem:(int)starFolderId :(NSString*)guid;
-(Folder*)starItemFolder;
-(void)updateLastRefreshDate;
-(NSString*)getLastRefreshDate;
@end
