//
//  EditManagerHatena.h
//  GalapagosReader
//
//  Created by Yoshitaka Sakamaki on 平成22/03/06.
//  Copyright 2010 MyHOME. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import <Cocoa/Cocoa.h>
#import "EditManagerBase.h"
#import "AccountManager.h"
#import "DataExtensions.h"
#import "Database.h"
#import "LoginControllerHatena.h"
#import "JSON.h"


extern NSString * MA_IS_PRIVATE_HATENA;
extern NSString * MA_FAVORITES_HATENA;
extern NSString * MA_COUNT_HATENA;
extern NSString * MA_RECOMMEND_TAGS_HATENA;
extern NSString * MA_EID_HATENA;
extern NSString * MA_BOOKMARKED_DATA_HATENA;
extern NSString * MA_COMMENT_RAW_HATENA;
extern NSString * MA_TIMESTAMP_HATENA;
extern NSString * MA_COMMENT_HATENA;
extern NSString * MA_PRIVATE_HATENA;
extern NSString * MA_USER_HATENA;
extern NSString * MA_PERMALINK_HATENA;
extern NSString * MA_TAGS_HATENA;
extern NSString * MA_ENTRY_URL_HATENA;
extern NSString * MA_ORIGINAL_URL_HATENA;
extern NSString * MA_TITLE_LAST_EDITOR_HATENA;
extern NSString * MA_URL_HATENA;
extern NSString * MA_TITLE_HATENA;
extern NSString * MA_HAS_ASIN_HATENA;

typedef enum {
	MA_Add_BookMark = 0,
	MA_Modfy_BookMark,
	MA_Delete_BookMark
} BookMarkKind;

typedef enum {
	MA_Sync_AllRecord = 0,
	MA_Sync_NewRecord
} SyncKind;

@interface EditManagerHatena : EditManagerBase {
	id delegateEditBookmark;
	SEL handlerEditBookmark;
	id delegateMyEntry;
	SEL handlerMyEntry;
	BOOL useFlagHatenaInfo;
	BOOL articleSyncFlag;
}
+(EditManagerHatena *)sharedManager;
- (void)syncBookmark:(SyncKind)kind :(BOOL)theArticleSyncFlag;
- (void)editBookmark:(NSString*)title
					:(NSString*)bookmarkURL
					:(NSString*)comment
					:(NSArray*)tagsArray
					:(NSString*)eid
					:(BookMarkKind)kind
					:(SEL)endSelector 
					:(id)theDelegate
					:(BOOL)isArticleListBookmark
					:(Article*)article;
-(void)requestMyEntry:(NSString *)bookmarkURL 
			   window:(NSWindow*)window 
	   didEndSelector:(SEL)endSelector 
			 delegate:(id)theDelegate;
- (NSDictionary*)getMyEntry;
- (HttpResult)login;
- (BOOL)useFlagHatena;
- (BOOL)articleSync;
@end


