//
//  EditManagerHatena.m
//  GalapagosReader
//
//  Created by Yoshitaka Sakamaki on 平成22/03/06.
//  Copyright 2010 MyHOME. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import "EditManagerHatena.h"

// Singleton
static EditManagerHatena * _editManager = nil;
static NSMutableString * reciveString = nil;
NSMutableDictionary  *credentials;
NSDateFormatter      *dateFormatter;
NSString *username;
NSString *password;
NSString *created;

NSString * MA_IS_PRIVATE_HATENA = @"is_private";
NSString * MA_FAVORITES_HATENA = @"favorites";
NSString * MA_COUNT_HATENA = @"count";
NSString * MA_RECOMMEND_TAGS_HATENA = @"recommend_tags";
NSString * MA_EID_HATENA = @"eid";
NSString * MA_BOOKMARKED_DATA_HATENA = @"bookmarked_data";
NSString * MA_COMMENT_RAW_HATENA = @"comment_raw";
NSString * MA_TIMESTAMP_HATENA = @"timestamp";
NSString * MA_COMMENT_HATENA = @"comment";
NSString * MA_PRIVATE_HATENA = @"private";
NSString * MA_USER_HATENA = @"user";
NSString * MA_PERMALINK_HATENA = @"permalink";
NSString * MA_TAGS_HATENA = @"tags";
NSString * MA_ENTRY_URL_HATENA = @"entry_url";
NSString * MA_ORIGINAL_URL_HATENA = @"original_url";
NSString * MA_TITLE_LAST_EDITOR_HATENA = @"title_last_editor";
NSString * MA_URL_HATENA = @"url";
NSString * MA_TITLE_HATENA = @"title";
NSString * MA_HAS_ASIN_HATENA = @"has_asin";

@interface EditManagerHatena  (Private)
- (void) getBookmarkList:(NSURL*)url;
- (NSString *) getX_WSSE;
- (NSDictionary *) createHttpHeader;
- (NSArray *) parseTags:(NSString*) tags;
- (void) notifyEditBookmark:(NSMutableDictionary*)bookmarkDict;
- (void) handleUseFlagUpdate:(NSNotification *)nc;
- (void) deleteLoginCookie;
- (void) connectMyEntry:(NSString*)bookmarkURL;
- (void) handleSetBookmarkList:(NSString *)bookMarkList;
@end


@implementation EditManagerHatena

- (id)init
{
    if (![super init]) {
        return nil;
    }
	username = nil;
	password = nil;
	created = nil;	
	NSNotificationCenter * nc = [NSNotificationCenter defaultCenter];
	[nc addObserver:self selector:@selector(handleUseFlagUpdate:) name:@"MA_Notify_UseFlagUpdate_Info" object:nil];
	useFlagHatenaInfo = [[Database sharedDatabase] useFlagHatenaInfo];	
    credentials = [NSMutableDictionary dictionary];
    dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"yyyy-MM-dd'T'HH:mm:sszzz"];
    [dateFormatter setLocale:[[[NSLocale alloc] initWithLocaleIdentifier:@"US"] autorelease]];
	reciveString = [[NSMutableString string] retain];
	articleSyncFlag = NO;
    return self;
}

/* sharedManager
 * Returns the single instance of the refresh manager.
 */
+(EditManagerHatena *)sharedManager
{
	if (!_editManager)
		_editManager = [[EditManagerHatena alloc] init];
	if (username)
		[username release];
	if (password)
		[password release];
	if (created)
		[created release];
	
	username = [[[AccountManager sharedManager] getAccountNameHatena] retain];
	password = [[[AccountManager sharedManager] getPasswordHatena] retain];
    created = [[dateFormatter stringFromDate:[NSDate date]] retain];	
	return _editManager;
}

/*
 * HatenaBookmarkへのログイン及び、Cookie設定。
 */
- (HttpResult)login
{
	//既存のログインCookieを削除
	[self deleteLoginCookie];

	NSString* body = [NSString
					  stringWithFormat:
					  @"name=%@&password=%@&persistent=1&location=http://b.hatena.ne.jp/"
					  ,username,password];
	
	NSURL* url = [NSURL URLWithString:@"https://www.hatena.ne.jp/login"];
	NSData* reciveData;
		
	HttpResult ret;
	ret = [self httpRequest:@"POST" 
						url:url
				 reciveData:&reciveData
					   body:body];
	
	if (Ret_403NG == ret)
	{
		return Ret_403NG;
	} else if (RetNG == ret) {
		return RetNG;
	}
	
	/* 注意:はてなは間違ったパスワードでも200OKを返すようだ。。
	 * ログインクッキーが取得できたかを判断して存在しなければ、Ret_403NGを返すようにする。
	 */
	BOOL findLoginCookie = NO;
	//BOOL findUser = NO;
	NSURL* hosturl = [NSURL URLWithString:@"https://b.hatena.ne.jp"];
	NSHTTPCookieStorage *storage = [NSHTTPCookieStorage sharedHTTPCookieStorage];
	NSArray *cookiesArray = [storage cookiesForURL:hosturl];
	for (NSHTTPCookie * cookie in cookiesArray)
	{		
		if ([[cookie name] isEqualToString:@"rk"])
		{
			if (Ret_200OK == ret)
				findLoginCookie = YES;
		}
	}
	
	if (YES == findLoginCookie)
		return Ret_200OK;
	else
		return Ret_403NG;
}


- (void)getBookmarkList:(NSURL*)url
{
	NSAutoreleasePool* pool;	
    pool = [[NSAutoreleasePool alloc]init];

	NSURL* hosturl = [NSURL URLWithString:@"http://b.hatena.ne.jp"];
	NSData* reciveData;
	HttpResult reciveBookmarkListRet = RetNG;
	do {
		//ログインクッキーを取得する
		NSHTTPCookieStorage *storage = [NSHTTPCookieStorage sharedHTTPCookieStorage];
		NSArray *cookiesArray = [storage cookiesForURL:hosturl];
		NSString * cookieString = nil;
		for (NSHTTPCookie * cookie in cookiesArray)
		{
			if ([[cookie name] isEqualToString:@"rk"])
			{
				cookieString = [NSString stringWithFormat:@"rk=%@", [cookie value]];
				break;
			}							
		}
		
		if (nil != cookieString)
		{
			NSDictionary * header = [NSDictionary dictionaryWithObjectsAndKeys:
									 @"b.hatena.ne.jp", @"Host",
									 @"GalapagosReader", @"User-Agent",
									 @"gzip, deflate", @"Accept-Encoding",
									 cookieString, @"cookie",//ログインクッキーをヘッダにセットする。
									 nil
									 ];
			
			reciveBookmarkListRet = [self httpRequest:@"GET"
												  url:url
										   reciveData:&reciveData
											   header:header];			
		}
		
		if (Ret_403NG == reciveBookmarkListRet || Ret_400NG == reciveBookmarkListRet || nil == cookieString)
		{
			//再ログイン処理を行えるよう通知
			[[NSNotificationCenter defaultCenter]
			 postNotificationName:@"MA_Notify_ChangeAccountHatena" object:nil];
			
			BOOL loginSuccess = [[LoginControllerHatena sharedManager] loginHatena];
			if (!loginSuccess)
				break;
		}
	}  while (Ret_403NG == reciveBookmarkListRet ||
			  Ret_400NG == reciveBookmarkListRet ||
			  RetNG == reciveBookmarkListRet);

	if (Ret_200OK == reciveBookmarkListRet) {
		//return [[NSString alloc] initWithData:reciveData encoding:NSUTF8StringEncoding];
		
		[[NSRunLoop mainRunLoop] performSelector:@selector(handleSetBookmarkList:)
										  target:self 
										argument:[[NSString alloc] initWithData:reciveData encoding:NSUTF8StringEncoding] 
										   order:0 
										   modes:[NSArray arrayWithObjects:NSDefaultRunLoopMode, nil]];	
		
	} else {
		//return @"";
		[[NSRunLoop mainRunLoop] performSelector:@selector(handleSetBookmarkList:)
										  target:self 
										argument:@""
										   order:0 
										   modes:[NSArray arrayWithObjects:NSDefaultRunLoopMode, nil]];			
	}
	
	[url release];
	[pool release];
	[NSThread exit];

}

/* getX_WSSE
 * X_WSSEヘッダの生成
 */
- (NSString *)getX_WSSE
{
	
	srand(time(nil));
    NSString *tmpNonce = [
						  [NSString stringWithFormat:@"%@%d", created, rand()]
						  stringByEncodingSHA1Hex
						  ];
	
	NSString *passwordDigest = [
								[[NSString stringWithFormat:@"%@%@%@", tmpNonce, created, password]
								 dataByEncodingSHA1
								 ]
								stringByEncodingBase64
								];
	
    NSString *nonce = [[tmpNonce dataUsingEncoding:NSASCIIStringEncoding] stringByEncodingBase64];
	
	
	return [NSString stringWithFormat:@"UsernameToken Username=\"%@\", "
									  @"PasswordDigest=\"%@=\", "
									  @"Nonce=\"%@\", Created=\"%@\"",
									  username, passwordDigest, nonce, created
			];
}

/* createHttpHeader
 * HTTPヘッダーの生成
 */
- (NSDictionary *) createHttpHeader
{
	if (httpHeader)
		return httpHeader;
	
	httpHeader = [[NSDictionary dictionaryWithObjectsAndKeys:
				   @"b.hatena.ne.jp", @"Host",
				   @"GalapagosReader", @"User-Agent",
				   @"gzip, deflate", @"Accept-Encoding",
				   [self getX_WSSE] ,@"X-WSSE",
				   nil
				   ] retain];
	
	return httpHeader;
}

/* requestMyEntry
 * マイエントリー取得依頼
 */
-(void)requestMyEntry:(NSString *)bookmarkURL 
			   window:(NSWindow*)window 
	   didEndSelector:(SEL)endSelector 
			 delegate:(id)theDelegate
{	
	delegateMyEntry = theDelegate;
	handlerMyEntry = endSelector;
	
	[NSThread detachNewThreadSelector:@selector(connectMyEntry:)
							 toTarget:self 
						   withObject:[bookmarkURL retain]];
}

/* connectMyEntry
 * ネットワークに接続し、エントリー情報を取得する
 */
-(void)connectMyEntry:(NSString*)bookmarkURL
{
	NSAutoreleasePool* pool;	
    pool = [[NSAutoreleasePool alloc]init];
	
	NSURL* url = [NSURL URLWithString:
				  [NSString stringWithFormat:@"http://b.hatena.ne.jp/my.entry?url=%@", bookmarkURL]];

	NSData* reciveData;
	NSDictionary * header = [self createHttpHeader];
	HttpResult result = [self httpRequest:@"GET"
									  url:url
							   reciveData:&reciveData
								   header:header];
	if (Ret_200OK == result)
	{
		[reciveString setString:
		 [[[NSString alloc] initWithData:reciveData encoding:NSUTF8StringEncoding] autorelease]
		 ];
		
		[[NSRunLoop mainRunLoop] performSelector:handlerMyEntry 
										  target:delegateMyEntry 
										argument:bookmarkURL 
										   order:0 
										   modes:[NSArray arrayWithObjects:NSDefaultRunLoopMode, nil]];	
	} else {
		//取得失敗は引数にnilを設定する
		[[NSRunLoop mainRunLoop] performSelector:handlerMyEntry 
										  target:delegateMyEntry 
										argument:nil 
										   order:0 
										   modes:[NSArray arrayWithObjects:NSDefaultRunLoopMode, nil]];			
	}
	[bookmarkURL release];
	[pool release];
	[NSThread exit];
}

/* myEntry
 * 取得したエントリー情報を返す
 */
-(NSDictionary *)getMyEntry
{
	
	NSDictionary *result = [reciveString JSONValue];
	//NSLog(@"%@", result);
	
	return result;
}

/* notifyEditBookmark
 * はてなブックマークへブックマークの登録・更新・削除を依頼
 * ・ブックマークの新規登録 (POST)
 * ・タイトル / コメントの編集 (PUT)
 * ・ブックマークの削除 (DELETE) 
 */
- (void)notifyEditBookmark:(NSMutableDictionary*)bookmarkDict
{
	NSAutoreleasePool* pool;	
    pool = [[NSAutoreleasePool alloc]init];

	NSString * method = [bookmarkDict objectForKey:@"Method"];
	NSString * title = [bookmarkDict objectForKey:@"Title"];
	NSString * bookmarkURL = [bookmarkDict objectForKey:@"BookmarkURL"];
	NSString * comment = [bookmarkDict objectForKey:@"TagAndComment"];
	NSDictionary * header = [self createHttpHeader];
	
	NSString * eid = [bookmarkDict objectForKey:@"Eid"];
	if (nil == eid)
	{
		/* アカウントがプライベートモードかつ、他のアプリでログインすると、
		 * 認証エラーになるので、その場合はログインしなおす。
		 * 別スレッドでの動作なので、[[LoginControllerHatena sharedManager] loginHatena]を呼び出せないことに注意
		 */
		eid = @"";
		[self login];
	}
	
	NSURL* url;
	NSString* body;
	if ([method isEqualToString:@"POST"])
	{
		//新規登録
		url = [NSURL
			   URLWithString:
			   [NSString stringWithFormat:@"http://b.hatena.ne.jp/atom/post"]
			   ];
				
		body = [NSString
				stringWithFormat:
				@"<entry xmlns=\"http://purl.org/atom/ns#\">"
				@"<link rel=\"related\" type=\"text/html\" href=\"%@\" />"
				@"<summary type=\"text/plain\">%@</summary>"
				@"</entry>"
				,bookmarkURL ,comment];
		
	} else {
		//更新または、削除
		url = [NSURL
			   URLWithString:
			   [NSString stringWithFormat:@"http://b.hatena.ne.jp/atom/edit/%@", eid]
			   ];
		
		
		body = [NSString
				stringWithFormat:
				@"<entry xmlns=\"http://purl.org/atom/ns#\">"
				@"<title>%@</title>"
				@"<link rel=\"related\" type=\"text/html\" href=\"%@\" />"
				@"<summary type=\"text/plain\">%@</summary>"
				@"</entry>"
				, title, bookmarkURL ,comment];		
	}
	NSData* reciveData;
	HttpResult result = [self httpRequest_NonURLEncoding:method
													 url:url 
											  reciveData:&reciveData
												  header:header
													body:body];
	
	// 更新・削除＝200ok 新規＝201okがそれぞれ返ってくる。
	if (Ret_200OK == result || Ret_201OK == result)
	{
		[bookmarkDict setObject:@"RetOK" forKey:@"HttpResult"];
	} else {
		[bookmarkDict setObject:@"RetNG" forKey:@"HttpResult"];
	}
	
	//AppControllerのhandleComplateBookmarkを呼び出す
	[[NSRunLoop mainRunLoop] performSelector:handlerEditBookmark 
									  target:delegateEditBookmark 
									argument:bookmarkDict 
									   order:0 
									   modes:[NSArray arrayWithObjects:NSDefaultRunLoopMode, nil]];	
	
	[pool release];
	[NSThread exit];
}

/* editBookmark
 * ブックマークの編集
 */
- (void)editBookmark:(NSString*)title
					:(NSString*)bookmarkURL
					:(NSString*)comment
					:(NSArray*)tagsArray
					:(NSString*)eid
					:(BookMarkKind)kind
					:(SEL)endSelector 
					:(id)theDelegate
					:(BOOL)isArticleListBookmark
					:(Article*)article
{
	handlerEditBookmark = endSelector;
	delegateEditBookmark = theDelegate;

	NSMutableString * tagAndComment = [NSMutableString string];
	
	// タグを正式な形式に変換し連結する
	for (NSString * tag in tagsArray)
	{
		if (NO == [tag isEqualToString:@""])
			[tagAndComment appendString:[NSString stringWithFormat:@"[%@]", tag]];
	}
	
	// コメントを連結
	[tagAndComment appendString:comment];
	
	//ブックマーク処理の種別を設定する。
	NSString * method;
	if (MA_Delete_BookMark == kind)
	{
		//ブックマーク削除
		method = [NSString stringWithFormat:@"DELETE"];
	} else if (MA_Modfy_BookMark == kind) {
		//更新
		method = [NSString stringWithFormat:@"PUT"];
	} else {
		//新規追加
		method = [NSString stringWithFormat:@"POST"];
	}
	
	//記事リストからの登録か？ブラウザからの登録かエンドセレクタがわかるようにしておく。
	NSString * bookmarkKind;
	if (isArticleListBookmark)
	{
		bookmarkKind = [NSString stringWithFormat:@"ArticleList"];
	} else {
		bookmarkKind = [NSString stringWithFormat:@"Browser"];
	}
	
	NSMutableDictionary * bookmarkDict = [NSMutableDictionary dictionaryWithObjectsAndKeys:
										  method, @"Method",
										  title, @"Title",
										  bookmarkURL, @"BookmarkURL",
										  //comment, @"Comment",
										  tagAndComment, @"TagAndComment",
										  eid, @"Eid",
										  tagsArray, @"TagsArray",
										  bookmarkKind, @"BookmarkKind",
										  article, @"Article",
										  nil];		
	
	[NSThread detachNewThreadSelector:@selector(notifyEditBookmark:)
							 toTarget:self 
						   withObject:bookmarkDict];
}

/* syncBookmark
 * ブックマークリストの同期
 */
- (void)syncBookmark:(SyncKind)kind :(BOOL)theArticleSyncFlag
{
	if (NO == useFlagHatenaInfo)
		return;

	
	//記事とブックマークのリンク実施フラグの設定
	articleSyncFlag = theArticleSyncFlag;
		
	NSURL* url;
	if (MA_Sync_AllRecord == kind) //すべてのブックマークを同期
	{
		url = [NSURL URLWithString: 
			   [NSString stringWithFormat:@"http://b.hatena.ne.jp/%@/search.data", username]];
		
		// 全同期なら既存の登録されたブックマークフォルダを削除。
		[[Database sharedDatabase] deleteAllBookmark];

	} else { //日付指定でブックマークを同期
		//unixtimeの算出
		NSMutableString * nowUnixTime = [NSMutableString stringWithFormat:@"%0.3f"
										 , [[NSDate date] timeIntervalSince1970]];
		[nowUnixTime replaceOccurrencesOfString:@"."
									 withString:@""
										options:NSLiteralSearch
										  range:NSMakeRange(0, [nowUnixTime length])];
				
		//ブックマークの中で最も最新のタイムスタンプを取得
		Database *db = [Database sharedDatabase];
		NSString * timestamp = [db getTimeStampHatena];
		url = [NSURL URLWithString:
			   [NSString stringWithFormat:@"http://b.hatena.ne.jp/%@/search.data?timestamp=%@&_now=%@",
				username, timestamp, nowUnixTime]];		
	}
	
	[NSThread detachNewThreadSelector:@selector(getBookmarkList:)
							 toTarget:self 
						   withObject:[url retain]];
	
	//NSString * bookMarkList = [self getBookmarkList:url];
	
	//NSLog(@"%@", bookMarkList);
}


/* handleSetBookmarkList
 * ブックマークリスト取得後に呼び出される。
 */
- (void) handleSetBookmarkList:(NSString *)bookMarkList
{
	typedef enum {
		Title = 0,
		TagsAndComment,
		PageURL,
		Date
	} BookMarks;
	
	int listLength = [bookMarkList length];
	if (0 == listLength){
		[bookMarkList release];
		return;
	}
	
	NSRange range, subrange;
	range = NSMakeRange(0, listLength);
	NSString * parsedString;
	NSMutableArray * tmpBookMarkListArray = [NSMutableArray array];
	NSMutableArray * bookMarkListArray = [NSMutableArray array];
    while(range.length > 0) {
        subrange = [bookMarkList lineRangeForRange:NSMakeRange(range.location, 0)];
        parsedString = [bookMarkList substringWithRange:subrange];
        
        [tmpBookMarkListArray addObject:parsedString];
		
        range.location = NSMaxRange(subrange);
        range.length -= subrange.length;
    }
	
	//NSLog(@"%@", tmpBookMarkListArray);
	//NSLog(@"%d", [tmpBookMarkListArray count]);
	
	int count;
	int itemCount = 0;
	int bookMarkItemMax = [tmpBookMarkListArray count] * 3 / 4;
	NSMutableString * searchString = [NSMutableString string];
	NSMutableArray * searchStringArray = [NSMutableArray array];
	NSMutableArray * tagsArray = [NSMutableArray array];
	NSMutableDictionary * bookMarksDict = [NSMutableDictionary dictionary];
	NSMutableString * tempString = [NSMutableString string];
	for (count = 0; count < bookMarkItemMax; count++)
	{
		[tempString setString:[tmpBookMarkListArray objectAtIndex:count]];
		//改行を削除
		[tempString replaceOccurrencesOfString:@"\n"
									withString:@""
									   options:NSLiteralSearch
										 range:NSMakeRange(0, [tempString length])];
		
		switch (itemCount)
		{
			case Title:
				//タブを削除
				[tempString replaceOccurrencesOfString:@"\t"
											withString:@""
											   options:NSLiteralSearch
												 range:NSMakeRange(0, [tempString length])];
				
				[bookMarksDict setObject:[NSString stringWithString:tempString] forKey:@"title"];
				
				// 検索用の文字列を保存
				[searchString setString:[NSString stringWithFormat:@"%@\n",tempString]];
				itemCount++;
				break;
				
			case TagsAndComment:
				[bookMarksDict setObject:[NSString stringWithString:tempString] forKey:@"comment"];
				
				// タグを分解して配列に保存しておく
				[tagsArray addObject:[self parseTags:tempString]];
				
				// 検索用の文字列を既存の文字列の末尾に設定
				[searchString appendString:[NSString stringWithFormat:@"%@\n",tempString]];
				itemCount++;
				break;
				
			case PageURL:				
				[bookMarksDict setObject:[NSString stringWithString:tempString] forKey:@"url"];
				
				// 検索用の文字列を既存の文字列の末尾に設定。そしてオブジェクトに保存する
				[searchString appendString:tempString];
				//[searchStringArray addObject:[searchString copy]];
				[searchStringArray addObject:[NSString stringWithString:searchString]];
				
				// まとめたブックマーク情報を保存
				[bookMarkListArray addObject:[bookMarksDict copy]];
				//[bookMarkListArray addObject:bookMarksDict];
				
				// ゼロに戻しておく。
				itemCount = 0;
				break;
				
		}
	}
	
	// 日付を配列にセットしておく
	NSMutableArray * dateArray = [NSMutableArray array];
	NSString * delimiter = @"\t";
	for (count = 0; count < [bookMarkListArray count]; count++)
	{
		//NSLog(@"%@", [tmpBookMarkListArray objectAtIndex:(bookMarkItemMax + count)]);
		NSArray * temp = [[tmpBookMarkListArray objectAtIndex:(bookMarkItemMax + count)] componentsSeparatedByString:delimiter];
		[dateArray addObject:[[temp objectAtIndex:1] substringToIndex:[[temp objectAtIndex:1] length]]];
	}
	
	// ブックマークをデータベースに登録する。
	Database * db = [Database sharedDatabase];
	count = 0;
	for (NSDictionary * bookMark in bookMarkListArray)
	{	
		[db addHatenaBookMark:[bookMark objectForKey:@"url"]
							 :[bookMark objectForKey:@"title"]
							 :[bookMark objectForKey:@"comment"]
							 :[searchStringArray objectAtIndex:count]
							 :[dateArray objectAtIndex:count]
							 :[tagsArray objectAtIndex:count]
		 ];
		count++;
	}
	
	// 各ブックマークフォルダのブックマーク数を集計する。
	if (0 < [bookMarkListArray count])
		[db countBookmark];
	
	[bookMarkList release];
	
}

/* parseTags
 * タグを分解して配列にして返却する
 */
- (NSArray *) parseTags:(NSString*) tags
{
	if ([tags length] == 0)
		return nil;
	
	NSString * delimiter = @"]";
	NSMutableArray * tagsArray = [NSMutableArray array];
	
	NSString * line = [tags substringToIndex:[tags length]];
	if (YES == [line isEqualToString:@""])
	{
		// タグもコメントも含まれていない。
		[tagsArray addObject:@""];
		return tagsArray;
	}
		
	NSArray * tempTagsArray = [tags componentsSeparatedByString:delimiter];

	if (1 == [tempTagsArray count])
	{
		// タグが含まれていない（コメントのみ）
		[tagsArray addObject:@""];
		return tagsArray;
	}
	
	int count = 0;
	// 要素数分-1ループ(-1にしているのはコメント&改行コードが含まれる要素を除くため)
	for (; count < [tempTagsArray count] - 1; count++)
	{
		//NSLog(@"%@", [[tempTagsArray objectAtIndex:count] substringFromIndex:1]);
		// 先頭の"["を取り除いた文字列を配列に追加する。
		[tagsArray addObject:[[tempTagsArray objectAtIndex:count] substringFromIndex:1]];
	}
	
	return tagsArray;
}

/* handleSyncFlagUpdate
 * infoテーブルの同期フラグに変更があれば、DBから取得し直します。
 */
-(void)handleUseFlagUpdate:(NSNotification *)nc
{
	useFlagHatenaInfo = [[Database sharedDatabase] useFlagHatenaInfo];
}

-(BOOL)useFlagHatena
{
	return useFlagHatenaInfo;
}

/* deleteLoginCookie
 * ログインCookieの削除
 */
-(void)deleteLoginCookie
{
	NSURL* hosturl = [NSURL URLWithString:@"https://b.hatena.ne.jp"];
	NSHTTPCookieStorage *storage = [NSHTTPCookieStorage sharedHTTPCookieStorage];
	NSArray *cookiesArray = [storage cookiesForURL:hosturl];
	for (NSHTTPCookie * cookie in cookiesArray)
	{
		if ([[cookie name] isEqualToString:@"rk"])
		{
			[storage deleteCookie:cookie];
		}
	}	
}

-(void)dealloc
{
	[dateFormatter release];
	[super dealloc];
}

- (BOOL)articleSync
{
	return articleSyncFlag;
}
@end


