//
//  RefreshManagerGoogle.h
//  GalapagosReader
//
//  Created by Yoshitaka Sakamaki on 平成22/02/04.
//  Copyright 2010. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import <Cocoa/Cocoa.h>
#import "Database.h"
#import "Folder.h"
#import "DDXMLDocument.h"
#import "AppController.h"
#import "AsyncConnectionGoogle.h"
#import "Preferences.h"
#import "Constants.h"
#import "RefreshManager.h"
#import "StringExtensions.h"
#import "EditManagerGoogle.h"
#import "RichXMLParser.h"

@interface RefreshManagerGoogle : RefreshManager {
	BOOL updateStarItem;
}
+(RefreshManagerGoogle *)sharedManager;
-(void)subscriptionFeed:(Folder *)folder;
-(void)syncFoldersAndFeedURLs;
-(void)syncReadItem;
-(void)refreshStarItem:(Folder *)folder;
@end
