//
//  StartUpController.h
//  GalapagosReader
//
//  Created by Yoshitaka Sakamaki on 平成22/02/27.
//  Copyright 2010 MyHOME. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import <Cocoa/Cocoa.h>
#import "Database.h"
#import "AccountManager.h"
#import "LoginControllerHatena.h"

@interface StartUpController : NSWindowController {
	IBOutlet NSBox * box;
	IBOutlet NSView *googleView;
	IBOutlet NSView *hatenaView;
	IBOutlet NSView *tutorialView;
	IBOutlet NSTextField * accountNameGoogle;
	IBOutlet NSSecureTextField * passwordGoogle;
	IBOutlet NSTextField * accountNameHatena;
	IBOutlet NSSecureTextField * passwordHatena;
	IBOutlet NSButton * showTutorialButton;
	IBOutlet NSButton * showHatenaAccountButton;
	IBOutlet NSButton * acceptButtonHatena;
	IBOutlet NSButton * acceptButtonGoogle;
	IBOutlet NSButton * skipButtonGoogle;
	IBOutlet NSButton * skipButtonHatena;
	IBOutlet NSButton * previousButton;
	IBOutlet NSButton * exitStartUpButton;
}
- (void)showWindow:(id)sender;
- (IBAction) syncButtonGoogle:(id)sender;
- (IBAction) skipButtonGoogle:(id)sender;
- (IBAction) syncButtonHatena:(id)sender;
- (IBAction) skipButtonHatena:(id)sender;
- (IBAction) previousWindow:(id)sender;
- (IBAction) exitStartUp:(id)sender;
- (void)setKeyView;

@end
