//
//  SyncPreferences.m
//  GalapagosReader
//
//  Created by Yoshitaka Sakamaki on 平成22/02/09.
//  Copyright 2010 MyHOME. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import "SyncPreferences.h"
#import "ProgressWindow.h"


// Private functions
@interface SyncPreferences (Private)
	-(void)initializePreferences;
	-(NSString *)password;
@end

@implementation SyncPreferences

/* init
 * Initialize the class
 */
-(id)init
{
	// 環境設定パネルのアカウント情報を新情報に反映させる。
	NSNotificationCenter * nc = [NSNotificationCenter defaultCenter];
	[nc addObserver:self selector:@selector(handleAccountFieldRefresh:) name:@"MA_Notify_AccountFieldRefresh" object:nil];

	return [super initWithWindowNibName:@"SyncPreferences"];
}

/* windowDidLoad
 * First time window load initialisation. Since preferences could potentially be
 * changed while the Preferences window is closed, initialise the controls in the
 * initializePreferences function instead.
 */
-(void)windowDidLoad
{
	[self initializePreferences];
}

/* initializePreferences
 * Set the preference settings from the user defaults.
 */
-(void)initializePreferences
{
	// Show use sync option
	if (MA_Google_SYNC == [[Database sharedDatabase] syncFlagGoogleInfo])
		[syncGoogleChkBtn setState:YES];
	else
		[syncGoogleChkBtn setState:NO];
	
	// Show use sync option
	if (MA_Hatena_USE == [[Database sharedDatabase] useFlagHatenaInfo])
		[useHatenaChkBtn setState:YES];
	else
		[useHatenaChkBtn setState:NO];
	
	// アカウント名をテキストフィールドに設定。
	AccountManager *accountManager = [AccountManager sharedManager];
	if ( NO == [[accountManager getAccountNameGoogle] isEqualToString:@""])
		[accountNameGoogle setStringValue:[accountManager getAccountNameGoogle]];
	
	if ( NO == [[accountManager getAccountNameHatena] isEqualToString:@""])
		[accountNameHatena setStringValue:[accountManager getAccountNameHatena]];
	
	// パスワードをキーチェーンから取得し、テキストフィールドに設定。
	if (NO == [[accountManager getPasswordGoogle] isEqualToString:@""])
		[passwordGoogle setStringValue:[accountManager getPasswordGoogle]];
	
	if (NO == [[accountManager getPasswordHatena] isEqualToString:@""])
		[passwordHatena setStringValue:[accountManager getPasswordHatena]];
	
}

-(IBAction)changeSyncGoogle:(id)sender
{
	// パスワード・アカウント名の保存
	AccountManager *accountManager = [AccountManager sharedManager];
	[accountManager changeAccountGoogle:[accountNameGoogle stringValue] 
									   :[passwordGoogle stringValue]];
	
	
	BOOL syncGoogleChk = [sender state] == NSOnState;
	
	if (syncGoogleChk) 
	{
		[[Database sharedDatabase] updateSyncFlagGoogleInfo:MA_Google_SYNC];
		
		// ログイン
		BOOL loginSuccess = [[LoginControllerGoogle sharedManager] loginGoogle];
						
		if (NO == loginSuccess)
		{
			[[Database sharedDatabase] updateSyncFlagGoogleInfo:MA_Google_NOT_SYNC];
			[syncGoogleChkBtn setState:NSOffState];
			return;
		}
		

	} else {
		[[Database sharedDatabase] updateSyncFlagGoogleInfo:MA_Google_NOT_SYNC];
	}

	//EditManagerGoogleに同期フラグ変更を通知
	[[NSNotificationCenter defaultCenter] postNotificationName:@"MA_Notify_SyncFlagUpdate_Info" object:nil];

}

-(IBAction)syncGoogle:(id)sender
{		
	if ([[passwordGoogle  stringValue] isEqualToString:@""]
		||
		[[accountNameGoogle stringValue] isEqualToString:@""])
	{
		return;
	}
	
	AccountManager *accountManager = [AccountManager sharedManager];
	// パスワード・アカウント名の保存
	[accountManager changeAccountGoogle:[accountNameGoogle stringValue] 
									   :[passwordGoogle stringValue]];
		
	// ログイン
	BOOL loginSuccess = [[LoginControllerGoogle sharedManager] loginGoogle];
	if (NO == loginSuccess)
		return;
	
	// 同期フラグがOFFのFeed(GoogleReaderと同期していない購読リスト)をすべてONにし、GoogleReaderへ通知。
	[[Database sharedDatabase] updateSyncFlagGoogleRssFolders];
	
	// プログレスバーの表示
	ProgressWindow *progress = [[ProgressWindow alloc] init];
	[progress showWindow:[self window]];
	
	// 購読リストの同期
	[[RefreshManagerGoogle sharedManager] syncFoldersAndFeedURLs];
	
	// プログレスバーを閉じる
	[progress close];
	[progress release];
	
	// フィードリフレッシュ
	[[NSNotificationCenter defaultCenter] postNotificationName:@"MA_Notify_RefreshAllSubscriptions" object:nil];


}

-(IBAction)textFieldDidEndGoogleAccount:(id)sender
{
	// パスワード・アカウント名の保存
	AccountManager *accountManager = [AccountManager sharedManager];
	[accountManager changeAccountGoogle:[accountNameGoogle stringValue] 
									   :[passwordGoogle stringValue]];
	
}

-(IBAction)textFieldDidEndGooglePassword:(id)sender
{
	// パスワード・アカウント名の保存
	AccountManager *accountManager = [AccountManager sharedManager];
	[accountManager changeAccountGoogle:[accountNameGoogle stringValue] 
									   :[passwordGoogle stringValue]];
}

-(IBAction)syncHatena:(id)sender
{	
	if ([[passwordHatena  stringValue] isEqualToString:@""]
		||
		[[accountNameHatena stringValue] isEqualToString:@""])
	{
		return;
	}
	
	// パスワード・アカウント名の保存
	AccountManager *accountManager = [AccountManager sharedManager];
	[accountManager changeAccountHatena:[accountNameHatena stringValue] 
									   :[passwordHatena stringValue]];
	
	// ログイン
	BOOL loginSuccess = [[LoginControllerHatena sharedManager] loginHatena];
	if (NO == loginSuccess)
		return;
	
	// プログレスバーの表示
	ProgressWindow *progress = [[ProgressWindow alloc] init];
	[progress showWindow:[self window]];
	
	if (NSOnState == [articleSyncChkBtn state])
	{
		//ブックマーク統合：記事とブックマークをリンクさせる
		[[EditManagerHatena sharedManager] syncBookmark:MA_Sync_AllRecord :YES];
	} else {
		//ブックマーク統合：記事とブックマークをリンクさせない
		[[EditManagerHatena sharedManager] syncBookmark:MA_Sync_AllRecord :NO];
	}
	
	// プログレスバーを閉じる
	[progress close];
	[progress release];
	
}


-(IBAction)changeUseHatena:(id)sender
{
	// パスワード・アカウント名の保存
	AccountManager *accountManager = [AccountManager sharedManager];
	[accountManager changeAccountHatena:[accountNameHatena stringValue] 
									   :[passwordHatena stringValue]];
	
	BOOL useHatenaChk = [sender state] == NSOnState;

	if (useHatenaChk) {
		
		[[Database sharedDatabase] updateUseFlagHatenaInfo:MA_Hatena_USE];

		// ログイン
		BOOL loginSuccess = [[LoginControllerHatena sharedManager] loginHatena];
		if (NO == loginSuccess)
		{
			[[Database sharedDatabase] updateUseFlagHatenaInfo:MA_Hatena_NOT_USE];
			[useHatenaChkBtn setState:NSOffState];
			return;
		}
		
	} else {
		[[Database sharedDatabase] updateUseFlagHatenaInfo:MA_Hatena_NOT_USE];
	}
	
	//EditManagerHatenaにフラグ変更を通知
	[[NSNotificationCenter defaultCenter] postNotificationName:@"MA_Notify_UseFlagUpdate_Info" object:nil];
}

-(IBAction)textFieldDidEndHatenaAccount:(id)sender
{
	// パスワード・アカウント名の保存
	AccountManager *accountManager = [AccountManager sharedManager];
	[accountManager changeAccountHatena:[accountNameHatena stringValue] 
									   :[passwordHatena stringValue]];
}

-(IBAction)textFieldDidEndHatenaPassword:(id)sender
{
	// パスワード・アカウント名の保存
	AccountManager *accountManager = [AccountManager sharedManager];
	[accountManager changeAccountHatena:[accountNameHatena stringValue] 
									   :[passwordHatena stringValue]];
}

- (void) handleAccountFieldRefresh:(NSNotification *)nc
{
	// アカウント名をテキストフィールドに設定。
	AccountManager *accountManager = [AccountManager sharedManager];
	if ( NO == [[accountManager getAccountNameGoogle] isEqualToString:@""])
		[accountNameGoogle setStringValue:[accountManager getAccountNameGoogle]];
	
	if ( NO == [[accountManager getAccountNameHatena] isEqualToString:@""])
		[accountNameHatena setStringValue:[accountManager getAccountNameHatena]];
	
	// パスワードをキーチェーンから取得し、テキストフィールドに設定。
	if (NO == [[accountManager getPasswordGoogle] isEqualToString:@""])
		[passwordGoogle setStringValue:[accountManager getPasswordGoogle]];
	
	if (NO == [[accountManager getPasswordHatena] isEqualToString:@""])
		[passwordHatena setStringValue:[accountManager getPasswordHatena]];
}

-(void)dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver:self];
	[super dealloc];
}
@end
