<?php
/**
 * Ajax通信用コントローラ
 *
 * @author pippine
 *
 */
class AjaxController extends AppController {

	public $uses = array("User");
	public $components = array("UUID", "HtmlTagCheck");

	private $UPLOAD_MODE_BANNER = 0;
	private $UPLOAD_MODE_IMAGE1 = 1;

	protected function appFilter() {

	}

	public function domainCheck() {
		$message = "";
		$error = false;

		if ($this->User->findByDomain($this->data['domain'])) {
			$message = "ご指定のドメインはすでに使用されています";
			$error = true;
		} else {
			$message = "ご指定のドメインは使用できます</font>";
		}

		$this->set("error", $error);
		$this->set("message", $message);
		$this->render('domain_check','ajax');
	}

	public function upload($uploadMode) {
		if (!$this->data['User']['upload_file']) {
			$this->set('error','アップロードするファイルを選択してください');
			$this->render('upload','ajax');
		} else {
			if ($this->data['User']['upload_file']['type'] != 'image/jpeg' && $this->data['User']['upload_file']['type'] != 'image/pjpeg') {
				$this->set('error','アップロードできる画像は JPEG のみです');
				$this->render('upload','ajax');
			} else {
				$fileName = "";
				$domain = $this->UUID->v4();
				if ($uploadMode == $this->UPLOAD_MODE_BANNER) {
					$filename = '/tmp/'.$domain.'_banner.jpg';
				} else if ($uploadMode == $this->UPLOAD_MODE_IMAGE1) {
					$filename = '/tmp/'.$domain.'_image1.jpg';
				} else {
					$this->set('error','アップロードモードが不正です');
					$this->render('upload','ajax');
				}
				if ($this->Session->read("image1")) {

				}
				if (copy($this->data['User']['upload_file']['tmp_name'], WWW_ROOT.$filename)) {
					unlink($this->data['User']['upload_file']['tmp_name']);
				}
				$this->set('filename', $filename);
				$this->Session->write($this->SESSION_KEY_IMAGE1, $filename);
				$this->render('upload','ajax');
			}
		}
	}

	public function previewTagCheck($target) {
		$title = $this->data[$target];
		$this->set("cleanHtml", $this->HtmlTagCheck->removeForbiddenTag($title, 1));
		$this->render("preview_tag_check", "ajax");
	}

}