<?php
require_once(ROOT.DS.APP_DIR.'/Vendor/HTMLPurifier/HTMLPurifier.auto.php');
/**
 * HTMLタグに関する各種機能を提供するクラス
 * HTMLPurifierのラッパークラス
 *
 * @author pippine
 *
 */
class HtmlTagCheckComponent extends Component {

	// 許可タグ一覧
	private $ALLOWED_TAG = array(
		'1' => array('a', 'b', 'hr', 'br', 'font', 'center', 'table', 'tr', 'td', 'th'),
	);

	/**
	 * 指定されたタグレベルで許可されていないタグを除去する
	 * （ホワイトリストチェック）
	 *
	 * @param $input 入力HTML
	 * @param $tagLevel タグレベル
	 */
	public function removeForbiddenTag($input, $tagLevel) {
		$hp_conf = HTMLPurifier_Config::createDefault();
		$hp_conf->set('Core.Encoding', 'UTF-8');
		$hp_conf->set('Core.Language', 'ja');
		$hp_conf->set('HTML.AllowedElements', $this->ALLOWED_TAG[$tagLevel]);
		$hp = new HTMLPurifier($hp_conf);
		return $hp->purify($input);
	}

}